/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.toolbar;

import java.util.ArrayList;
import java.util.Collection;
import oracle.bpm.designer.formdesigner.PresentationDesignerPanel;
import oracle.bpm.designer.formdesigner.ToolbarListener;
import oracle.bpm.designer.formdesigner.toolbar.ChangePresentationAction;
import oracle.bpm.designer.formdesigner.toolbar.FormatActionManager;
import oracle.bpm.designer.formdesigner.toolbar.FormatToolbarManager;
import oracle.bpm.draw.Color;
import oracle.bpm.ui.Timer;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.colorchoosingcomponent.ColorsPopUp;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.CustomEvent;
import oracle.bpm.ui.event.CustomEventListener;
import oracle.bpm.ui.msg.UIMsg;

class ColorManager
implements FormatActionManager {
    private Color bgColor = null;
    private PresentationDesignerPanel designPanel;
    private Color fgColor = null;

    public ColorManager(PresentationDesignerPanel designPanel) {
        this.designPanel = designPanel;
    }

    @Override
    public Collection<? extends BaseAction> createActions(FormatToolbarManager toolbarManager, ToolBar formatToolbar) {
        ArrayList<Object> actions = new ArrayList<Object>();
        actions.addAll(this.createColorActions(toolbarManager, formatToolbar, 2048));
        actions.addAll(this.createColorActions(toolbarManager, formatToolbar, 1024));
        return actions;
    }

    @Override
    public void refresh(FormatToolbarManager manager, ToolbarListener.ToolbarInteractions toolbarInteractions) {
    }

    @Override
    public void setAvaliable(boolean isReadWrite, int avaliableActions) {
    }

    private Color getColor(int wich) {
        if (wich == 2048) {
            return this.bgColor;
        }
        if (wich == 1024) {
            return this.fgColor;
        }
        throw new IllegalArgumentException();
    }

    private void setColor(int wich, Color color) {
        if (wich == 2048) {
            this.bgColor = color;
        } else if (wich == 1024) {
            this.fgColor = color;
        } else {
            throw new IllegalArgumentException();
        }
    }

    private Collection<? extends BaseAction> createColorActions(FormatToolbarManager toolbarManager, ToolBar formatToolbar, int modifier) {
        ArrayList<BaseAction> actions = new ArrayList<BaseAction>();
        class ChangeColorAction
        extends ChangePresentationAction {
            private int modifier;

            public ChangeColorAction(FormatToolbarManager toolbarManager, int modifier) {
                super(toolbarManager, modifier == 2048 ? UIMsg.BGROUND : UIMsg.FGROUND);
                this.putValue("Toolbar modifier", modifier);
                this.modifier = modifier;
            }

            @Override
            public void doUpdate() {
                Color c = ColorManager.this.getColor(this.modifier);
                if (c == null) {
                    ColorManager.this.setColor(this.modifier, ColorManager.this.showColor(c));
                }
                ColorManager.this.setColor(this.modifier, this.getToolbarInteractions());
            }
        }
        ChangeColorAction bgAction = new ChangeColorAction(toolbarManager, modifier);
        class ChangeDropDownColorAction
        extends BaseAction {
            private int modifier;
            public Timer timer;
            private FormatToolbarManager toolbarManager;

            public ChangeDropDownColorAction(FormatToolbarManager toolbarManager, int modifier) {
                super(modifier == 2048 ? UIMsg.BGROUND : UIMsg.FGROUND);
                this.toolbarManager = toolbarManager;
                this.putValue("Toolbar modifier", modifier);
                this.modifier = modifier;
            }

            public void actionPerformed(ActionEvent event) {
                ColorsPopUp popup = new ColorsPopUp(ColorManager.this.designPanel.getOwnerWindow());
                popup.addCustomEventListener((CustomEventListener)new CustomEventListener<Color>(){

                    public void eventChanged(CustomEvent<Color> customEvent) {
                        Color temp = (Color)customEvent.getNewValue();
                        if (temp != null) {
                            ColorManager.this.setColor(modifier, temp);
                            ColorManager.this.setColor(modifier, toolbarManager.getToolbarInteractions());
                        }
                        toolbarManager.refreshProperties();
                        toolbarManager.getPresentationDesignerPanel().setDirty(true);
                    }
                });
                popup.showPopUp(event.getSource(), ColorManager.this.getColor(this.modifier));
            }
        }
        ChangeDropDownColorAction bgDropDownAction = new ChangeDropDownColorAction(toolbarManager, modifier);
        actions.add(bgAction);
        actions.add(bgDropDownAction);
        formatToolbar.addCompositeButton((BaseAction)bgAction, (BaseAction)bgDropDownAction);
        return actions;
    }

    private Color showColor(Color color) {
        return this.designPanel.showColor(color);
    }

    private void setColor(int wich, ToolbarListener.ToolbarInteractions interactions) {
        if (wich == 2048) {
            this.setBgColor(interactions);
        } else {
            this.setFgColor(interactions);
        }
    }

    private void setBgColor(ToolbarListener.ToolbarInteractions interactions) {
        if (this.bgColor != null && interactions != null) {
            interactions.setBackGround(this.bgColor);
        }
    }

    private void setFgColor(ToolbarListener.ToolbarInteractions interactions) {
        if (this.fgColor != null && interactions != null) {
            interactions.setForeGround(this.fgColor);
        }
    }
}

