/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.toolbar;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.bpm.designer.formdesigner.ToolbarListener;
import oracle.bpm.designer.formdesigner.toolbar.ChangeAlignmentAction;
import oracle.bpm.designer.formdesigner.toolbar.FormatActionManager;
import oracle.bpm.designer.formdesigner.toolbar.FormatToolbarManager;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.ToolBarItem;
import oracle.bpm.ui.action.BaseAction;

class AlignManager
implements FormatActionManager {
    private ToolBarItem alignCenterToogle;
    private ToolBarItem alignLeftToogle;
    private ToolBarItem alignRightToogle;

    AlignManager() {
    }

    @Override
    public Collection<? extends BaseAction> createActions(FormatToolbarManager toolbarManager, ToolBar formatToolbar) {
        ArrayList<BaseAction> result = new ArrayList<BaseAction>();
        BaseAction leftAlignAction = this.createAction(result, toolbarManager, DesignerMsg.LEFT, "left");
        this.alignLeftToogle = formatToolbar.addRadioButton(leftAlignAction);
        BaseAction centerAlignAction = this.createAction(result, toolbarManager, DesignerMsg.CENTER, "center");
        this.alignCenterToogle = formatToolbar.addRadioButton(centerAlignAction);
        BaseAction rightAlignAction = this.createAction(result, toolbarManager, DesignerMsg.RIGHT, "right");
        this.alignRightToogle = formatToolbar.addRadioButton(rightAlignAction);
        return result;
    }

    @Override
    public void refresh(FormatToolbarManager manager, ToolbarListener.ToolbarInteractions toolbarInteractions) {
        this.refreshAlign(toolbarInteractions.getAlignment());
    }

    @Override
    public void setAvaliable(boolean isReadWrite, int avaliableActions) {
    }

    private BaseAction createAction(List<BaseAction> actions, FormatToolbarManager toolbarManager, Msg alignMsg, String align) {
        ChangeAlignmentAction result = new ChangeAlignmentAction(toolbarManager, alignMsg, align);
        actions.add(result);
        return result;
    }

    private void refreshAlign(String alignment) {
        this.alignLeftToogle.setSelected("left".equals(alignment));
        this.alignCenterToogle.setSelected("center".equals(alignment));
        this.alignRightToogle.setSelected("right".equals(alignment));
    }
}

