/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.properties;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import oracle.bpm.designer.formdesigner.ChangeListener;
import oracle.bpm.designer.formdesigner.properties.ComponentInteractionProvider;
import oracle.bpm.designer.formdesigner.properties.GraphicComponentProperties;
import oracle.bpm.designer.formdesigner.properties.RepeatableComponentProperties;
import oracle.bpm.designer.formdesigner.properties.SimpleComponentProperties;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.draw.Color;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.Argument;
import oracle.bpm.ui.ColorChooser;
import oracle.bpm.ui.ColorInfo;
import oracle.bpm.ui.ColorProvider;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.ListSelectionMode;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.TableModelEvent;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.prop.AbstractProperty;
import oracle.bpm.ui.prop.Factory;
import oracle.bpm.ui.prop.Property;
import oracle.bpm.ui.prop.PropertyEditor;
import oracle.bpm.ui.prop.PropertyRenderer;
import oracle.bpm.ui.prop.impl.ComboProperty;
import oracle.bpm.ui.prop.impl.DefaultPropertyRenderer;
import oracle.bpm.ui.table.AbstractTableModel;
import oracle.bpm.ui.table.Table;
import oracle.bpm.ui.table.TableColumn;
import oracle.bpm.ui.table.TableModel;
import oracle.bpm.ui.utils.ColorUtils;
import oracle.bpm.xobject.GraphicType;
import oracle.bpm.xobject.Utilities;
import oracle.bpm.xobject.lib.XYZDataSource;
import oracle.bpm.xobject.presentationmodel.XFormChart;
import oracle.bpm.xobject.presentationmodel.XFormGraphic;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;

public class XYZComponentProperties
extends GraphicComponentProperties {
    private AbstractProperty autoAdd;
    private AbstractProperty autoRangeIncludesZero;
    private Property categoryLabel;
    private ComboProperty itemLabelMaskProperty;
    private AbstractProperty totalName;
    private Property valueLabel;
    private static Vector values;

    public XYZComponentProperties(XFormPresentationXMLObject object, ComponentInteractionProvider componentInteractionProvider, ChangeListener listener) {
        super(object, componentInteractionProvider, listener);
    }

    public static Color getColor(String color) {
        return ColorUtils.getColor((String)color);
    }

    @Override
    public Vector<String> getMethods() {
        ObjectTypeDescription otd = this.getComponentInteractionProvider().getObjectTypeDescription();
        List<MethodTypeDescription> methods = otd.getMethods();
        Vector<String> values = new Vector<String>();
        for (MethodTypeDescription method : methods) {
            if (method.getArgumentCount() != 0 || !this.isGraphType(method.getResultType())) continue;
            values.add(method.getSignature());
        }
        return values;
    }

    @Override
    protected Vector<String> getClickMethods() {
        ObjectTypeDescription otd = this.getComponentInteractionProvider().getObjectTypeDescription();
        List<MethodTypeDescription> methods = otd.getMethods();
        Vector<String> values = new Vector<String>();
        for (MethodTypeDescription method : methods) {
            if (!this.canClick(method.getArguments())) continue;
            values.add(method.getSignature());
        }
        return values;
    }

    @Override
    protected Vector getCtrlClickMethods() {
        return this.getClickMethods();
    }

    protected boolean isGraphType(TypeDescription resultType) {
        return resultType.getJavaClass() != null && XYZDataSource.class.isAssignableFrom(resultType.getJavaClass());
    }

    @Override
    protected Vector getSortedValues() {
        if (values == null) {
            Vector<GraphicType> result;
            List<GraphicType> list = GraphicType.getSubtypes("XYZ");
            values = result = new Vector<GraphicType>(list);
        }
        return values;
    }

    protected void addOrderProperty() {
        XFormChart chart = (XFormChart)this.getReferencedObject();
        final Vector<Msg> orderValues = new Vector<Msg>();
        orderValues.add(DesignerMsg.HORIZONTAL);
        orderValues.add(DesignerMsg.VERTICAL);
        SimpleComponentProperties.PreParser parser = new SimpleComponentProperties.PreParser(){

            @Override
            public Object preParse(Object val) {
                Integer value = null;
                if (val != null && val != Property.NULL_VALUE) {
                    value = orderValues.indexOf(val);
                }
                return value;
            }
        };
        this.addProperty((Property)Factory.createCombo((Msg)DesignerMsg.PROPERTY_PLOT_ORIENTATION, orderValues, (int)chart.getOrder()), "order", parser);
    }

    protected boolean canBePie(GraphicType type) {
        return false;
    }

    protected boolean canBeWaterfall(GraphicType type) {
        return type == GraphicType.WATERFALL_CHART || this.hasDynamicType();
    }

    protected boolean canClick(int argumentCount) {
        return argumentCount == 0 || argumentCount == 2;
    }

    @Override
    protected void changedGraphicType(Object o) {
        GraphicType type = null;
        if (o instanceof String) {
            type = GraphicType.valueOf((String)o);
        } else if (o instanceof GraphicType) {
            type = (GraphicType)o;
        }
        this.autoRangeIncludesZero.setEditable(!this.canBePie(type));
        this.itemLabelMaskProperty.setEditable(this.canBePie(type));
        this.autoAdd.setEditable(this.canBeWaterfall(type));
        this.totalName.setEditable(this.canBeWaterfall(type));
        this.categoryLabel.setEditable(!this.canBePie(type));
        this.valueLabel.setEditable(!this.canBePie(type));
    }

    protected boolean hasDynamicType() {
        return ((XFormGraphic)this.getReferencedObject()).hasdynamictype;
    }

    @Override
    protected void initProperties() {
        super.initProperties();
        XFormChart chart = (XFormChart)this.getReferencedObject();
        this.addColorProperty(DesignerMsg.PROPERTY_SHADOW_COLOR, "shadowcolor", chart.shadowcolor);
        this.addColorProperty(DesignerMsg.PROPERTY_PLOTBGCOLOR, "plotbgcolor", chart.plotbgcolor);
        this.addColorProperty(DesignerMsg.PROPERTY_PLOT_OUTLINE_COLOR, "plotoutlinecolor", chart.plotoutlinecolor);
        this.autoRangeIncludesZero = Factory.createBoolean((Msg)DesignerMsg.PROPERTY_AUTORANGE_INCLUDES_ZERO, (boolean)chart.getAutorangeincludeszero());
        this.addProperty((Property)this.autoRangeIncludesZero, "autorangeincludeszero");
        this.autoRangeIncludesZero.setEditable(!this.canBePie(chart.getEnumType()));
        boolean isWaterfall = this.canBeWaterfall(chart.getEnumType());
        this.autoAdd = Factory.createBoolean((Msg)DesignerMsg.PROPERTY_ADD_TOTAL, (boolean)chart.getAddTotal());
        this.totalName = Factory.createText((Msg)DesignerMsg.PROPERTY_TOTAL_NAME, (String)chart.getTotalName(), (boolean)false);
        this.addProperty((Property)this.autoAdd, "addtotal");
        this.autoAdd.setEditable(isWaterfall);
        this.addProperty((Property)this.totalName, "totalname");
        this.totalName.setEditable(isWaterfall);
        ColorsProperty property = new ColorsProperty(DesignerMsg.PROPERTY_CONTENT_COLOR, chart);
        this.addProperty((Property)property, "seriescolors", RepeatableComponentProperties.getHolderPreParser());
        this.addOrderProperty();
        this.addItemLabelMaskProperty();
        this.addCategoryLabelProperty();
        this.addValueLabelProperty();
    }

    private static String getString(Color color) {
        return Utilities.getString((ColorInfo)color.getInfo());
    }

    private void addItemLabelMaskProperty() {
        XFormChart chart = (XFormChart)this.getReferencedObject();
        final Vector<Msg> values = new Vector<Msg>();
        final Vector<String> realValues = new Vector<String>();
        values.add(DesignerMsg.PROPERTY_ITEM_LABEL_MASK_NONE);
        realValues.add("");
        values.add(DesignerMsg.PROPERTY_ITEM_LABEL_MASK_FULL);
        realValues.add("{0} = {1}");
        values.add(DesignerMsg.PROPERTY_ITEM_LABEL_MASK_NAME);
        realValues.add("{0}");
        values.add(DesignerMsg.PROPERTY_ITEM_LABEL_MASK_VALUE);
        realValues.add("{1}");
        values.add(DesignerMsg.PERCENTAGE);
        realValues.add("{0} = {2}");
        String value = chart.itemlabelmask == null ? "" : chart.itemlabelmask;
        int index = realValues.indexOf(value);
        this.itemLabelMaskProperty = Factory.createCombo((Msg)DesignerMsg.PROPERTY_ITEM_LABEL_MASK, values, (int)index);
        SimpleComponentProperties.PreParser parser = new SimpleComponentProperties.PreParser(){

            @Override
            public Object preParse(Object val) {
                return realValues.get(values.indexOf(val));
            }
        };
        this.addProperty((Property)this.itemLabelMaskProperty, "itemlabelmask", parser);
        this.itemLabelMaskProperty.setEditable(this.canBePie(chart.getEnumType()));
    }

    private boolean canClick(Argument[] arguments) {
        if (this.canClick(arguments.length)) {
            for (Argument argument : arguments) {
                if (argument.getType().isString()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void addValueLabelProperty() {
        XFormChart chart = (XFormChart)this.getReferencedObject();
        this.valueLabel = this.createTranslatable(DesignerMsg.VALUE_LABEL, chart.getValuelabel());
        this.addProperty(this.valueLabel, "valuelabel");
    }

    private void addCategoryLabelProperty() {
        XFormChart chart = (XFormChart)this.getReferencedObject();
        this.categoryLabel = this.createTranslatable(DesignerMsg.CATEGORY_LABEL, chart.getCategorylabel());
        this.addProperty(this.categoryLabel, "categorylabel");
    }

    private static class LabelAndColorProvider
    extends LabelProvider.Default<String>
    implements ColorProvider<String> {
        private static final Color NO_COLOR = Color.WHITE;

        private LabelAndColorProvider() {
        }

        public String getText(String element) {
            Color color = this.getColor(element);
            String text = color == null ? UIMsg.PROPERTY_NO_COLOR.getString() : "[ r=" + color.getRed() + ", g=" + color.getGreen() + ", b=" + color.getBlue() + " ]";
            return text;
        }

        public Color getBackground(String element) {
            return null;
        }

        public Color getForeground(String element) {
            Color color = this.getColor(element);
            return color == null ? NO_COLOR : color;
        }

        private Color getColor(String value) {
            Color color;
            Color result = null;
            if (value != null && (color = XYZComponentProperties.getColor(value)) != null) {
                result = color;
            }
            return result;
        }
    }

    private static class ColorsPropertyEditor
    extends RepeatableComponentProperties.ArrayPropertiesEditor {
        private ColorsPropertyEditor() {
        }

        @Override
        public void startEdit(final UiContainer parent) {
            OkCancelDialog dialog = new OkCancelDialog(Ui.getRoot(), DesignerMsg.PROPERTY_CONTENT_COLOR, true){

                public void ok() {
                    this.close();
                }
            };
            String[] headers = (String[])((RepeatableComponentProperties.ArrayHolder)this.getProperty().getValue()).get();
            final ArrayList<String> list = new ArrayList<String>();
            for (String header : headers) {
                list.add(header);
            }
            AbstractTableModel arrayModel = new AbstractTableModel(){

                public String getColumnName(int column) {
                    return DesignerMsg.PROPERTY_CONTENT_COLOR.getString();
                }

                public int getRowCount() {
                    return list.size();
                }

                public int getColumnCount() {
                    return 1;
                }

                public Object getValueAt(int rowIndex, int columnIndex) {
                    return list.get(rowIndex);
                }
            };
            Panel pane = new Panel(dialog.getContentPane());
            final Table table = new Table((UiContainer)pane, (TableModel)arrayModel, ListSelectionMode.SINGLE_SELECTION);
            TableColumn column = table.getColumn(0);
            LabelAndColorProvider labelProvider = new LabelAndColorProvider();
            column.setLabelProvider((LabelProvider)labelProvider);
            column.setColorProvider((ColorProvider)labelProvider);
            final BaseAction editAction = new BaseAction(UIMsg.EDIT){

                public void run() {
                    int row = table.getSelectedRow();
                    if (row >= 0) {
                        String value = (String)list.get(row);
                        Color val = XYZComponentProperties.getColor(value);
                        if ((val = ColorChooser.showDialog((UiComponent)parent, (Color)val)) != null) {
                            String newValue = XYZComponentProperties.getString(val);
                            list.set(row, newValue);
                        }
                    }
                }
            };
            BaseAction addAction = new BaseAction(UIMsg.ADD){

                public void actionPerformed(ActionEvent e) {
                    int row = table.getSelectedRow();
                    if (row < 0) {
                        list.add("#000000");
                        table.tableChanged(new TableModelEvent(table.getModel()));
                        table.setSelectionInterval(list.size() - 1, list.size() - 1);
                    } else {
                        list.add(row + 1, "#000000");
                        table.tableChanged(new TableModelEvent(table.getModel()));
                        table.setSelectionInterval(row + 1, row + 1);
                    }
                    editAction.actionPerformed(e);
                }
            };
            BaseAction removeAction = new BaseAction(UIMsg.REMOVE){

                public void actionPerformed(ActionEvent e) {
                    int row = table.getSelectedRow();
                    if (row >= 0) {
                        int newRow;
                        list.remove(row);
                        table.tableChanged(new TableModelEvent(table.getModel()));
                        int n = newRow = row > 0 ? row - 1 : row;
                        if (newRow < list.size()) {
                            table.setSelectionInterval(newRow, newRow);
                        }
                    }
                }
            };
            ToolBar buttonPanel = new ToolBar((UiContainer)pane);
            buttonPanel.add(addAction);
            buttonPanel.add(removeAction);
            buttonPanel.add(editAction, 1);
            pane.setLayout((Layout)new BorderLayout());
            pane.add((UiComponent)buttonPanel, (Object)"North");
            pane.add((UiComponent)table, (Object)"Center");
            dialog.getContentPane().add((UiComponent)pane, (Object)"Center");
            dialog.setSize(200, 250);
            dialog.setResizable(false);
            dialog.setLocationRelativeTo((UiComponent)Ui.getRoot());
            dialog.setVisible(true);
            boolean result = dialog.userAccepted();
            if (result) {
                Object[] newValue = list.toArray(new String[list.size()]);
                RepeatableComponentProperties.ArrayHolder newEditorValue = new RepeatableComponentProperties.ArrayHolder(newValue, newValue.length);
                this.editorValueChanged(newEditorValue);
                this.stopCellEditing();
            } else {
                this.cancelCellEditing();
            }
        }
    }

    private static class ColorsProperty
    extends AbstractProperty {
        private String[] colors;

        public ColorsProperty(Msg msg, XFormChart repeatable) {
            this.colors = repeatable.seriescolors;
            if (this.colors == null) {
                this.colors = new String[0];
            }
            this.setKey(msg);
            this.setValue(new RepeatableComponentProperties.ArrayHolder(this.colors, this.colors.length));
            DefaultPropertyRenderer renderer = new DefaultPropertyRenderer();
            ColorsPropertyEditor editor = new ColorsPropertyEditor();
            this.setPropertyRenderer((PropertyRenderer)renderer);
            this.setPropertyEditor((PropertyEditor)editor);
        }
    }
}

