/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.properties;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import oracle.bpm.designer.formdesigner.ChangeListener;
import oracle.bpm.designer.formdesigner.command.Command;
import oracle.bpm.designer.formdesigner.command.CompoundCommand;
import oracle.bpm.designer.formdesigner.command.ModifyPropertyValueCommand;
import oracle.bpm.designer.formdesigner.properties.ComponentInteractionProvider;
import oracle.bpm.designer.formdesigner.properties.ReferenceableComponentProperties;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.prop.Factory;
import oracle.bpm.ui.prop.Property;
import oracle.bpm.ui.prop.impl.BooleanProperty;
import oracle.bpm.ui.prop.impl.TextProperty;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.presentationmodel.XFormText;

public class TextComponentProperties
extends ReferenceableComponentProperties {
    public TextComponentProperties(XFormPresentationXMLObject referencedObject, ComponentInteractionProvider componentInteractionProvider, ChangeListener listener) {
        super(referencedObject, componentInteractionProvider, listener);
    }

    @Override
    protected void initProperties() {
        this.properties_d = new ArrayList();
        XFormText text = (XFormText)this.getReferencedObject();
        this.addIdProperty(text.getId());
        Property referenceProperty = this.createReferenceProperty(text.getReference());
        referenceProperty.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object oldValue = evt.getOldValue();
                Object newValue = evt.getNewValue();
                if (oldValue != null && !oldValue.equals(newValue) || oldValue == null && newValue != null) {
                    TextComponentProperties.this.referenceChanged((String)newValue);
                }
            }
        });
        this.properties_d.add(referenceProperty);
        this.addOnChangeProperty(text.onchange);
        this.addValidationMessageProperty(text.validationmessage);
        this.addPasswordProperty(text.passwordfield);
        this.addRequiredProperty(text.required);
        this.addEditableProperty(text.editable);
        this.addTabIndexProperty(text.getTabindex());
        this.addDisplayAsLabelProperty(text.displayaslabel);
        this.addAlignmentProperty(text.alignment);
        this.addColumnNoProperty(text.getColqty());
        this.addOutputMaskProperty(text.getOutputmask(), text.getOutputmasktype());
        TextProperty mask = Factory.createText((Msg)DesignerMsg.PROPERTY_MASK, (String)text.mask, (boolean)false);
        this.addProperty(DesignerMsg.PROPERTY_MASK_INPUT, (Property)mask, "mask");
        Property maskErrorMessage = this.createLongTranslatable(DesignerMsg.PROPERTY_MASKERRORMESSAGE, text.maskerrormessage);
        this.addProperty(DesignerMsg.PROPERTY_MASK_INPUT, maskErrorMessage, "maskErrorMessage");
        this.addColorProperty(DesignerMsg.PROPERTY_MASK_INPUT, DesignerMsg.PROPERTY_MASKERRORCOLOR, "maskerrorcolor", text.maskerrorcolor);
        TextProperty inputPattern = Factory.createText((Msg)DesignerMsg.PROPERTY_INPUTPATTERN, (String)text.inputpattern, (boolean)false);
        this.addProperty(DesignerMsg.PROPERTY_INPUTPATTERN, (Property)inputPattern, "inputpattern");
        Property inputPatternErrorMessage = this.createLongTranslatable(DesignerMsg.PROPERTY_INPUTPATTERNERRORMESSAGE, text.inputpatternerrormessage);
        this.addProperty(DesignerMsg.PROPERTY_INPUTPATTERN, inputPatternErrorMessage, "inputpatternerrormessage");
        this.addColorProperty(DesignerMsg.PROPERTY_INPUTPATTERN, DesignerMsg.PROPERTY_INPUTPATTERNERRORCOLOR, "inputpatternerrorcolor", text.inputpatternerrorcolor);
        this.referenceChanged(text.reference, false);
        this.addFontProperty(text.fonttype, text.getFontStyle(), text.fontsize);
        this.addBackgroundColorProperty(text.bgcolor);
        this.addForegroundColorProperty(text.fgcolor);
        this.addSimpleBorderProperty(text.getBorderstyle(), text.borderwidth, text.bordercolor);
    }

    protected void referenceChanged(String newValue) {
        this.referenceChanged(newValue, true);
    }

    protected void referenceChanged(final String newValue, final boolean invokeCommands) {
        UiUtilities.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                TextComponentProperties.this.changeReference(newValue, invokeCommands);
            }
        });
    }

    private Command getResetPropertyCommand(String propertyName) {
        return new ModifyPropertyValueCommand(this.getReferencedObject(), "", propertyName, this.listener_d);
    }

    private void addDisplayAsLabelProperty(boolean isDisplayAsLabel) {
        BooleanProperty displayAsLabelProperty = Factory.createBoolean((Msg)DesignerMsg.DISPLAY_AS_LABEL, (boolean)isDisplayAsLabel);
        this.addProperty((Property)displayAsLabelProperty, "displayaslabel");
    }

    private void addPasswordProperty(boolean isPasswordField) {
        BooleanProperty editable = Factory.createBoolean((Msg)LibMsg.PROPERTY_PASSWORDFIELD, (boolean)isPasswordField);
        this.addProperty((Property)editable, "passwordfield");
    }

    private void changeReference(String newValue, boolean invokeCommands) {
        AttributeTypeDescription ref = null;
        if (newValue != null && (ref = this.getReference(newValue)) == null) {
            newValue = null;
        }
        ModifyPropertyValueCommand referenceCommand = new ModifyPropertyValueCommand(this.getReferencedObject(), newValue, "reference", this.listener_d);
        if (newValue != null && (ref.getResultType().isString() || ref.getResultType().isNumber())) {
            if (ref.getResultType().isString()) {
                this.showGroup(DesignerMsg.PROPERTY_INPUTPATTERN);
                this.showGroup(DesignerMsg.PROPERTY_MASK_INPUT);
            } else if (ref.getResultType().isInt()) {
                this.hideGroup(DesignerMsg.PROPERTY_INPUTPATTERN);
                this.showGroup(DesignerMsg.PROPERTY_MASK_INPUT);
            } else {
                this.hideGroup(DesignerMsg.PROPERTY_INPUTPATTERN);
                this.hideGroup(DesignerMsg.PROPERTY_MASK_INPUT);
            }
            this.showGroup(DesignerMsg.PROPERTY_MASK_OUTPUT);
            if (invokeCommands) {
                this.invokeCommand(referenceCommand);
            }
            return;
        }
        this.hideGroup(DesignerMsg.PROPERTY_INPUTPATTERN);
        this.hideGroup(DesignerMsg.PROPERTY_MASK_INPUT);
        this.hideGroup(DesignerMsg.PROPERTY_MASK_OUTPUT);
        if (invokeCommands) {
            ArrayList<Command> list = new ArrayList<Command>();
            list.add(this.getResetPropertyCommand("inputpattern"));
            list.add(this.getResetPropertyCommand("inputpattern"));
            list.add(this.getResetPropertyCommand("inputpatternerrorcolor"));
            list.add(this.getResetPropertyCommand("inputpatternerrormessage"));
            list.add(this.getResetPropertyCommand("mask"));
            list.add(this.getResetPropertyCommand("maskerrorcolor"));
            list.add(this.getResetPropertyCommand("maskerrormessage"));
            list.add(this.getResetPropertyCommand("outputmask"));
            list.add(referenceCommand);
            CompoundCommand commpound = new CompoundCommand(list, referenceCommand.getMsg());
            this.invokeCommand(commpound);
        }
    }
}

