/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.properties;

import java.util.ArrayList;
import oracle.bpm.designer.formdesigner.ChangeListener;
import oracle.bpm.designer.formdesigner.properties.ComponentInteractionProvider;
import oracle.bpm.designer.formdesigner.properties.SimpleComponentProperties;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.prop.Factory;
import oracle.bpm.ui.prop.Property;
import oracle.bpm.ui.prop.impl.NumericProperty;
import oracle.bpm.ui.prop.impl.TextProperty;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.presentationmodel.XFormTable;

public class TableComponentProperties
extends SimpleComponentProperties {
    private ComponentInteractionProvider componentInteractionProvider;

    public TableComponentProperties(XFormPresentationXMLObject referencedObject, ComponentInteractionProvider componentInteractionProvider, ChangeListener listener) {
        super(referencedObject, componentInteractionProvider, listener);
        this.componentInteractionProvider = componentInteractionProvider;
    }

    @Override
    protected void initProperties() {
        this.properties_d = new ArrayList();
        XFormTable referencedTable = (XFormTable)this.getReferencedObject();
        this.addIdProperty(referencedTable.id);
        TextProperty tableWidth = Factory.createText((Msg)DesignerMsg.PROPERTY_WIDTH, (String)referencedTable.width, (boolean)false);
        this.addProperty((Property)tableWidth, "width");
        boolean isTopLevelTable = this.componentInteractionProvider.isTopLevel(referencedTable);
        if (isTopLevelTable) {
            this.addAlignmentProperty(referencedTable.alignment);
        }
        NumericProperty cellPaddingProperty = Factory.createIntegerNumber((Msg)DesignerMsg.PROPERTY_CELLPADDING, (int)referencedTable.cellpadding, (int)0, (int)50, (int)1);
        this.addProperty(DesignerMsg.LAYOUT, (Property)cellPaddingProperty, "cellpadding");
        NumericProperty cellSpacingProperty = Factory.createIntegerNumber((Msg)DesignerMsg.PROPERTY_CELLSPACING, (int)referencedTable.cellspacing, (int)0, (int)72, (int)1);
        this.addProperty(DesignerMsg.LAYOUT, (Property)cellSpacingProperty, "cellspacing");
        this.addColumnWidthProperty(referencedTable);
        this.addFullBorderProperty(referencedTable);
    }

    private void addColumnWidthProperty(XFormTable table) {
        StringBuffer arrayWidthBuffer = new StringBuffer();
        int colQty = table.getModelTotalColumns();
        for (int col = 0; col < colQty; ++col) {
            String width;
            String string = width = table.columnwidth != null && col < table.columnwidth.length ? String.valueOf(table.columnwidth[col]) : "";
            if (col > 0) {
                arrayWidthBuffer.append(",");
            }
            arrayWidthBuffer.append(width);
        }
        TextProperty coloumnsWidth = Factory.createText((Msg)DesignerMsg.PROPERTY_COLUMN_WIDTH, (String)arrayWidthBuffer.toString(), (boolean)false);
        this.addProperty((Property)coloumnsWidth, "columnwidth", TableComponentProperties.getWidthArrayPreparser());
    }
}

