/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.properties;

import java.beans.PropertyChangeEvent;
import java.util.Arrays;
import java.util.List;
import oracle.bpm.designer.DesignerApplication;
import oracle.bpm.designer.formdesigner.properties.ExternalDialogPropertyEditor;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.layout.FlowLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.prop.AbstractProperty;
import oracle.bpm.ui.prop.Property;
import oracle.bpm.ui.prop.PropertyEditor;
import oracle.bpm.ui.prop.PropertyRenderer;
import oracle.bpm.ui.prop.impl.DefaultPropertyRenderer;
import oracle.bpm.ui.text.NumericField;

public class SizeProperty
extends AbstractProperty {
    private static String[] sizeUnits = new String[]{"%", "em", "ex", "px", "in", "cm", "mm", "pt", "pc"};

    public SizeProperty(Msg msg, String value) {
        this.setKey(msg);
        this.setValue(value);
        DefaultPropertyRenderer renderer = new DefaultPropertyRenderer();
        SizePropertyEditor editor = new SizePropertyEditor((Property)this);
        this.setPropertyRenderer((PropertyRenderer)renderer);
        this.setPropertyEditor((PropertyEditor)editor);
    }

    public void valueChanged() {
        this.firePropertyChanged(new PropertyChangeEvent((Object)this, this.getKey(), this.getOldValue(), this.getValue()));
    }

    private static class SizePropertyEditor
    extends ExternalDialogPropertyEditor {
        private String editorValue;
        private List values = Arrays.asList(SizeProperty.access$000());

        public SizePropertyEditor(Property property) {
        }

        public Object getCellEditorValue() {
            return this.editorValue;
        }

        @Override
        public String getPropertyValueRepresentation(Property property) {
            return property.getValue() == null ? "" : property.getValue().toString();
        }

        @Override
        public void startEdit(UiContainer parent) {
            String currentValue;
            OkCancelDialog choose = new OkCancelDialog((UiWindow)DesignerApplication.getInstance(), true){

                public void ok() {
                    this.setUserAccepted(true);
                    this.close();
                }
            };
            Panel centerPanel = new Panel(choose.getContentPane());
            NumericField numericSpinner = NumericField.createIntegerNumericField((UiContainer)centerPanel);
            ComboBox unitCombo = UiFactory.createComboBox((UiContainer)centerPanel, (List)this.values);
            centerPanel.setLayout((Layout)new FlowLayout());
            centerPanel.add((UiComponent)numericSpinner);
            centerPanel.add((UiComponent)unitCombo);
            Object propertyValue = this.getProperty().getValue();
            if (propertyValue instanceof String && (currentValue = (String)propertyValue) != null) {
                for (int i = 0; i < sizeUnits.length; ++i) {
                    if (!currentValue.endsWith(sizeUnits[i])) continue;
                    currentValue = currentValue.substring(0, currentValue.indexOf(sizeUnits[i]));
                    unitCombo.setSelectedItem((Object)sizeUnits[i]);
                    break;
                }
                try {
                    int value = Integer.parseInt(currentValue);
                    numericSpinner.setValue((Number)value);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            choose.getContentPane().add((UiComponent)centerPanel, (Object)"Center");
            choose.pack();
            choose.setVisible(true);
            if (choose.userAccepted()) {
                this.editorValue = numericSpinner.getValue() + "" + unitCombo.getSelectedItem();
                this.stopCellEditing();
            } else {
                this.cancelCellEditing();
            }
        }
    }
}

