/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.properties;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Pattern;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.data.html.OutputMaskType;
import oracle.bpm.designer.formdesigner.ChangeListener;
import oracle.bpm.designer.formdesigner.CommandManager;
import oracle.bpm.designer.formdesigner.FontDecoder;
import oracle.bpm.designer.formdesigner.command.Command;
import oracle.bpm.designer.formdesigner.command.ModifyPropertyValueCommand;
import oracle.bpm.designer.formdesigner.properties.BorderHelper;
import oracle.bpm.designer.formdesigner.properties.ComponentInteractionProvider;
import oracle.bpm.designer.formdesigner.properties.ComponentProperties;
import oracle.bpm.designer.formdesigner.properties.ImageFileProperty;
import oracle.bpm.designer.formdesigner.properties.PresentationComponentProperties;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.Font;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.BorderStyle;
import oracle.bpm.ui.ColorInfo;
import oracle.bpm.ui.FontProvider;
import oracle.bpm.ui.FontStyle;
import oracle.bpm.ui.TreeTableFontProvider;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.prop.AbstractProperty;
import oracle.bpm.ui.prop.Factory;
import oracle.bpm.ui.prop.Property;
import oracle.bpm.ui.prop.PropertyEditor;
import oracle.bpm.ui.prop.PropertyGroup;
import oracle.bpm.ui.prop.PropertyTable;
import oracle.bpm.ui.prop.PropertyTablePanel;
import oracle.bpm.ui.prop.impl.BooleanProperty;
import oracle.bpm.ui.prop.impl.BorderProperty;
import oracle.bpm.ui.prop.impl.ColorProperty;
import oracle.bpm.ui.prop.impl.ColorPropertyEditor;
import oracle.bpm.ui.prop.impl.ComboProperty;
import oracle.bpm.ui.prop.impl.ComboValueProvider;
import oracle.bpm.ui.prop.impl.FontProperty;
import oracle.bpm.ui.prop.impl.RegexpTextProperty;
import oracle.bpm.ui.prop.impl.ResetPropertyEditor;
import oracle.bpm.ui.prop.impl.TextProperty;
import oracle.bpm.ui.utils.ColorUtils;
import oracle.bpm.webformdesigner.msg.WebformdesignerMsg;
import oracle.bpm.xobject.Utilities;
import oracle.bpm.xobject.presentationmodel.FullBorderProperties;
import oracle.bpm.xobject.presentationmodel.SimpleBorderProperties;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.xml.XFormXMLObject;

public abstract class SimpleComponentProperties
implements ComponentProperties {
    protected Set<Msg> hidenPropertyGroups;
    protected boolean inArray = false;
    protected ChangeListener listener_d;
    protected XFormPresentationXMLObject object_d;
    protected List<Property> properties_d;
    protected XFormPresentationXMLObject sub_object_d;
    private ComponentInteractionProvider componentInteractionProvider;
    private MsgList groupedProperties;
    private HashMap<Msg, PropertyTablePanel> groupHash;
    private HashMap<Msg, List<Property>> propertyGroupHash;
    private PropertyTable tableWrapper;
    private static PreParser nullPreParser;
    private static PreParser colorPreparser;
    private static PreParser alignmentPreparser;
    private static PreParser arrayPreparser;
    private static PreParser intarrayPreparser;
    private static PreParser widthArrayPreparser;

    public SimpleComponentProperties(XFormPresentationXMLObject o, ComponentInteractionProvider componentInteractionProvider, ChangeListener listener) {
        this.object_d = o;
        this.componentInteractionProvider = componentInteractionProvider;
        this.listener_d = listener;
        this.hidenPropertyGroups = new TreeSet<Msg>(new Comparator<Msg>(){

            @Override
            public int compare(Msg msg1, Msg msg2) {
                return msg1.getCode().compareTo(msg2.getCode());
            }
        });
        this.groupHash = new HashMap();
    }

    @Override
    public XFormPresentationXMLObject getReferencedObject() {
        return this.object_d;
    }

    public boolean isCssEnabled() {
        return this.componentInteractionProvider != null && this.componentInteractionProvider.isCssEnabled();
    }

    public boolean isRepeatableComponent() {
        return this.componentInteractionProvider != null && this.componentInteractionProvider.isRepeatableComponet(this.object_d);
    }

    @Override
    public void showProperties(PropertyTable table) {
        this.tableWrapper = table;
        this.properties_d = null;
        this.propertyGroupHash = null;
        this.groupedProperties = null;
        this.initComponentProperties();
        this.addProperties();
    }

    protected abstract void initProperties();

    protected static void addProperties(PropertyTable currentTableWrapper, HashMap<Msg, List<Property>> currentPropertyGroupHash, List<Property> standAloneProperties, List<Msg> groupNames, boolean isReadonly) {
        SimpleComponentProperties.addProperties(currentTableWrapper, currentPropertyGroupHash, standAloneProperties, groupNames, new HashMap<Msg, PropertyTablePanel>(), isReadonly);
    }

    protected static PreParser getArrayPreparser() {
        if (arrayPreparser == null) {
            arrayPreparser = new PreParser(){

                @Override
                public Object preParse(Object array) {
                    return array == Property.NULL_VALUE ? null : ((String)array).split(",");
                }
            };
        }
        return arrayPreparser;
    }

    protected static PreParser getIntArrayPreparser() {
        if (intarrayPreparser == null) {
            intarrayPreparser = new PreParser(){

                @Override
                public Object preParse(Object array) {
                    if (array == Property.NULL_VALUE) {
                        return null;
                    }
                    String[] texts = ((String)array).split(",");
                    int[] numbers = new int[texts.length];
                    for (int col = 0; col < texts.length; ++col) {
                        try {
                            numbers[col] = Integer.parseInt(texts[col]);
                            continue;
                        }
                        catch (NumberFormatException nfe) {
                            numbers[col] = -1;
                        }
                    }
                    return numbers;
                }
            };
        }
        return intarrayPreparser;
    }

    protected static PreParser getWidthArrayPreparser() {
        if (widthArrayPreparser == null) {
            widthArrayPreparser = new PreParser(){

                @Override
                public Object preParse(Object array) {
                    if (array == Property.NULL_VALUE) {
                        return null;
                    }
                    String[] texts = ((String)array).split(",");
                    String[] widths = new String[texts.length];
                    boolean isWidthPorcentual = texts.length > 0 && Pattern.matches("^[0-9]+[\\%]{1}$", texts[0]);
                    for (int col = 0; col < texts.length; ++col) {
                        String width;
                        try {
                            boolean isValid;
                            width = texts[col];
                            boolean bl = isValid = isWidthPorcentual ? Pattern.matches("^[0-9]+[\\%]{1}$", width) : Pattern.matches("^[0-9]*$", width);
                            if (!isValid) {
                                width = "";
                            }
                        }
                        catch (Throwable t) {
                            width = "";
                        }
                        widths[col] = width;
                    }
                    return widths;
                }
            };
        }
        return widthArrayPreparser;
    }

    protected void addAlignmentProperty(String currentAlignment) {
        this.properties_d.add(this.createAlignmentProperty("alignment", currentAlignment));
    }

    protected void addBackgroundColorProperty(String currentBackgroundColor) {
        this.addColorProperty(DesignerMsg.BACK_COLOR, "bgcolor", currentBackgroundColor);
    }

    protected void addColorProperty(Msg propertyMessage, String propertyName, String propertyValue) {
        Property color = this.createColorProperty(propertyMessage, propertyName, propertyValue);
        this.properties_d.add(color);
    }

    protected void addColorProperty(Msg where, Msg propertyMessage, String propertyName, String propertyValue) {
        Property color = this.createColorProperty(propertyMessage, propertyName, propertyValue);
        this.addPropertyTo(where, color);
    }

    protected void addFontProperty(String currentFontName, FontStyle currentFontStyle, int currentFontSize) {
        this.addFontProperty("fonttype", currentFontName, "fontface", currentFontStyle, "fontsize", currentFontSize);
    }

    protected void addFontProperty(Msg category, String currentFontName, FontStyle currentFontStyle, int currentFontSize) {
        Property property = this.createFontProperty(DesignerMsg.PROPERTY_FONTFACE, "fonttype", currentFontName, "fontface", currentFontStyle, "fontsize", currentFontSize);
        this.addPropertyTo(category, property);
    }

    protected void addFontProperty(Msg fontGroupName, String fontNamePropertyName, String currentFontName, String fontStylePropertyName, FontStyle currentFontStyle, String fontSizePropertyName, int currentFontSize) {
        this.properties_d.add(this.createFontProperty(fontGroupName, fontNamePropertyName, currentFontName, fontStylePropertyName, currentFontStyle, fontSizePropertyName, currentFontSize));
    }

    protected void addForegroundColorProperty(String currentForegroundColor) {
        this.addColorProperty(DesignerMsg.PROPERTY_FGCOLOR, "fgcolor", currentForegroundColor);
    }

    protected void addFullBorderProperty(FullBorderProperties fullBorderProperties) {
        PropertyGroup topGroup = this.createBorderProperty(UIMsg.BORDER_TOP, BorderHelper.createTopStyleSetter(fullBorderProperties), BorderHelper.createTopWidthSetter(fullBorderProperties), BorderHelper.createTopColorSetter(fullBorderProperties));
        this.addProperty(UIMsg.BORDER_ALL, (Property)topGroup, null);
        PropertyGroup bottomGroup = this.createBorderProperty(UIMsg.BORDER_BOTTOM, BorderHelper.createBottomStyleSetter(fullBorderProperties), BorderHelper.createBottomWidthSetter(fullBorderProperties), BorderHelper.createBottomColorSetter(fullBorderProperties));
        this.addProperty(UIMsg.BORDER_ALL, (Property)bottomGroup, null);
        PropertyGroup leftGroup = this.createBorderProperty(UIMsg.BORDER_LEFT, BorderHelper.createLeftStyleSetter(fullBorderProperties), BorderHelper.createLeftWidthSetter(fullBorderProperties), BorderHelper.createLeftColorSetter(fullBorderProperties));
        this.addProperty(UIMsg.BORDER_ALL, (Property)leftGroup, null);
        PropertyGroup rightGroup = this.createBorderProperty(UIMsg.BORDER_RIGHT, BorderHelper.createRightStyleSetter(fullBorderProperties), BorderHelper.createRightWidthSetter(fullBorderProperties), BorderHelper.createRightColorSetter(fullBorderProperties));
        this.addProperty(UIMsg.BORDER_ALL, (Property)rightGroup, null);
    }

    protected void addIdProperty(String currentID) {
        this.createIdProperty(currentID);
    }

    protected void addIdPropertyRO(String currentID) {
        Property property = this.createIdProperty(currentID);
        property.setEditable(false);
    }

    protected void addImageProperty(Msg propertyMessage, String propertyName, String propertyValue) {
        this.addImageProperty(propertyMessage, propertyName, propertyValue, false);
    }

    protected void addImageProperty(Msg where, Msg propertyMessage, String propertyName, String propertyValue) {
        this.addImageProperty(where, propertyMessage, propertyName, propertyValue, false);
    }

    protected void addImageProperty(Msg propertyMessage, String propertyName, String propertyValue, boolean subObject) {
        Property image = this.createImageProperty(propertyMessage, propertyName, propertyValue, subObject);
        this.properties_d.add(image);
    }

    protected void addImageProperty(Msg where, Msg propertyMessage, String propertyName, String propertyValue, boolean subObject) {
        Property image = this.createImageProperty(propertyMessage, propertyName, propertyValue, subObject);
        this.addPropertyTo(where, image);
    }

    protected void addLinkProperty(Msg linkGroupName, String currentLink, boolean currentFullBrowser) {
        TextProperty link = Factory.createText((Msg)DesignerMsg.PROPERTY_HREF, (String)currentLink, (boolean)false);
        link.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object newValue = evt.getNewValue();
                SimpleComponentProperties.this.changeProperty("link", newValue);
            }
        });
        BooleanProperty fullBrowser = Factory.createBoolean((Msg)DesignerMsg.PROPERTY_FULL_BROWSER, (boolean)currentFullBrowser);
        fullBrowser.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object newValue = evt.getNewValue();
                SimpleComponentProperties.this.changeProperty("fullbrowser", newValue);
            }
        });
        this.addProperty(linkGroupName, (Property)link, null);
        this.addProperty(linkGroupName, (Property)fullBrowser, null);
    }

    protected void addOutputMaskProperty(String outputMask, OutputMaskType outputMaskType) {
        TextProperty outputMaskProperty = Factory.createText((Msg)DesignerMsg.PROPERTY_MASK, (String)outputMask, (boolean)false);
        this.addProperty(DesignerMsg.PROPERTY_MASK_OUTPUT, (Property)outputMaskProperty, "outputmask");
        ComboProperty outputMaskTypeProperty = Factory.createCombo((Msg)DesignerMsg.PROPERTY_MASK_OUTPUT_TYPE, (Object[])OutputMaskType.values(), (int)outputMaskType.getValue());
        this.addProperty(DesignerMsg.PROPERTY_MASK_OUTPUT, (Property)outputMaskTypeProperty, "outputmasktype");
    }

    protected void addProperty(Property property, String propertyName) {
        this.addProperty(property, propertyName, null);
    }

    protected void addProperty(Property property, String propertyName, PreParser preParser) {
        this.properties_d.add(property);
        this.initProperty(property, propertyName, preParser);
    }

    protected void addProperty(Msg where, Property property, String propertyName) {
        this.addProperty(where, property, propertyName, null);
    }

    protected void addProperty(Msg where, Property property, String propertyName, PreParser preParser) {
        this.addPropertyTo(where, property);
        this.initProperty(property, propertyName, preParser);
    }

    protected void addPropertyTo(Msg where, Property property) {
        List<Property> properties;
        if (this.propertyGroupHash == null) {
            this.propertyGroupHash = new HashMap();
            this.groupedProperties = MsgList.create();
        }
        if ((properties = this.propertyGroupHash.get(where)) == null) {
            properties = new ArrayList<Property>();
            this.propertyGroupHash.put(where, properties);
            this.groupedProperties.add(where);
        }
        properties.add(property);
    }

    protected void addReset(Property property) {
        PropertyEditor propertyEditor = this.createResetableEditor(property);
        ((AbstractProperty)property).setPropertyEditor(propertyEditor);
    }

    protected void addSimpleBorderProperty(BorderStyle borderStyle, int currentBorderWidth, String currentBorderColor) {
        SimpleBorderProperties simpleBorderProperties = (SimpleBorderProperties)((Object)this.object_d);
        PropertyGroup group = this.createBorderProperty(UIMsg.BORDER_ALL, BorderHelper.createStyleChanger(simpleBorderProperties), BorderHelper.createWidthChanger(simpleBorderProperties), BorderHelper.createColorChanger(simpleBorderProperties), borderStyle, currentBorderWidth, currentBorderColor);
        this.addProperty((Property)group, null);
    }

    protected void changeProperty(String propertyName, Object newValue) {
        this.changeProperty(propertyName, newValue, false);
    }

    protected void changeProperty(String propertyName, Object newValue, boolean subObject) {
        if (subObject) {
            this.changeProperty(propertyName, newValue, this.sub_object_d);
        } else {
            this.changeProperty(propertyName, newValue, this.object_d);
        }
    }

    protected void silentChangeProperty(String propertyName, Object newValue) {
        this.invokeCommand(new ModifyPropertyValueCommand(this.object_d, newValue, propertyName, null));
    }

    protected void changeProperty(String propertyName, Object newValue, XFormXMLObject where) {
        this.invokeCommand(new ModifyPropertyValueCommand(where, newValue, propertyName, this.listener_d));
    }

    protected Property createAlignmentProperty(String alignmentName, String currentAlignment) {
        Vector<Msg> validAlignments = new Vector<Msg>();
        Msg currentAlignmentMsg = DesignerMsg.LEFT_JUSTIFY;
        if (currentAlignment != null) {
            if (currentAlignment.equals("center")) {
                currentAlignmentMsg = DesignerMsg.CENTER_JUSTIFY;
            } else if (currentAlignment.equals("right")) {
                currentAlignmentMsg = DesignerMsg.RIGHT_JUSTIFY;
            }
        }
        validAlignments.add(DesignerMsg.LEFT_JUSTIFY);
        validAlignments.add(DesignerMsg.CENTER_JUSTIFY);
        validAlignments.add(DesignerMsg.RIGHT_JUSTIFY);
        ComboProperty alignment = Factory.createCombo((Msg)DesignerMsg.PROPERTY_ALIGNMENT, validAlignments, (Object)currentAlignmentMsg);
        this.initProperty((Property)alignment, alignmentName, SimpleComponentProperties.getAlignmentPreparser());
        return alignment;
    }

    protected PropertyGroup createBorderProperty(Msg msg, BorderHelper.PropertyChanger styleSetter, BorderHelper.PropertyChanger widthSetter, BorderHelper.PropertyChanger colorSetter) {
        return this.createBorderProperty(msg, styleSetter, widthSetter, colorSetter, (BorderStyle)styleSetter.getValue(), (Integer)widthSetter.getValue(), (String)colorSetter.getValue());
    }

    protected PropertyGroup createBorderProperty(Msg msg, BorderHelper.PropertyChanger styleSetter, BorderHelper.PropertyChanger widthSetter, BorderHelper.PropertyChanger colorSetter, BorderStyle borderStyle, int borderWidth, String borderColor) {
        BorderProperty borderGroup = new BorderProperty(msg, borderStyle, borderWidth, borderColor);
        this.initProperty((Property)borderGroup.getBorderStyleProp(), styleSetter, SimpleComponentProperties.getNullPreparser());
        this.initProperty((Property)borderGroup.getBorderWidthProp(), widthSetter, null);
        AbstractProperty borderColorProp = borderGroup.getBorderColorProp();
        borderColorProp.setPropertyEditor((PropertyEditor)new ColorPropertyEditor());
        this.addReset((Property)borderColorProp);
        this.initProperty((Property)borderColorProp, colorSetter, SimpleComponentProperties.getColorPreparser());
        return borderGroup;
    }

    protected Property createColorProperty(Msg propertyMessage, String propertyName, String propertyValue) {
        Color c = ColorUtils.getColor((String)propertyValue);
        ColorProperty color = Factory.createColor((Msg)propertyMessage, (Color)c);
        this.addReset((Property)color);
        this.initProperty((Property)color, propertyName, SimpleComponentProperties.getColorPreparser());
        return color;
    }

    protected Property createFontProperty(Msg fontGroupName, final String fontNamePropertyName, final String currentFontName, final String fontStylePropertyName, final FontStyle currentFontStyle, final String fontSizePropertyName, final int currentFontSize) {
        Font font = this.getFont(currentFontName, currentFontStyle, currentFontSize);
        FontProperty fonttype = Factory.createFont((Msg)fontGroupName, (Font)font);
        fonttype.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!(evt.getNewValue() instanceof Font)) {
                    return;
                }
                Font newValue = (Font)evt.getNewValue();
                if (newValue != null) {
                    boolean nameChanged;
                    Font oldValue = (Font)evt.getOldValue();
                    int oldSize = oldValue == null ? currentFontSize : oldValue.getSize();
                    FontStyle oldStyle = oldValue == null ? currentFontStyle : oldValue.getStyle();
                    String oldName = oldValue == null ? currentFontName : oldValue.getName();
                    int newSize = newValue.getSize();
                    boolean sizeChanged = newSize != oldSize;
                    FontStyle newStyle = newValue.getStyle();
                    boolean styleChanged = !newStyle.equals(oldStyle);
                    String newName = newValue.getName();
                    boolean bl = nameChanged = !"dialog".equals(newName) && !newName.equals(oldName);
                    if (sizeChanged) {
                        if (styleChanged || nameChanged) {
                            SimpleComponentProperties.this.silentChangeProperty(fontSizePropertyName, newSize);
                        } else {
                            SimpleComponentProperties.this.changeProperty(fontSizePropertyName, newSize);
                        }
                    }
                    if (styleChanged) {
                        if (nameChanged) {
                            SimpleComponentProperties.this.silentChangeProperty(fontStylePropertyName, newStyle);
                        } else {
                            SimpleComponentProperties.this.changeProperty(fontStylePropertyName, newStyle);
                        }
                    }
                    if (nameChanged) {
                        SimpleComponentProperties.this.changeProperty(fontNamePropertyName, newName);
                    }
                }
            }
        });
        return fonttype;
    }

    protected Property createImageProperty(Msg propertyMessage, String propertyName, String propertyValue, boolean subObject) {
        ImageFileProperty image = new ImageFileProperty(propertyMessage, propertyValue);
        this.addReset((Property)image);
        this.initProperty((Property)image, propertyName, null, subObject);
        return image;
    }

    protected PropertyChangeListener createListener(final Property property, final BorderHelper.PropertyChanger propertyChanger, final PreParser preParser) {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object newValue = SimpleComponentProperties.this.preparseValue(evt.getNewValue(), property, preParser);
                BorderHelper.PropertyChangerCommand command = new BorderHelper.PropertyChangerCommand(propertyChanger, SimpleComponentProperties.this.listener_d);
                command.setNewValue(newValue);
                SimpleComponentProperties.this.invokeCommand(command);
            }
        };
    }

    protected PropertyChangeListener createListener(final Property property, final String propertyName, final PreParser preParser, final boolean subObject) {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object newValue = SimpleComponentProperties.this.preparseValue(evt.getNewValue(), property, preParser);
                SimpleComponentProperties.this.changeProperty(propertyName, newValue, subObject);
            }
        };
    }

    protected void doHideGroup(Msg msg) {
    }

    protected void doShowGroup(Msg msg) {
    }

    protected Font getFont(String currentFontName, FontStyle currentFontStyle, int currentFontSize) {
        Font font = null;
        FontDecoder decoder = new FontDecoder();
        if (currentFontName.contains(",")) {
            StringTokenizer tokenizer = new StringTokenizer(currentFontName, ",");
            while (tokenizer.hasMoreElements() && font == null) {
                String f = tokenizer.nextElement().toString();
                font = decoder.decodeFont(this.getReferencedObject().getId(), f);
            }
        } else {
            font = decoder.decodeFont(this.getReferencedObject().getId(), currentFontName);
        }
        if (currentFontStyle != null && font != null) {
            font = font.applyStyle(currentFontStyle);
        }
        if (currentFontSize > 0 && font != null) {
            font = font.resize(currentFontSize);
        }
        return font;
    }

    protected HashMap<Msg, List<Property>> getPropertiesHash() {
        if (this.propertyGroupHash == null) {
            this.propertyGroupHash = new HashMap();
            this.groupedProperties = MsgList.create();
            this.initComponentProperties();
        }
        return this.propertyGroupHash;
    }

    protected PropertyTable getTable() {
        return this.tableWrapper;
    }

    protected List<Property> getUngroupedProperties() {
        if (this.properties_d == null) {
            this.initComponentProperties();
        }
        return this.properties_d;
    }

    protected MsgList getVisibleGroupNames() {
        if (this.groupedProperties == null) {
            this.propertyGroupHash = new HashMap();
            this.groupedProperties = MsgList.create();
            this.initComponentProperties();
        }
        MsgList visibleGroups = MsgList.create();
        visibleGroups.addAll(this.groupedProperties);
        if (this.hidenPropertyGroups != null) {
            for (Msg hidenPropertyGroup : this.hidenPropertyGroups) {
                visibleGroups.remove(hidenPropertyGroup);
            }
        }
        return visibleGroups;
    }

    protected void hideGroup(Msg msg) {
        this.hidenPropertyGroups.add(msg);
        this.doHideGroup(msg);
    }

    protected void initProperty(Property property, String propertyName, PreParser preParser) {
        this.initProperty(property, propertyName, preParser, false);
    }

    protected void initProperty(Property property, BorderHelper.PropertyChanger propertyChanger, PreParser preParser) {
        property.addPropertyChangeListener(this.createListener(property, propertyChanger, preParser));
    }

    protected void initProperty(Property property, String propertyName, PreParser preParser, boolean subObject) {
        if (propertyName != null) {
            property.addPropertyChangeListener(this.createListener(property, propertyName, preParser, subObject));
        }
    }

    protected void invokeCommand(Command command) {
        CommandManager.invokeCommand(command);
    }

    protected void showGroup(Msg msg) {
        this.hidenPropertyGroups.remove(msg);
        this.doShowGroup(msg);
    }

    private static void addProperties(PropertyTable currentTableWrapper, HashMap<Msg, List<Property>> currentPropertyGroupHash, List<Property> standAloneProperties, List<Msg> groupNames, HashMap<Msg, PropertyTablePanel> currentGroupHash, boolean isReadonly) {
        SimpleComponentProperties.showProperties(currentTableWrapper, DesignerMsg.PROPERTIES, standAloneProperties, currentGroupHash, isReadonly);
        if (currentPropertyGroupHash != null) {
            for (Msg keyMessage : groupNames) {
                List<Property> list = currentPropertyGroupHash.get(keyMessage);
                SimpleComponentProperties.showProperties(currentTableWrapper, keyMessage, list, currentGroupHash, isReadonly);
            }
        }
    }

    private static PreParser getAlignmentPreparser() {
        if (alignmentPreparser == null) {
            alignmentPreparser = new PreParser(){

                @Override
                public Object preParse(Object alignMsg) {
                    String value = null;
                    if (alignMsg != null && alignMsg != Property.NULL_VALUE) {
                        value = alignMsg.equals(DesignerMsg.CENTER_JUSTIFY) ? "center" : (alignMsg.equals(DesignerMsg.LEFT_JUSTIFY) ? "left" : "right");
                    }
                    return value;
                }
            };
        }
        return alignmentPreparser;
    }

    private static PreParser getColorPreparser() {
        if (colorPreparser == null) {
            colorPreparser = new PreParser(){

                @Override
                public Object preParse(Object color) {
                    return color == Property.NULL_VALUE ? null : Utilities.getString((ColorInfo)((Color)color).getInfo());
                }
            };
        }
        return colorPreparser;
    }

    private static PreParser getNullPreparser() {
        if (nullPreParser == null) {
            nullPreParser = new PreParser(){

                @Override
                public Object preParse(Object value) {
                    return value == Property.NULL_VALUE ? null : value;
                }
            };
        }
        return nullPreParser;
    }

    private static void showProperties(PropertyTable table, Msg keyMessage, List<Property> list, HashMap<Msg, PropertyTablePanel> currentGroupHash, boolean isReadOnly) {
        if (list != null) {
            PropertyGroup currentGroup;
            PropertyTablePanel tablePanel;
            boolean expand = false;
            if (table.isShowGroupsAsPanels()) {
                tablePanel = table.addPropertyTablePanel(keyMessage);
                currentGroupHash.put(keyMessage, tablePanel);
                currentGroup = tablePanel.getGroup();
            } else {
                if (DesignerMsg.PROPERTIES.equals(keyMessage)) {
                    keyMessage = UIMsg.BASIC;
                    expand = true;
                }
                tablePanel = SimpleComponentProperties.getDefaultPanel(table, currentGroupHash);
                currentGroup = new PropertyGroup(keyMessage);
                tablePanel.getGroup().add((Property)currentGroup);
            }
            for (Property property : list) {
                if (isReadOnly) {
                    property.setEditable(false);
                }
                tablePanel.registerKeyListener((AbstractProperty)property);
                currentGroup.add(property);
            }
            if (expand) {
                tablePanel.expandLevel(2);
            }
        }
    }

    private static PropertyTablePanel getDefaultPanel(PropertyTable table, HashMap<Msg, PropertyTablePanel> currentGroupHash) {
        Msg defaultMsg = DesignerMsg.PROPERTIES;
        PropertyTablePanel tablePanel = currentGroupHash.get(defaultMsg);
        if (tablePanel == null) {
            tablePanel = table.addPropertyTablePanel(defaultMsg);
            tablePanel.setPropertyNameFontProvider((FontProvider)new PropertyNameFontProvider(table));
            currentGroupHash.put(defaultMsg, tablePanel);
        }
        return tablePanel;
    }

    private Object preparseValue(Object newValue, Property property, PreParser preParser) {
        if (property instanceof ComboValueProvider && ((ComboValueProvider)property).isAllowNullValues() && newValue == Property.NULL_VALUE) {
            newValue = null;
        }
        if (property instanceof ImageFileProperty && newValue == Property.NULL_VALUE) {
            newValue = null;
        }
        if (preParser != null) {
            newValue = preParser.preParse(newValue);
        }
        return newValue;
    }

    private Property createIdProperty(String currentID) {
        RegexpTextProperty id = Factory.createRegexpText((Msg)DesignerMsg.PROPERTY_ID, (String)currentID, (boolean)false);
        this.addProperty((Property)id, "id");
        return id;
    }

    private void addFontProperty(String fontNamePropertyName, String currentFontName, String fontStylePropertyName, FontStyle currentFontStyle, String fontSizePropertyName, int currentFontSize) {
        this.addFontProperty(DesignerMsg.PROPERTY_FONTFACE, fontNamePropertyName, currentFontName, fontStylePropertyName, currentFontStyle, fontSizePropertyName, currentFontSize);
    }

    private void addProperties() {
        SimpleComponentProperties.addProperties(this.tableWrapper, this.propertyGroupHash, this.properties_d, this.groupedProperties, this.groupHash, this.componentInteractionProvider.isReadOnly());
        for (Msg hidenPropertyGroup : this.hidenPropertyGroups) {
            this.doHideGroup(hidenPropertyGroup);
        }
    }

    private PropertyEditor createResetableEditor(Property property) {
        return new ResetPropertyEditor(property.getPropertyEditor());
    }

    private void initComponentProperties() {
        this.initProperties();
        if (this.componentInteractionProvider.isCssEnabled() || this instanceof PresentationComponentProperties) {
            TextProperty cssClass = Factory.createText((Msg)WebformdesignerMsg.PROPERTY_CSS_CLASS, (String)this.object_d.getCssClass(), (boolean)false);
            this.addProperty(DesignerMsg.PROPERTY_CSS, (Property)cssClass, "cssclass");
            BooleanProperty cssMixed = Factory.createBoolean((Msg)DesignerMsg.PROPERTY_CSS_MIXED, (boolean)this.object_d.isMixedCss());
            this.addProperty(DesignerMsg.PROPERTY_CSS, (Property)cssMixed, "ismixedcss");
        }
    }

    private static class PropertyNameFontProvider
    extends TreeTableFontProvider.Default {
        private PropertyTable table;

        public PropertyNameFontProvider(PropertyTable table) {
            this.table = table;
        }

        public Font getFont(Object element) {
            Font result = null;
            if (this.getObject() instanceof PropertyGroup) {
                boolean isTopLevel;
                PropertyGroup group = (PropertyGroup)this.getObject();
                boolean bl = isTopLevel = group.getParent() != null && group.getParent().getParent() == null;
                if (isTopLevel) {
                    result = this.table.getFont().applyStyle(FontStyle.BOLD);
                }
            }
            return result;
        }
    }

    protected static abstract class PreParser {
        protected PreParser() {
        }

        public abstract Object preParse(Object var1);
    }
}

