/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.properties;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.bpm.designer.formdesigner.ChangeListener;
import oracle.bpm.designer.formdesigner.model.TranslatableProperty;
import oracle.bpm.designer.formdesigner.properties.BorderHelper;
import oracle.bpm.designer.formdesigner.properties.ComponentInteractionProvider;
import oracle.bpm.designer.formdesigner.properties.ExternalDialogPropertyEditor;
import oracle.bpm.designer.formdesigner.properties.ReferenceableComponentProperties;
import oracle.bpm.designer.formdesigner.properties.SimpleComponentProperties;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.geom.Dimension;
import oracle.bpm.lang.Holder;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.Argument;
import oracle.bpm.ui.BorderStyle;
import oracle.bpm.ui.FontStyle;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.prop.AbstractProperty;
import oracle.bpm.ui.prop.Factory;
import oracle.bpm.ui.prop.Property;
import oracle.bpm.ui.prop.PropertyEditor;
import oracle.bpm.ui.prop.PropertyGroup;
import oracle.bpm.ui.prop.PropertyRenderer;
import oracle.bpm.ui.prop.impl.BooleanProperty;
import oracle.bpm.ui.prop.impl.ComboValueProvider;
import oracle.bpm.ui.prop.impl.DefaultPropertyRenderer;
import oracle.bpm.ui.prop.impl.LazyComboProperty;
import oracle.bpm.ui.prop.impl.NumericProperty;
import oracle.bpm.ui.prop.impl.TextProperty;
import oracle.bpm.ui.text.NumericField;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.presentationmodel.XFormRepeatable;

public class RepeatableComponentProperties
extends ReferenceableComponentProperties {
    private static SimpleComponentProperties.PreParser HOLDER_PREPARSER = null;

    public RepeatableComponentProperties(XFormPresentationXMLObject referencedObject, ComponentInteractionProvider componentInteractionProvider, ChangeListener listener) {
        super(referencedObject, componentInteractionProvider, listener);
    }

    public static SimpleComponentProperties.PreParser getHolderPreParser() {
        if (HOLDER_PREPARSER == null) {
            HOLDER_PREPARSER = new SimpleComponentProperties.PreParser(){

                @Override
                public Object preParse(Object object) {
                    if (object instanceof Holder) {
                        return ((Holder)object).get();
                    }
                    return object;
                }
            };
        }
        return HOLDER_PREPARSER;
    }

    protected void addBorderPropertyToFolder(Msg folderMsg, BorderHelper.PropertyChanger styleSetter, BorderHelper.PropertyChanger widthSetter, BorderHelper.PropertyChanger colorSetter) {
        PropertyGroup borderProperties = this.createBorderProperty(UIMsg.BORDER_ALL, styleSetter, widthSetter, colorSetter);
        this.addProperty(folderMsg, (Property)borderProperties, null);
    }

    protected void addColorPropertyToFolder(Msg folderMsg, String currentBgColor, String bgColorName, String currentFgColor, String fgColorName) {
        Property bgColorProperty = this.createColorProperty(DesignerMsg.BACK_COLOR, bgColorName, currentBgColor);
        Property fgColorProperty = this.createColorProperty(DesignerMsg.PROPERTY_FGCOLOR, fgColorName, currentFgColor);
        this.addProperty(folderMsg, bgColorProperty, bgColorName);
        this.addProperty(folderMsg, fgColorProperty, fgColorName);
    }

    protected void addFontPropertyToFolder(Msg folderMsg, String currentFontType, String fontTypeName, FontStyle currentFontStyle, String fontFaceName, int currentFontSize, String fontSizeName) {
        Property fontProperty = this.createFontProperty(DesignerMsg.PROPERTY_FONTFACE, fontTypeName, currentFontType, fontFaceName, currentFontStyle, fontSizeName, currentFontSize);
        this.addProperty(folderMsg, fontProperty, null);
    }

    @Override
    protected void initProperties() {
        this.properties_d = new ArrayList();
        XFormRepeatable repeatable = (XFormRepeatable)this.getReferencedObject();
        this.addIdProperty(repeatable.getId());
        this.addReferenceProperty(repeatable.getReference());
        this.addEditableProperty(repeatable.editable);
        this.addTabIndexProperty(repeatable.getTabindex());
        this.addBackgroundColorProperty(repeatable.bgcolor);
        this.addLayoutProperty(repeatable);
        this.addRowProperty(repeatable);
        this.addIndexProperty(repeatable);
        this.addPagingProperty(repeatable);
        this.addHeaderProperty(repeatable);
        this.addEventHandling(repeatable);
        if (this.isCssEnabled()) {
            TextProperty headerCssClass = Factory.createText((Msg)DesignerMsg.PROPERTY_CSS_GROUP_HEADER_CLASS, (String)repeatable.getHeadercssclass(), (boolean)false);
            this.addProperty(DesignerMsg.PROPERTY_CSS, (Property)headerCssClass, "headercssclass");
            TextProperty indexCssClass = Factory.createText((Msg)DesignerMsg.PROPERTY_CSS_GROUP_INDEX_CLASS, (String)repeatable.getIndexcssclass(), (boolean)false);
            this.addProperty(DesignerMsg.PROPERTY_CSS, (Property)indexCssClass, "indexcssclass");
            TextProperty pagingCssClass = Factory.createText((Msg)DesignerMsg.PROPERTY_CSS_GROUP_PAGING_CLASS, (String)repeatable.getPagingcssclass(), (boolean)false);
            this.addProperty(DesignerMsg.PROPERTY_CSS, (Property)pagingCssClass, "pagingcssclass");
            TextProperty rowEvenCssClass = Factory.createText((Msg)DesignerMsg.PROPERTY_CSS_GROUP_EVEN_ROW, (String)repeatable.getRowevencssclass(), (boolean)false);
            this.addProperty(DesignerMsg.PROPERTY_CSS, (Property)rowEvenCssClass, "rowevencssclass");
            TextProperty rowOddCssClass = Factory.createText((Msg)DesignerMsg.PROPERTY_CSS_GROUP_ODD_ROW, (String)repeatable.getRowoddcssclass(), (boolean)false);
            this.addProperty(DesignerMsg.PROPERTY_CSS, (Property)rowOddCssClass, "rowoddcssclass");
        }
    }

    private Vector getMethods() {
        ObjectTypeDescription otd = this.getComponentInteractionProvider().getObjectTypeDescription();
        List<MethodTypeDescription> methods = otd.getMethods();
        Vector<String> values = new Vector<String>();
        for (MethodTypeDescription method : methods) {
            Argument argument;
            if (method.getArgumentCount() != 1 || method.getArgumentCount() != 1 || !(argument = method.getArgument(0)).getJavaType().equals("oracle.bpm.xobject.lib.GroupEvent")) continue;
            values.add(method.getSignature());
        }
        return values;
    }

    private void addEventHandling(XFormRepeatable repeatable) {
        ComboValueProvider valueProvider = new ComboValueProvider(){

            public Vector getValues() {
                return RepeatableComponentProperties.this.getMethods();
            }

            public boolean isAllowNullValues() {
                return true;
            }
        };
        LazyComboProperty comboProperty = this.createLazyMethodCombo(DesignerMsg.PROPERTY_METHODINVOCATION, repeatable.getEventhandlermethod(), valueProvider);
        this.addProperty(DesignerMsg.PROPERTY_EVENT_HANDLING, (Property)comboProperty, "eventhandlermethod");
    }

    private void addLayoutProperty(XFormRepeatable repeatable) {
        NumericProperty cellPaddingProperty = Factory.createIntegerNumber((Msg)DesignerMsg.PROPERTY_CELLPADDING, (int)repeatable.cellpadding, (int)0, (int)50, (int)1);
        this.addProperty(DesignerMsg.LAYOUT, (Property)cellPaddingProperty, "cellpadding");
        NumericProperty cellSpacingProperty = Factory.createIntegerNumber((Msg)DesignerMsg.PROPERTY_CELLSPACING, (int)repeatable.cellspacing, (int)0, (int)72, (int)1);
        this.addProperty(DesignerMsg.LAYOUT, (Property)cellSpacingProperty, "cellspacing");
    }

    private void addRowProperty(XFormRepeatable repeatable) {
        NumericProperty rows = Factory.createIntegerNumber((Msg)DesignerMsg.PROPERTY_ROWS, (int)repeatable.rows, (int)-1, (int)50, (int)1);
        this.addProperty(DesignerMsg.GROUP_ROW, (Property)rows, "rows");
        this.addColorProperty(DesignerMsg.GROUP_ROW, DesignerMsg.PROPERTY_ROW_EVEN_BGCOLOR, "rowevencolor", repeatable.rowevencolor);
        this.addColorProperty(DesignerMsg.GROUP_ROW, DesignerMsg.PROPERTY_ROW_ODD_BGCOLOR, "rowoddcolor", repeatable.rowoddcolor);
    }

    private void addHeaderProperty(final XFormRepeatable array) {
        this.addProperty(DesignerMsg.GROUP_HEADER, (Property)Factory.createBoolean((Msg)DesignerMsg.PROPERTY_ENABLED, (boolean)array.headerenabled), "headerenabled");
        HeadersProperty property = new HeadersProperty(DesignerMsg.PROPERTY_HEADERS, array, this.getComponentInteractionProvider());
        this.addProperty(DesignerMsg.GROUP_HEADER, (Property)property, "headers", RepeatableComponentProperties.getHolderPreParser());
        this.addHeaderWidthProperty(array);
        this.addPropertyTo(DesignerMsg.GROUP_HEADER, this.createAlignmentProperty("alignment", array.alignment));
        this.addColorPropertyToFolder(DesignerMsg.GROUP_HEADER, array.headerbgcolor, "headerbgcolor", array.headerfgcolor, "headerfgcolor");
        this.addFontPropertyToFolder(DesignerMsg.GROUP_HEADER, array.headerfonttype, "headerfonttype", array.getHeaderFontStyle(), "headerfontface", array.headerfontsize, "headerfontsize");
        BorderHelper.PropertyChanger styleSetter = new BorderHelper.PropertyChanger("style", array){

            @Override
            protected Object getValue() {
                return array.getHeaderborderstyle();
            }

            @Override
            protected void setValue(Object value) {
                array.setHeaderborderstyle((BorderStyle)value);
            }
        };
        BorderHelper.PropertyChanger widthSetter = new BorderHelper.PropertyChanger("width", array){

            @Override
            protected Object getValue() {
                return array.getHeaderborderwidth();
            }

            @Override
            protected void setValue(Object value) {
                array.setHeaderborderwidth((Integer)value);
            }
        };
        BorderHelper.PropertyChanger colorSetter = new BorderHelper.PropertyChanger("color", array){

            @Override
            protected Object getValue() {
                return array.getHeaderbordercolor();
            }

            @Override
            protected void setValue(Object value) {
                array.setHeaderbordercolor((String)value);
            }
        };
        this.addBorderPropertyToFolder(DesignerMsg.GROUP_HEADER, styleSetter, widthSetter, colorSetter);
    }

    private void addHeaderWidthProperty(XFormRepeatable array) {
        HeaderWitdhProperty headers = new HeaderWitdhProperty(DesignerMsg.PROPERTY_HEADERSWIDTH, array);
        this.addProperty(DesignerMsg.GROUP_HEADER, (Property)headers, "headerswidth", RepeatableComponentProperties.getHolderPreParser());
    }

    private void addIndexProperty(final XFormRepeatable array) {
        this.addProperty(DesignerMsg.GROUP_INDEX, (Property)Factory.createBoolean((Msg)DesignerMsg.PROPERTY_ENABLED, (boolean)array.indexenabled), "indexenabled");
        this.addColorPropertyToFolder(DesignerMsg.GROUP_INDEX, array.indexbgcolor, "indexbgcolor", array.indexfgcolor, "indexfgcolor");
        this.addFontPropertyToFolder(DesignerMsg.GROUP_INDEX, array.indexfonttype, "indexfonttype", array.getIndexfontStyle(), "indexfontface", array.indexfontsize, "indexfontsize");
        BorderHelper.PropertyChanger styleSetter = new BorderHelper.PropertyChanger("style", array){

            @Override
            protected Object getValue() {
                return array.getIndexborderstyle();
            }

            @Override
            protected void setValue(Object value) {
                array.setIndexborderstyle((BorderStyle)value);
            }
        };
        BorderHelper.PropertyChanger widthSetter = new BorderHelper.PropertyChanger("width", array){

            @Override
            protected Object getValue() {
                return array.getIndexborderwidth();
            }

            @Override
            protected void setValue(Object value) {
                array.setIndexborderwidth((Integer)value);
            }
        };
        BorderHelper.PropertyChanger colorSetter = new BorderHelper.PropertyChanger("color", array){

            @Override
            protected Object getValue() {
                return array.getIndexbordercolor();
            }

            @Override
            protected void setValue(Object value) {
                array.setIndexbordercolor((String)value);
            }
        };
        this.addBorderPropertyToFolder(DesignerMsg.GROUP_INDEX, styleSetter, widthSetter, colorSetter);
        BooleanProperty tabCalendarProperty = Factory.createBoolean((Msg)DesignerMsg.PROPERTY_GROUP_INDEX_TAB_NAVIGATION, (boolean)array.isIndextabenabled());
        this.addProperty(DesignerMsg.GROUP_INDEX, (Property)tabCalendarProperty, "indextabenabled");
    }

    private void addPagingProperty(final XFormRepeatable array) {
        this.addColorPropertyToFolder(DesignerMsg.GROUP_PAGING, array.pagingbgcolor, "pagingbgcolor", array.pagingfgcolor, "pagingfgcolor");
        this.addFontPropertyToFolder(DesignerMsg.GROUP_PAGING, array.pagingfonttype, "pagingfonttype", array.getPagingFontStyle(), "pagingfontface", array.pagingfontsize, "pagingfontsize");
        BorderHelper.PropertyChanger styleSetter = new BorderHelper.PropertyChanger("style", array){

            @Override
            protected Object getValue() {
                return array.getPagingborderstyle();
            }

            @Override
            protected void setValue(Object value) {
                array.setPagingborderstyle((BorderStyle)value);
            }
        };
        BorderHelper.PropertyChanger widthSetter = new BorderHelper.PropertyChanger("width", array){

            @Override
            protected Object getValue() {
                return array.getPagingborderwidth();
            }

            @Override
            protected void setValue(Object value) {
                array.setPagingborderwidth((Integer)value);
            }
        };
        BorderHelper.PropertyChanger colorSetter = new BorderHelper.PropertyChanger("color", array){

            @Override
            protected Object getValue() {
                return array.getPagingbordercolor();
            }

            @Override
            protected void setValue(Object value) {
                array.setPagingbordercolor((String)value);
            }
        };
        this.addBorderPropertyToFolder(DesignerMsg.GROUP_PAGING, styleSetter, widthSetter, colorSetter);
    }

    private static class IntArrayHolder
    implements Holder {
        private int[] array;
        private int length;

        public IntArrayHolder(int[] array, int length) {
            this.array = array;
            this.length = length;
        }

        public Object get() {
            return this.array;
        }

        public void put(Object o) {
            this.array = (int[])o;
        }

        public String toString() {
            StringBuffer arrayWidthBuffer = new StringBuffer();
            for (int col = 0; col < this.length; ++col) {
                String width;
                String string = width = this.array == null || this.array.length <= col ? "-1" : String.valueOf(this.array[col]);
                if (col > 0) {
                    arrayWidthBuffer.append(",");
                }
                arrayWidthBuffer.append(width);
            }
            return arrayWidthBuffer.toString();
        }
    }

    private static class HeaderWitdhProperty
    extends AbstractProperty {
        private XFormRepeatable array;
        private int[] headers;

        public HeaderWitdhProperty(Msg msg, XFormRepeatable repeatable) {
            this.headers = repeatable.headerswidth;
            this.array = repeatable;
            this.setKey(msg);
            this.setValue(new IntArrayHolder(this.headers, this.array.headers != null ? this.array.headers.length : 0));
            DefaultPropertyRenderer renderer = new DefaultPropertyRenderer();
            HeaderWidthPropertyEditor editor = new HeaderWidthPropertyEditor();
            this.setPropertyRenderer((PropertyRenderer)renderer);
            this.setPropertyEditor((PropertyEditor)editor);
        }
    }

    private static class HeaderWidthPropertyEditor
    extends ArrayPropertiesEditor {
        private HeaderWidthPropertyEditor() {
        }

        @Override
        public void startEdit(UiContainer parent) {
            HeaderWitdhProperty property = (HeaderWitdhProperty)this.getProperty();
            IntArrayHolder holder = (IntArrayHolder)property.getValue();
            int[] headersWidth = holder.array;
            String[] headers = ((HeaderWitdhProperty)property).array.headers;
            int length = headers == null ? 0 : headers.length;
            OkCancelDialog dialog = new OkCancelDialog(Ui.getRoot(), DesignerMsg.PROPERTY_HEADERSWIDTH, true){

                public void ok() {
                    this.close();
                }
            };
            Panel container = new Panel(dialog.getContentPane());
            FormLayout layout = this.getLayout(length);
            PanelBuilder builder = layout.createBuilder(container);
            CellConstraints cc = layout.createCellConstraints();
            NumericField[] spinners = new NumericField[length];
            for (int i = 0; i < length; ++i) {
                int current = headersWidth != null && headersWidth.length > i ? headersWidth[i] : -1;
                spinners[i] = NumericField.createIntegerNumericField((UiContainer)container);
                spinners[i].setValue((Number)current);
                spinners[i].setRange((Number)-1, (Number)Integer.MAX_VALUE);
                spinners[i].setStepSize((Number)1);
                Msg msg = DesignerMsg.HEADERS_WIDTH(headers != null && headers[i] != null && !headers[i].trim().equals("") ? headers[i] : "" + i);
                builder.add((UiComponent)Label.create((UiContainer)container, (Msg)msg), cc.xy(2, (i + 1) * 2));
                builder.add((UiComponent)spinners[i], cc.xy(4, (i + 1) * 2));
            }
            boolean result = OkCancelDialog.doShowDialog((OkCancelDialog)dialog, (UiComponent)container);
            if (result) {
                int[] newValue = new int[spinners.length];
                for (int i = 0; i < spinners.length; ++i) {
                    newValue[i] = (Integer)spinners[i].getValue();
                }
                this.editorValueChanged(new IntArrayHolder(newValue, newValue.length));
                this.stopCellEditing();
            } else {
                this.cancelCellEditing();
            }
        }
    }

    private static class HeadersPropertyEditor
    extends ArrayPropertiesEditor {
        private HeadersPropertyEditor() {
        }

        @Override
        public void startEdit(UiContainer parent) {
            String[] headers = (String[])((ArrayHolder)this.getProperty().getValue()).get();
            int length = headers.length;
            OkCancelDialog dialog = new OkCancelDialog(Ui.getRoot(), DesignerMsg.PROPERTY_HEADERS, true){

                public void ok() {
                    this.close();
                }
            };
            Panel container = new Panel(dialog.getContentPane());
            FormLayout layout = this.getLayout(length);
            PanelBuilder builder = layout.createBuilder(container);
            CellConstraints cc = layout.createCellConstraints();
            final TranslatableProperty[] translatableProperties = new TranslatableProperty[length];
            for (int i = 0; i < length; ++i) {
                Msg msg = DesignerMsg.HEADERS("" + i);
                HeadersProperty headersProperty = (HeadersProperty)this.getProperty();
                final TranslatableProperty currentProperty = new TranslatableProperty(msg, headersProperty.getAllValues(), headers[i]);
                currentProperty.addRelatedTranslatable(new TranslatableProperty.ResourcesListener(){

                    @Override
                    public void updateResources() {
                        for (TranslatableProperty eachProperty : translatableProperties) {
                            if (eachProperty == currentProperty) continue;
                            eachProperty.updateResources();
                        }
                    }
                });
                Label label = Label.create((UiContainer)container, (Msg)msg);
                builder.add((UiComponent)label, cc.xy(2, (i + 1) * 2));
                UiComponent eachEditor = currentProperty.getPropertyEditor().createEditor((UiContainer)container, (Object)currentProperty);
                eachEditor.setPreferredSize(Dimension.valueOf(150, 30));
                builder.add(eachEditor, cc.xy(4, (i + 1) * 2));
                translatableProperties[i] = currentProperty;
            }
            boolean result = OkCancelDialog.doShowDialog((OkCancelDialog)dialog, (UiComponent)container);
            if (result) {
                Object[] newValue = new String[translatableProperties.length];
                for (int i = 0; i < translatableProperties.length; ++i) {
                    newValue[i] = translatableProperties[i].getValue().toString();
                }
                this.editorValueChanged(new ArrayHolder(newValue, newValue.length));
                this.stopCellEditing();
            } else {
                this.cancelCellEditing();
            }
        }
    }

    private static class HeadersProperty
    extends AbstractProperty {
        private String[] headers;
        private ComponentInteractionProvider provider;

        public HeadersProperty(Msg msg, XFormRepeatable repeatable, ComponentInteractionProvider provider) {
            this.provider = provider;
            this.headers = repeatable.headers;
            this.setKey(msg);
            this.setValue(new ArrayHolder(this.headers, this.headers.length));
            DefaultPropertyRenderer renderer = new DefaultPropertyRenderer();
            HeadersPropertyEditor editor = new HeadersPropertyEditor();
            this.setPropertyRenderer((PropertyRenderer)renderer);
            this.setPropertyEditor((PropertyEditor)editor);
        }

        public Map getAllValues() {
            return this.provider.getResources();
        }
    }

    protected static class ArrayHolder
    implements Holder<Object[]> {
        private Object[] array;
        private int length;

        public ArrayHolder(Object[] array, int length) {
            this.array = array;
            this.length = length;
        }

        @Override
        public Object[] get() {
            return this.array;
        }

        @Override
        public void put(Object[] o) {
            this.array = o;
        }

        public String toString() {
            StringBuffer arrayWidthBuffer = new StringBuffer();
            for (int col = 0; col < this.length; ++col) {
                String width;
                String string = width = this.array == null || this.array.length <= col ? "-1" : String.valueOf(this.array[col]);
                if (col > 0) {
                    arrayWidthBuffer.append(",");
                }
                arrayWidthBuffer.append(width);
            }
            return arrayWidthBuffer.toString();
        }
    }

    protected static abstract class ArrayPropertiesEditor
    extends ExternalDialogPropertyEditor {
        private Object editorValue;

        protected ArrayPropertiesEditor() {
        }

        @Override
        public String getPropertyValueRepresentation(Property value) {
            return value.getValue().toString();
        }

        public final Object getCellEditorValue() {
            if (this.editorValue == null) {
                this.editorValue = this.getProperty().getValue();
            }
            return this.editorValue;
        }

        public void editorValueChanged(Object editorValue) {
            this.editorValue = editorValue;
        }

        protected FormLayout getLayout(int count) {
            String columns = "5dlu, pref, 5dlu, pref, 5dlu";
            String rows = "5dlu";
            for (int i = 0; i < count; ++i) {
                rows = rows + ",center:pref,5dlu";
            }
            return new FormLayout(columns, rows);
        }
    }
}

