/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.properties;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.Vector;
import oracle.bpm.designer.formdesigner.ChangeListener;
import oracle.bpm.designer.formdesigner.model.TranslatableProperty;
import oracle.bpm.designer.formdesigner.properties.ComponentInteractionProvider;
import oracle.bpm.designer.formdesigner.properties.ReferenceProperty;
import oracle.bpm.designer.formdesigner.properties.SimpleComponentProperties;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.prop.AbstractProperty;
import oracle.bpm.ui.prop.Factory;
import oracle.bpm.ui.prop.Property;
import oracle.bpm.ui.prop.PropertyEditor;
import oracle.bpm.ui.prop.PropertyRenderer;
import oracle.bpm.ui.prop.impl.BooleanProperty;
import oracle.bpm.ui.prop.impl.ComboPropertyEditor;
import oracle.bpm.ui.prop.impl.ComboValueProvider;
import oracle.bpm.ui.prop.impl.LazyComboProperty;
import oracle.bpm.ui.prop.impl.NumericProperty;
import oracle.bpm.ui.prop.impl.NumericPropertyRenderer;
import oracle.bpm.ui.prop.impl.TextProperty;
import oracle.bpm.xobject.lib.XObjectTypeDescriptionHelper;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.presentationmodel.XFormValue;

public abstract class ReferenceableComponentProperties
extends SimpleComponentProperties {
    private ComponentInteractionProvider componentInteractionProvider_d;

    public ReferenceableComponentProperties(XFormPresentationXMLObject object, ComponentInteractionProvider componentInteractionProvider, ChangeListener listener) {
        super(object, componentInteractionProvider, listener);
        this.componentInteractionProvider_d = componentInteractionProvider;
    }

    public ComponentInteractionProvider getComponentInteractionProvider() {
        return this.componentInteractionProvider_d;
    }

    protected AttributeTypeDescription getReference(String name) {
        return name == null ? null : (AttributeTypeDescription)XObjectTypeDescriptionHelper.getMemberFor((String)name, (ObjectTypeDescription)this.componentInteractionProvider_d.getObjectTypeDescription());
    }

    protected void addColumnNoProperty(int columnNo) {
        NumericProperty columnNoProperty = Factory.createIntegerNumber((Msg)DesignerMsg.PROPERTY_COLQTY, (int)columnNo, (int)1, (int)1000, (int)1);
        this.addProperty((Property)columnNoProperty, "colqty");
    }

    protected void addEditableProperty(boolean currentEditable) {
        BooleanProperty editable = Factory.createBoolean((Msg)DesignerMsg.PROPERTY_EDITABLE, (boolean)currentEditable);
        this.addProperty((Property)editable, "editable");
    }

    protected void addHrefProperty(String value) {
        TextProperty property = Factory.createText((Msg)DesignerMsg.PROPERTY_HREF, (String)value, (boolean)false);
        this.properties_d.add(property);
        property.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object newValue = evt.getNewValue();
                ReferenceableComponentProperties.this.changeProperty("link", newValue);
            }
        });
    }

    protected void addLazyMethodCombo(Msg msg, String propertyId, String currentValue) {
        LazyComboProperty comboProperty = this.createLazyMethodCombo(msg, currentValue);
        this.addProperty((Property)comboProperty, propertyId);
    }

    protected void addOnChangeProperty(String currentOnChange) {
        this.addLazyMethodCombo(DesignerMsg.PROPERTY_ONCHANGE, "onchange", currentOnChange);
    }

    protected void addOnClickProperty(String onclick) {
        this.addLazyMethodCombo(DesignerMsg.PROPERTY_ONCLICK, "onclick", onclick);
    }

    protected void addReferenceProperty(String currentReference) {
        Property reference = this.createReferenceProperty(currentReference);
        this.addProperty(reference, "reference");
    }

    protected void addRequiredProperty(boolean currentRequired) {
        BooleanProperty required = Factory.createBoolean((Msg)DesignerMsg.PROPERTY_REQUIRED, (boolean)currentRequired);
        this.addProperty((Property)required, "required");
    }

    protected void addTabIndexProperty(int tabindex) {
        if (!this.isRepeatableComponent()) {
            NumericProperty tabindexProperty = Factory.createIntegerNumber((Msg)DesignerMsg.PROPERTY_TABINDEX, (int)tabindex, (int)0, (int)Integer.MAX_VALUE, (int)1);
            NumericPropertyRenderer renderer = new NumericPropertyRenderer(){

                public String renderProperty(Property property) {
                    String result = super.renderProperty(property);
                    if (property.getValue().equals(0)) {
                        result = ProjectMsg.DEFAULT_VALUE.getString();
                    }
                    return result;
                }
            };
            ((AbstractProperty)tabindexProperty).setPropertyRenderer((PropertyRenderer)renderer);
            this.addProperty((Property)tabindexProperty, "tabindex");
        }
    }

    protected void addTransparentProperty(boolean currentTransparent) {
        BooleanProperty transparent = Factory.createBoolean((Msg)DesignerMsg.PROPERTY_TRANSPARENT, (boolean)currentTransparent);
        this.addProperty((Property)transparent, "transparent");
    }

    protected void addValidationMessageProperty(String currentMessage) {
        this.addMessageProperty(DesignerMsg.PROPERTY_VALIDATIONMESSAGE, currentMessage, "validationmessage");
    }

    protected void addMessageProperty(Msg msg, String currentMessage, String field) {
        Property message = this.createLongTranslatable(msg, currentMessage);
        this.addProperty(message, field);
    }

    protected void addValueProperty(final XFormValue value, boolean multiline) {
        String displayValue = value.getValue();
        Property property = multiline ? this.createLongTranslatable(DesignerMsg.PROPERTY_DISPLAY, displayValue) : this.createLongTranslatable(DesignerMsg.PROPERTY_DISPLAY, displayValue);
        this.properties_d.add(property);
        property.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object newValue = evt.getNewValue();
                ReferenceableComponentProperties.this.changeProperty("value_d", newValue, value);
            }
        });
    }

    protected AbstractProperty createTranslatable(Msg msg, String key) {
        return this.createTranslatable(msg, key, false);
    }

    protected Property createLongTranslatable(Msg msg, String key) {
        return this.createTranslatable(msg, key, true);
    }

    protected LazyComboProperty createLazyMethodCombo(Msg msg, String currentValue) {
        ComboValueProvider provider = new ComboValueProvider(){

            public Vector getValues() {
                return ReferenceableComponentProperties.this.componentInteractionProvider_d.getInvokeableMethods(ReferenceableComponentProperties.this);
            }

            public boolean isAllowNullValues() {
                return true;
            }
        };
        return this.createLazyMethodCombo(msg, currentValue, provider);
    }

    protected LazyComboProperty createLazyMethodCombo(Msg msg, String currentValue, ComboValueProvider provider) {
        LazyComboProperty comboProperty = Factory.createLazyCombo((Msg)msg, (ComboValueProvider)provider, (Object)(currentValue == null || "".equals(currentValue) ? "" : currentValue));
        LabelProvider.Default labelProvider = new LabelProvider.Default(){

            public String getText(Object element) {
                String prefix;
                String signature = String.valueOf(element);
                String string = prefix = signature.indexOf(":") > 0 ? signature.substring(0, signature.indexOf(":")) : "";
                if (prefix.trim().length() > 0) {
                    signature = signature.substring(signature.indexOf(":") + 1);
                }
                return prefix + ReferenceableComponentProperties.truncateSignature(signature);
            }
        };
        ComboPropertyEditor methodEditor = new ComboPropertyEditor();
        methodEditor.setLabelProvider((LabelProvider)labelProvider);
        comboProperty.setPropertyEditor((PropertyEditor)methodEditor);
        comboProperty.setPropertyRenderer(new PropertyRenderer(){

            public String getRenderer(Property property) {
                return this.renderProperty(property);
            }

            public String getToolTip(Property property) {
                return this.renderProperty(property);
            }

            private String renderProperty(Property property) {
                Object value = property.getValue();
                String result = "";
                if (value != null) {
                    String prefix;
                    String signature = value.toString();
                    String string = prefix = signature.indexOf(":") > 0 ? signature.substring(0, signature.indexOf(":")) : "";
                    if (prefix.trim().length() > 0) {
                        signature = signature.substring(signature.indexOf(":") + 1);
                    }
                    result = prefix + ReferenceableComponentProperties.truncateSignature(signature);
                }
                return result;
            }
        });
        return comboProperty;
    }

    protected Property createReferenceProperty(String currentReference) {
        return this.createReferenceProperty(DesignerMsg.PROPERTY_REFERENCE, currentReference);
    }

    protected ReferenceProperty createReferenceProperty(Msg msg, String currentReference) {
        ReferenceProperty reference = new ReferenceProperty(msg, currentReference, this.object_d, this.componentInteractionProvider_d.getObjectTypeDescription(), this.componentInteractionProvider_d.getPathFor(this.object_d));
        return reference;
    }

    protected Property createDisplayProperty(Msg propertyDisplay, String currentDisplay) {
        return this.createTranslatable(DesignerMsg.PROPERTY_DISPLAY, currentDisplay == null ? "" : currentDisplay);
    }

    private static String truncateSignature(String signature) {
        if (!signature.equals("")) {
            int index = (signature = signature.substring(1, signature.length())).indexOf(")");
            if (index > 0) {
                signature = signature.substring(0, index + 1);
            }
        } else {
            signature = DesignerMsg.PROPERTY_METHOD_NULL_VALUE.getString();
        }
        return signature;
    }

    private AbstractProperty createTranslatable(Msg msg, String key, boolean multiline) {
        Object result = this.canTranslate() ? new TranslatableProperty(msg, this.getAllValues(), key, multiline) : (multiline ? Factory.createLongText((Msg)msg, (String)key) : Factory.createText((Msg)msg, (String)key, (boolean)false));
        return result;
    }

    private boolean canTranslate() {
        return true;
    }

    private Map getAllValues() {
        return this.componentInteractionProvider_d.getResources();
    }
}

