/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.properties;

import oracle.bpm.designer.formdesigner.ChooseReferenceDialog;
import oracle.bpm.designer.formdesigner.properties.ExternalDialogPropertyEditor;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Frame;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.prop.AbstractProperty;
import oracle.bpm.ui.prop.Property;
import oracle.bpm.ui.prop.PropertyEditor;
import oracle.bpm.ui.prop.PropertyRenderer;
import oracle.bpm.ui.prop.ResetableProperty;
import oracle.bpm.ui.prop.impl.DefaultPropertyRenderer;
import oracle.bpm.xobject.xml.XFormXMLObject;

public class ReferenceProperty
extends AbstractProperty
implements ResetableProperty {
    private ObjectTypeDescription otd;
    private String pathString;
    private XFormXMLObject xmlObject;

    public ReferenceProperty(Msg key, String defaultReference, XFormXMLObject xmlObject, ObjectTypeDescription otd, String pathString) {
        this.xmlObject = xmlObject;
        this.otd = otd;
        this.pathString = pathString;
        this.setKey(key);
        this.setValue(defaultReference == null ? NULL_VALUE : defaultReference);
        DefaultPropertyRenderer renderer = new DefaultPropertyRenderer();
        ReferencePropertyEditor editor = new ReferencePropertyEditor();
        this.setPropertyRenderer((PropertyRenderer)renderer);
        this.setPropertyEditor((PropertyEditor)editor);
    }

    public Object getDefaultValue() {
        return NULL_VALUE;
    }

    private ObjectTypeDescription getObjectTypeDescription() {
        return this.otd;
    }

    private String getPathString() {
        return this.pathString;
    }

    private XFormXMLObject getXmlObject() {
        return this.xmlObject;
    }

    static class ReferencePropertyEditor
    extends ExternalDialogPropertyEditor {
        private String editorValue;

        ReferencePropertyEditor() {
        }

        public Object getCellEditorValue() {
            return this.editorValue == null ? this.field.getText() : this.editorValue;
        }

        @Override
        public String getPropertyValueRepresentation(Property property) {
            Object value = property.getValue();
            return value == null ? "" : value.toString();
        }

        @Override
        public void startEdit(UiContainer parent) {
            ReferenceProperty refProperty = (ReferenceProperty)this.getProperty();
            ChooseReferenceDialog choose = new ChooseReferenceDialog(refProperty.getObjectTypeDescription(), refProperty.getPathString(), refProperty.getXmlObject());
            choose.pack();
            choose.setLocationRelativeTo((UiComponent)((Frame)null));
            choose.setVisible(true);
            if (choose.userAccepted()) {
                this.editorValue = choose.getReference();
                this.stopCellEditing();
            } else {
                this.cancelCellEditing();
            }
        }
    }
}

