/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.properties;

import java.util.ArrayList;
import oracle.bpm.designer.formdesigner.ChangeListener;
import oracle.bpm.designer.formdesigner.properties.ComponentInteractionProvider;
import oracle.bpm.designer.formdesigner.properties.ReferenceableComponentProperties;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.prop.Factory;
import oracle.bpm.ui.prop.Property;
import oracle.bpm.ui.prop.impl.BooleanProperty;
import oracle.bpm.ui.prop.impl.NumericProperty;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.presentationmodel.XFormRadio;

public class RadioComponentProperties
extends ReferenceableComponentProperties {
    public RadioComponentProperties(XFormPresentationXMLObject referencedObject, ComponentInteractionProvider componentInteractionProvider, ChangeListener listener) {
        super(referencedObject, componentInteractionProvider, listener);
    }

    protected void addHasCacheProperty(boolean currentCache) {
        BooleanProperty cache = Factory.createBoolean((Msg)DesignerMsg.PROPERTY_CACHED, (boolean)currentCache);
        this.addProperty((Property)cache, "cache");
    }

    @Override
    protected void initProperties() {
        this.properties_d = new ArrayList();
        XFormRadio radio = (XFormRadio)this.getReferencedObject();
        this.addIdProperty(radio.getId());
        this.addReferenceProperty(radio.getReference());
        Property displayProperty = this.createLongTranslatable(DesignerMsg.PROPERTY_DISPLAY, radio.display);
        this.addProperty(displayProperty, "display");
        this.addOnChangeProperty(radio.onchange);
        NumericProperty columnNoProperty = Factory.createIntegerNumber((Msg)DesignerMsg.PROPERTY_COLS, (int)radio.cols, (int)0, (int)72, (int)1);
        this.addProperty(DesignerMsg.LAYOUT, (Property)columnNoProperty, "cols");
        NumericProperty rowNoProperty = Factory.createIntegerNumber((Msg)DesignerMsg.PROPERTY_ROWS, (int)radio.rows, (int)0, (int)72, (int)1);
        this.addProperty(DesignerMsg.LAYOUT, (Property)rowNoProperty, "rows");
        this.addValidationMessageProperty(radio.validationmessage);
        this.addRequiredProperty(radio.required);
        this.addEditableProperty(radio.editable);
        this.addTabIndexProperty(radio.getTabindex());
        if (this.isRepeatableComponent()) {
            this.addHasCacheProperty(radio.cache);
        }
        this.addFontProperty(radio.fonttype, radio.getFontStyle(), radio.fontsize);
        this.addBackgroundColorProperty(radio.bgcolor);
        this.addForegroundColorProperty(radio.fgcolor);
        this.addSimpleBorderProperty(radio.getBorderstyle(), radio.borderwidth, radio.bordercolor);
    }
}

