/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.properties;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.designer.formdesigner.properties.ComponentInteractionProvider;
import oracle.bpm.designer.formdesigner.properties.ComponentProperties;
import oracle.bpm.designer.formdesigner.properties.SimpleComponentProperties;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.log.Log;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.prop.CompositeProperty;
import oracle.bpm.ui.prop.Property;
import oracle.bpm.ui.prop.PropertyTable;

public class PropertyMerger {
    private ComponentInteractionProvider componentInteractionProvider;
    private MsgList groupNameList;
    private HashMap<Msg, List<Property>> propertiesHashMap;
    private List<Property> ungroupedPropertiesList;

    public PropertyMerger(List<ComponentProperties> lastSelectedProperties, ComponentInteractionProvider componentInteractionProvider) {
        this.componentInteractionProvider = componentInteractionProvider;
        if (lastSelectedProperties != null) {
            for (ComponentProperties properties : lastSelectedProperties) {
                this.merge(properties);
            }
        }
    }

    public static void showProperties(PropertyTable table, List<ComponentProperties> lastSelectedProperties, ComponentInteractionProvider componentInteractionProvider) {
        PropertyMerger merger = new PropertyMerger(lastSelectedProperties, componentInteractionProvider);
        merger.showProperties(table);
    }

    private static void removeAndMerge(List<Property> originalList, List<Property> newList) {
        ArrayList<Property> toRemove = new ArrayList<Property>();
        block0: for (Property property : originalList) {
            toRemove.add(property);
            for (Property iProperty : newList) {
                if (!iProperty.getKey().equals(property.getKey())) continue;
                toRemove.remove(property);
                ((CompositeProperty)property).compose(iProperty);
                continue block0;
            }
        }
        originalList.removeAll(toRemove);
    }

    private void merge(ComponentProperties properties) {
        if (properties instanceof SimpleComponentProperties) {
            SimpleComponentProperties simpleComponentProperties = (SimpleComponentProperties)properties;
            HashMap<Msg, List<Property>> propertiesHash = simpleComponentProperties.getPropertiesHash();
            List<Property> ungroupedProperties = simpleComponentProperties.getUngroupedProperties();
            MsgList groupNames = simpleComponentProperties.getVisibleGroupNames();
            if (this.propertiesHashMap == null) {
                this.propertiesHashMap = new HashMap();
                this.ungroupedPropertiesList = new ArrayList<Property>();
                this.groupNameList = MsgList.create(groupNames);
                for (Property ungroupedProperty : ungroupedProperties) {
                    if (DesignerMsg.PROPERTY_REFERENCE.equals(ungroupedProperty.getMsg()) || DesignerMsg.PROPERTY_ID.equals(ungroupedProperty.getMsg())) continue;
                    this.ungroupedPropertiesList.add((Property)new CompositeProperty(ungroupedProperty));
                }
                for (Msg groupName : groupNames) {
                    ArrayList<CompositeProperty> newList = new ArrayList<CompositeProperty>();
                    for (Property property : propertiesHash.get(groupName)) {
                        newList.add(new CompositeProperty(property));
                    }
                    this.propertiesHashMap.put(groupName, newList);
                }
            } else {
                List<Property> originalList = this.ungroupedPropertiesList;
                PropertyMerger.removeAndMerge(originalList, ungroupedProperties);
                MsgList toRemove = MsgList.create();
                for (Msg key : this.groupNameList) {
                    if (groupNames.contains(key)) continue;
                    toRemove.add(key);
                }
                this.groupNameList.removeAll(toRemove);
                for (Msg msg : this.groupNameList) {
                    PropertyMerger.removeAndMerge(this.propertiesHashMap.get(msg), propertiesHash.get(msg));
                }
            }
        } else {
            Log.logDebug("could not merge component properties" + properties);
        }
    }

    private void showProperties(PropertyTable table) {
        SimpleComponentProperties.addProperties(table, this.propertiesHashMap, this.ungroupedPropertiesList, this.groupNameList, this.componentInteractionProvider.isReadOnly());
    }
}

