/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.properties;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import oracle.bpm.data.html.BackgroundAttachment;
import oracle.bpm.data.html.BackgroundPositionX;
import oracle.bpm.data.html.BackgroundPositionY;
import oracle.bpm.data.html.BackgroundRepeat;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.formdesigner.ChangeListener;
import oracle.bpm.designer.formdesigner.XFormSelection;
import oracle.bpm.designer.formdesigner.actions.PresentationOTDAdapterFactory;
import oracle.bpm.designer.formdesigner.properties.ComponentInteractionProvider;
import oracle.bpm.designer.formdesigner.properties.ReferenceableComponentProperties;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.project.FuegoProject;
import oracle.bpm.project.io.fs.FileProjectWriter;
import oracle.bpm.project.io.fs.WebRoot;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectWriter;
import oracle.bpm.project.model.events.ProjectListener;
import oracle.bpm.project.model.events.ProjectListenerAdapter;
import oracle.bpm.project.model.fojsp.WebContentType;
import oracle.bpm.project.model.fojsp.WebRootObject;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.prop.Factory;
import oracle.bpm.ui.prop.Property;
import oracle.bpm.ui.prop.impl.BooleanProperty;
import oracle.bpm.ui.prop.impl.ComboProperty;
import oracle.bpm.ui.prop.impl.TextProperty;
import oracle.bpm.ui.selection.Selection;
import oracle.bpm.util.FileUtils;
import oracle.bpm.xobject.presentationmodel.XFormBackground;
import oracle.bpm.xobject.presentationmodel.XFormImage;
import oracle.bpm.xobject.presentationmodel.XFormPresentation;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.xml.XFormXMLObject;

public class PresentationComponentProperties
extends ReferenceableComponentProperties {
    public PresentationComponentProperties(XFormPresentationXMLObject referencedObject, ComponentInteractionProvider componentInteractionProvider, ChangeListener listener) {
        super(referencedObject, componentInteractionProvider, listener);
    }

    public static FuegoProject getProjectFromSelection() {
        ObjectTypeDescription objectTypeDescription;
        XFormSelection xFormSelection;
        FuegoProject fuegoProject = null;
        Selection selection = AbstractStudioWorkbench.getInstance().getSelectionProvider().getSelection();
        if (selection != null && (xFormSelection = (XFormSelection)selection.as(XFormSelection.class)) != null && (objectTypeDescription = new PresentationOTDAdapterFactory().adapt(xFormSelection, ObjectTypeDescription.class)) != null) {
            fuegoProject = FuegoProject.getFrom((TypeRef)objectTypeDescription);
        }
        return fuegoProject;
    }

    @Override
    protected void initProperties() {
        this.properties_d = new ArrayList();
        XFormPresentation referencedPresentation = (XFormPresentation)this.getReferencedObject();
        TextProperty id = Factory.createText((Msg)DesignerMsg.PROPERTY_ID, (String)referencedPresentation.id, (boolean)false);
        id.setEditable(false);
        this.properties_d.add(id);
        TextProperty reference = Factory.createText((Msg)DesignerMsg.PROPERTY_REFERENCE, (String)referencedPresentation.reference, (boolean)false);
        reference.setEditable(false);
        this.properties_d.add(reference);
        this.addLazyMethodCombo(DesignerMsg.PROPERTY_INITIALIZATIONMETHOD, "initializationmethod", referencedPresentation.initializationmethod);
        BooleanProperty cssSupport = Factory.createBoolean((Msg)DesignerMsg.PROPERTY_CSS_SUPPORT, (boolean)referencedPresentation.isCssEnabled());
        this.addProperty((Property)cssSupport, "iscssenabled");
        cssSupport.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                boolean cssEnable = (Boolean)evt.getNewValue();
                PresentationComponentProperties.this.setCssEnable(cssEnable);
            }
        });
        this.addBackground(referencedPresentation);
        this.addErrorProperties(referencedPresentation);
        this.addCssProperty(referencedPresentation);
    }

    private void addBackground(XFormPresentation xPresentation) {
        if (xPresentation.background == null) {
            xPresentation.background = new XFormBackground();
        }
        this.addColorProperty(DesignerMsg.BACKGROUND, DesignerMsg.BACK_COLOR, "bgcolor", xPresentation.bgcolor);
        this.addBackGroundProperties(xPresentation.background);
    }

    private void addBackGroundProperties(XFormBackground back) {
        XFormImage image = back.image;
        this.sub_object_d = image;
        this.addImageProperty(DesignerMsg.BACKGROUND, DesignerMsg.PROPERTY_GIFENCODED, "gifencoded", image.gifencoded, true);
        ComboProperty imageLayoutProperty = Factory.createCombo((Msg)DesignerMsg.BACKGROUND_REPEAT, (Object[])BackgroundRepeat.values(), (Object)back.getImageLayout());
        imageLayoutProperty.setAllowNullValues(true);
        this.initProperty((Property)imageLayoutProperty, "imageLayout", back);
        this.addPropertyTo(DesignerMsg.BACKGROUND, (Property)imageLayoutProperty);
        ComboProperty imageAttachmentProperty = Factory.createCombo((Msg)DesignerMsg.BACKGROUND_ATTACHMENT, (Object[])BackgroundAttachment.values(), (Object)back.getImageAttachment());
        this.initProperty((Property)imageAttachmentProperty, "imageAttachment", back);
        this.addPropertyTo(DesignerMsg.BACKGROUND, (Property)imageAttachmentProperty);
        ComboProperty imageXPositionProperty = Factory.createCombo((Msg)DesignerMsg.BACKGROUND_POSITION_X, (Object[])BackgroundPositionX.values(), (Object)back.getImageXPosition());
        this.initProperty((Property)imageXPositionProperty, "imageXPosition", back);
        this.addPropertyTo(DesignerMsg.BACKGROUND, (Property)imageXPositionProperty);
        ComboProperty imageYPositionProperty = Factory.createCombo((Msg)DesignerMsg.BACKGROUND_POSITION_Y, (Object[])BackgroundPositionY.values(), (Object)back.getImageYPosition());
        this.initProperty((Property)imageYPositionProperty, "imageYPosition", back);
        this.addPropertyTo(DesignerMsg.BACKGROUND, (Property)imageYPositionProperty);
    }

    private void addCssProperty(XFormPresentation xPresentation) {
        final FuegoProject fuegoProject = PresentationComponentProperties.getProjectFromSelection();
        final ComboProperty cssfilename = Factory.createCombo((Msg)DesignerMsg.PROPERTY_CSS_FILENAME, this.getCSSFiles(fuegoProject), (Object)xPresentation.getCssFilename());
        this.addProperty(DesignerMsg.PROPERTY_CSS, (Property)cssfilename, "cssfilename");
        TextProperty cssErrorClass = Factory.createText((Msg)DesignerMsg.PROPERTY_CSS_ERROR_CLASS, (String)xPresentation.errorcssclass, (boolean)false);
        this.addProperty(DesignerMsg.PROPERTY_CSS, (Property)cssErrorClass, "errorcssclass");
        if (!xPresentation.isCssEnabled()) {
            this.hideGroup(DesignerMsg.PROPERTY_CSS);
        }
        if (fuegoProject != null) {
            fuegoProject.addListener((ProjectListener)new ProjectListenerAdapter<WebRootObject>(WebRootObject.class){

                public void postObjectRemoved(WebRootObject object, ProjectObject parent) {
                    this.refreshProperty();
                }

                public void postObjectAdded(WebRootObject object, ProjectObject parent) {
                    this.refreshProperty();
                }

                private void refreshProperty() {
                    UiUtilities.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            cssfilename.setValues(PresentationComponentProperties.this.getCSSFiles(fuegoProject));
                        }
                    });
                }
            });
        }
    }

    private Vector<String> getCSSFiles(FuegoProject fuegoProject) {
        Vector<String> result = new Vector<String>();
        if (fuegoProject != null) {
            FileProjectWriter projectWriter = (FileProjectWriter)fuegoProject.getWriter();
            List<File> list = FileUtils.getFilesRecursively(WebRoot.getResourcesDir((ProjectWriter)projectWriter), WebContentType.CSS.getFileFilter(true), false);
            for (File file : list) {
                String relativePath = this.getWebRootRelativePath(Path.getPath((File)file), projectWriter);
                result.add(relativePath);
            }
        }
        return result;
    }

    private String getWebRootRelativePath(Path path, FileProjectWriter projectWriter) {
        String fullPath = path.toString();
        File rootDir = WebRoot.getWebRootDir((ProjectWriter)projectWriter);
        int index = fullPath.indexOf(rootDir.getName());
        return fullPath.substring(index);
    }

    private void addErrorProperties(XFormPresentation xPresentation) {
        this.addColorProperty(DesignerMsg.ERROR, DesignerMsg.BACK_COLOR, "errorbgcolor", xPresentation.errorbgcolor);
        this.addColorProperty(DesignerMsg.ERROR, DesignerMsg.PROPERTY_FGCOLOR, "errorfgcolor", xPresentation.errorfgcolor);
        Property fontProperty = this.createFontProperty(DesignerMsg.ERROR, "errorfonttype", xPresentation.errorfonttype, "errorfontface", xPresentation.getErrorFontStyle(), "errorfontsize", xPresentation.errorfontsize);
        this.addPropertyTo(DesignerMsg.ERROR, fontProperty);
        BooleanProperty clientErrorAsPopup = Factory.createBoolean((Msg)DesignerMsg.PROPERTY_CLIENT_ERRORS_ASPOPUP, (boolean)xPresentation.isClienterroraspopup());
        this.addProperty(DesignerMsg.ERROR, (Property)clientErrorAsPopup, "clienterroraspopup");
    }

    private void initProperty(Property p, final String propertyName, final XFormXMLObject where) {
        p.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object newValue = evt.getNewValue();
                PresentationComponentProperties.this.changeProperty(propertyName, newValue, where);
            }
        });
    }

    private void setCssEnable(boolean cssEnable) {
        if (cssEnable) {
            this.showGroup(DesignerMsg.PROPERTY_CSS);
        } else {
            this.hideGroup(DesignerMsg.PROPERTY_CSS);
        }
    }
}

