/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.properties;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import oracle.bpm.data.html.LinkType;
import oracle.bpm.data.html.TextType;
import oracle.bpm.designer.formdesigner.ChangeListener;
import oracle.bpm.designer.formdesigner.properties.ComponentInteractionProvider;
import oracle.bpm.designer.formdesigner.properties.FormDesignerMultiProperty;
import oracle.bpm.designer.formdesigner.properties.LabelComponentProperties;
import oracle.bpm.designer.formdesigner.properties.ReferenceProperty;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.prop.AbstractProperty;
import oracle.bpm.ui.prop.Factory;
import oracle.bpm.ui.prop.Property;
import oracle.bpm.ui.prop.impl.TextProperty;
import oracle.bpm.webformdesigner.msg.WebformdesignerMsg;
import oracle.bpm.xobject.presentationmodel.XFormLink;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;

public class LinkComponentProperties
extends LabelComponentProperties {
    private boolean isChangingType = false;
    private boolean isChangingTypeTextType = false;

    public LinkComponentProperties(XFormPresentationXMLObject referencedObject, ComponentInteractionProvider componentInteractionProvider, ChangeListener listener) {
        super(referencedObject, componentInteractionProvider, listener);
    }

    public static boolean isLinkReference(String type) {
        return type != null && LinkType.valueOf(type).equals(LinkType.REFERENCE);
    }

    protected void addLinkProperty(Msg linkGroupName, XFormLink formLink) {
        this.addFontProperty(this.referencedLabel.fonttype, this.referencedLabel.getFontStyle(), this.referencedLabel.fontsize);
        this.addBackgroundColorProperty(this.referencedLabel.bgcolor);
        this.addForegroundColorProperty(this.referencedLabel.fgcolor);
        this.addLinkProperties(formLink);
        this.addTextProperties(formLink);
    }

    @Override
    protected void initProperties() {
        this.properties_d = new ArrayList();
        XFormLink link = (XFormLink)this.referencedLabel;
        this.addIdProperty(link.id);
        this.addLinkProperty(DesignerMsg.PROPERTY_HREF, link);
    }

    private void addLinkProperties(XFormLink formLink) {
        LinkType linkType = formLink.getEnumLinkType();
        String value = formLink.getLinkValue();
        PropertyChangeListener changeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LinkComponentProperties.this.changeProperty("linkValue", evt.getNewValue());
            }
        };
        TextProperty anchorProperty = Factory.createText((Msg)DesignerMsg.ANCHOR_NAME, (String)(linkType == LinkType.ANCHOR ? value : null), (boolean)false);
        TextProperty externalProperty = Factory.createText((Msg)LibMsg.URL, (String)(linkType == LinkType.EXTERNAL ? value : null), (boolean)false);
        TextProperty localProperty = Factory.createText((Msg)DesignerMsg.TARGET_ANCHOR, (String)(linkType == LinkType.LOCAL ? value : null), (boolean)false);
        ReferenceProperty referenceProperty = this.createReferenceProperty(DesignerMsg.REFERENCE, linkType == LinkType.REFERENCE ? value : null);
        anchorProperty.addPropertyChangeListener(changeListener);
        externalProperty.addPropertyChangeListener(changeListener);
        localProperty.addPropertyChangeListener(changeListener);
        referenceProperty.addPropertyChangeListener(changeListener);
        final FormDesignerMultiProperty valueProperty = new FormDesignerMultiProperty(1, new AbstractProperty[]{anchorProperty, externalProperty, localProperty, referenceProperty});
        Property typeProperty = this.createLinkTypeCombo();
        typeProperty.setValue((Object)linkType);
        valueProperty.changeCurrent(linkType.ordinal());
        valueProperty.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (LinkComponentProperties.this.isChangingType) {
                    LinkComponentProperties.this.silentChangeProperty("linkValue", evt.getNewValue());
                } else {
                    LinkComponentProperties.this.changeProperty("linkValue", evt.getNewValue());
                }
            }
        });
        typeProperty.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LinkComponentProperties.this.isChangingType = true;
                LinkType newValue = (LinkType)evt.getNewValue();
                valueProperty.changeCurrent(newValue.ordinal());
                LinkComponentProperties.this.changeProperty("linkType", newValue.name());
                LinkComponentProperties.this.isChangingType = false;
            }
        });
        this.addProperty(WebformdesignerMsg.LINK, typeProperty, "linkType");
        this.addProperty(WebformdesignerMsg.LINK, (Property)valueProperty, "linkText");
    }

    private void addTextProperties(final XFormLink formLink) {
        TextType textType = formLink.getEnumTextType();
        String value = formLink.getTextValue();
        boolean isReference = textType == TextType.REFERENCE;
        boolean isFixed = !isReference;
        ReferenceProperty referenceProperty = this.createReferenceProperty(DesignerMsg.REFERENCE, isReference ? value : null);
        AbstractProperty fixedProperty = this.createTranslatable(DesignerMsg.TEXT, isFixed ? value : null);
        referenceProperty.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LinkComponentProperties.this.silentChangeProperty("textValue", evt.getNewValue());
                LinkComponentProperties.this.changeProperty("value_d", (Object)"Link", formLink);
            }
        });
        fixedProperty.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object value = evt.getNewValue();
                LinkComponentProperties.this.silentChangeProperty("textValue", value);
                LinkComponentProperties.this.changeProperty("value_d", value, formLink);
            }
        });
        final FormDesignerMultiProperty valueProperty = new FormDesignerMultiProperty(isFixed ? 0 : 1, fixedProperty, referenceProperty);
        Property typeProperty = this.createCombo(DesignerMsg.TEXT_TYPE);
        typeProperty.setValue((Object)(isFixed ? TextType.FIXED : TextType.REFERENCE));
        typeProperty.setValue((Object)textType);
        valueProperty.changeCurrent(textType.ordinal());
        valueProperty.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (LinkComponentProperties.this.isChangingTypeTextType) {
                    LinkComponentProperties.this.silentChangeProperty("textValue", evt.getNewValue());
                } else {
                    LinkComponentProperties.this.changeProperty("textValue", evt.getNewValue());
                }
            }
        });
        typeProperty.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LinkComponentProperties.this.isChangingTypeTextType = true;
                TextType newValue = (TextType)evt.getNewValue();
                valueProperty.changeCurrent(newValue.ordinal());
                LinkComponentProperties.this.changeProperty("textType", newValue.name());
                LinkComponentProperties.this.isChangingTypeTextType = false;
            }
        });
        this.addProperty(WebformdesignerMsg.LINK, typeProperty, "textType");
        this.addProperty(WebformdesignerMsg.LINK, (Property)valueProperty, "textText");
    }

    private Property createCombo(Msg linkTypeMsg) {
        return Factory.createCombo((Msg)linkTypeMsg, (Object[])TextType.values(), (int)0);
    }

    private Property createLinkTypeCombo() {
        return Factory.createCombo((Msg)DesignerMsg.LINK_TYPE, (Object[])LinkType.values(), (int)0);
    }
}

