/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.properties;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.filechooser.FileChooser;
import oracle.bpm.ui.layout.AttributeConstraint;
import oracle.bpm.ui.layout.AttributeType;
import oracle.bpm.ui.layout.Constraint;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.RelativeLayout;
import oracle.bpm.ui.prop.AbstractProperty;
import oracle.bpm.ui.prop.Property;
import oracle.bpm.ui.prop.PropertyEditor;
import oracle.bpm.ui.prop.PropertyRenderer;
import oracle.bpm.ui.prop.ResetableProperty;
import oracle.bpm.ui.prop.impl.AbstractEditor;
import oracle.bpm.ui.utils.FilesUtils;
import oracle.bpm.util.Base64;
import oracle.bpm.webformdesigner.msg.WebformdesignerMsg;

public class ImageFileProperty
extends AbstractProperty
implements ResetableProperty {
    private static FilePropertyEditor myeditor;
    static FilePropertyRenderer myrenderer;

    public ImageFileProperty(Msg key, String defaultFile) {
        this.setKey(key);
        this.setValue(defaultFile);
        if (myrenderer == null) {
            myrenderer = new FilePropertyRenderer();
        }
        if (myeditor == null) {
            myeditor = new FilePropertyEditor();
        }
        this.setPropertyEditor((PropertyEditor)myeditor);
        this.setPropertyRenderer(myrenderer);
    }

    public Image getImage() {
        return this.getValue() != null && this.getValue() != Property.NULL_VALUE ? Image.create((Msg)WebformdesignerMsg.IMAGE) : null;
    }

    public void setValue(Object o) {
        if (o instanceof File) {
            o = ImageFileProperty.getEncodedImage((File)o);
        }
        super.setValue(o);
    }

    public Object getDefaultValue() {
        return NULL_VALUE;
    }

    private static String getEncodedImage(File file) {
        try {
            int howMany;
            FileInputStream f = new FileInputStream(file);
            byte[] temp = new byte[]{};
            byte[] complete = new byte[]{};
            int c = 0;
            do {
                int i;
                byte[] temp2 = new byte[complete.length + c];
                for (i = 0; i < complete.length; ++i) {
                    temp2[i] = complete[i];
                }
                int j = 0;
                while (j < c) {
                    temp2[i] = temp[i];
                    ++j;
                    ++i;
                }
                complete = temp2;
            } while ((c = f.read(temp = new byte[howMany = f.available()])) > 0);
            return Base64.encode(complete);
        }
        catch (IOException e) {
            return null;
        }
    }

    private static class FilePropertyRenderer
    implements PropertyRenderer {
        private FilePropertyRenderer() {
        }

        public String getRenderer(Property property) {
            return FilePropertyRenderer.renderProperty(property);
        }

        public String getToolTip(Property property) {
            return FilePropertyRenderer.renderProperty(property);
        }

        private static String renderProperty(Property property) {
            ImageFileProperty imageProperty = (ImageFileProperty)property;
            return imageProperty.getImage() != null ? "<" + WebformdesignerMsg.IMAGE.getString() + ">" : "";
        }
    }

    public static class FilePropertyEditor
    extends AbstractEditor {
        private FileChooser chooser;

        public Object getCellEditorValue() {
            return this.getChooser().getSelectedFile();
        }

        public UiComponent getEditor(UiContainer parent) {
            return this.createEditor(parent);
        }

        protected ImageFileProperty getProperty() {
            return (ImageFileProperty)super.getProperty();
        }

        private FileChooser getChooser() {
            if (this.chooser == null) {
                this.chooser = FilesUtils.createWebImageSelectionChooser();
            }
            return this.chooser;
        }

        private Panel createEditor(UiContainer parent) {
            final Panel mainPanel = new Panel(parent);
            RelativeLayout layout = new RelativeLayout();
            mainPanel.setLayout((Layout)layout);
            mainPanel.setOpaque(false);
            mainPanel.setBorder(null);
            Label field = Label.create((UiContainer)mainPanel);
            field.setBorder(null);
            field.setOpaque(false);
            field.setIcon(this.getProperty().getImage());
            Button triggerButton = new Button((UiContainer)mainPanel);
            triggerButton.setAction(new BaseAction("..."){

                public void run() {
                    FilePropertyEditor.this.startEdit((UiContainer)mainPanel);
                }
            });
            triggerButton.setDefaultCapable(false);
            triggerButton.setFocusPainted(false);
            mainPanel.add((UiComponent)field, (Object)"field");
            mainPanel.add((UiComponent)triggerButton, (Object)"button");
            this.layoutComponents(layout);
            return mainPanel;
        }

        private void layoutComponents(RelativeLayout layout) {
            layout.addConstraint("button", AttributeType.RIGHT, (Constraint)new AttributeConstraint("_container", AttributeType.RIGHT, -1));
            layout.addConstraint("button", AttributeType.TOP, (Constraint)new AttributeConstraint("_container", AttributeType.TOP));
            layout.addConstraint("button", AttributeType.BOTTOM, (Constraint)new AttributeConstraint("_container", AttributeType.BOTTOM));
            layout.addConstraint("button", AttributeType.WIDTH, (Constraint)new AttributeConstraint("_container", AttributeType.HEIGHT));
            layout.addConstraint("field", AttributeType.TOP, (Constraint)new AttributeConstraint("_container", AttributeType.TOP));
            layout.addConstraint("field", AttributeType.BOTTOM, (Constraint)new AttributeConstraint("_container", AttributeType.BOTTOM));
            layout.addConstraint("field", AttributeType.RIGHT, (Constraint)new AttributeConstraint("button", AttributeType.LEFT, -1));
            layout.addConstraint("field", AttributeType.LEFT, (Constraint)new AttributeConstraint("_container", AttributeType.LEFT, 1));
        }

        private void startEdit(UiContainer parent) {
            FileChooser chooser = this.getChooser();
            int option = chooser.showOpenDialog((UiComponent)parent);
            if (option == 0) {
                this.stopCellEditing();
            }
        }
    }
}

