/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.properties;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Vector;
import oracle.bpm.data.html.TextType;
import oracle.bpm.designer.formdesigner.ChangeListener;
import oracle.bpm.designer.formdesigner.properties.ComponentInteractionProvider;
import oracle.bpm.designer.formdesigner.properties.FormDesignerMultiProperty;
import oracle.bpm.designer.formdesigner.properties.ReferenceProperty;
import oracle.bpm.designer.formdesigner.properties.ReferenceableComponentProperties;
import oracle.bpm.designer.formdesigner.properties.SimpleComponentProperties;
import oracle.bpm.designer.formdesigner.properties.SizeProperty;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.prop.AbstractProperty;
import oracle.bpm.ui.prop.Factory;
import oracle.bpm.ui.prop.Property;
import oracle.bpm.ui.prop.impl.ComboProperty;
import oracle.bpm.ui.prop.impl.TextProperty;
import oracle.bpm.xobject.presentationmodel.SimpleBorderProperties;
import oracle.bpm.xobject.presentationmodel.XFormIframe;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;

public class IFrameComponentProperties
extends ReferenceableComponentProperties {
    private XFormIframe xiframe;
    private static final String SCROLL = "yes";
    private static final String NO_SCROLL = "no";
    private static final String AUTO_SCROLL = "auto";

    public IFrameComponentProperties(XFormPresentationXMLObject referencedObject, ComponentInteractionProvider componentInteractionProvider, ChangeListener listener) {
        super(referencedObject, componentInteractionProvider, listener);
        this.xiframe = (XFormIframe)referencedObject;
    }

    @Override
    protected void initProperties() {
        this.properties_d = new ArrayList();
        this.addIdProperty(this.xiframe.getId());
        this.addSizeProperty(DesignerMsg.PROPERTY_WIDTH, this.xiframe.getWidth(), "width");
        this.addSizeProperty(DesignerMsg.PROPERTY_HEIGHT, this.xiframe.getHeight(), "height");
        this.addSrcProperty();
        this.addScrollingProperty();
        this.addSimpleBorderProperty(this.xiframe);
    }

    protected void addSimpleBorderProperty(SimpleBorderProperties properties) {
        SimpleBorderProperties simpleBorderProperties = (SimpleBorderProperties)((Object)this.object_d);
        this.addSimpleBorderProperty(simpleBorderProperties.getBorderstyle(), simpleBorderProperties.getBorderwidth(), simpleBorderProperties.getBordercolor());
    }

    protected void addSizeProperty(Msg msg, String currentValue, String propertyName) {
        SizeProperty sizeProperty = new SizeProperty(msg, currentValue);
        this.addProperty((Property)sizeProperty, propertyName);
    }

    private void addScrollingProperty() {
        Vector<Msg> scrollingValues = new Vector<Msg>();
        scrollingValues.add(DesignerMsg.PROPERTY_NO_SCROLL);
        scrollingValues.add(DesignerMsg.PROPERTY_SCROLL);
        scrollingValues.add(DesignerMsg.PROPERTY_AUTO_SCROLL);
        String scrollingValue = this.xiframe.getScrolling();
        Msg scrollingSelection = SCROLL.equals(scrollingValue) ? DesignerMsg.PROPERTY_SCROLL : (NO_SCROLL.equals(scrollingValue) ? DesignerMsg.PROPERTY_NO_SCROLL : (AUTO_SCROLL.equals(scrollingValue) ? DesignerMsg.PROPERTY_AUTO_SCROLL : null));
        ComboProperty scrolling = Factory.createCombo((Msg)DesignerMsg.PROPERTY_SCROLLING, scrollingValues, (Object)scrollingSelection);
        SimpleComponentProperties.PreParser scrollingParser = new SimpleComponentProperties.PreParser(){

            @Override
            public Object preParse(Object object) {
                String result = null;
                if (object == DesignerMsg.PROPERTY_NO_SCROLL) {
                    result = IFrameComponentProperties.NO_SCROLL;
                } else if (object == DesignerMsg.PROPERTY_SCROLL) {
                    result = IFrameComponentProperties.SCROLL;
                } else if (object == DesignerMsg.PROPERTY_AUTO_SCROLL) {
                    result = IFrameComponentProperties.AUTO_SCROLL;
                }
                return result;
            }
        };
        this.addProperty((Property)scrolling, "scrolling", scrollingParser);
    }

    private void addSrcProperty() {
        TextType scrType = this.xiframe.getSrcType();
        String value = this.xiframe.getSrc();
        boolean isReference = scrType == TextType.REFERENCE;
        boolean isFixed = !isReference;
        ReferenceProperty referenceProperty = this.createReferenceProperty(DesignerMsg.REFERENCE, isReference ? value : null);
        TextProperty fixedProperty = Factory.createText((Msg)DesignerMsg.TEXT, (String)(isFixed ? value : null), (boolean)false);
        referenceProperty.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object value = evt.getNewValue();
                IFrameComponentProperties.this.changeProperty("src", value);
                IFrameComponentProperties.this.changeProperty("src", value, IFrameComponentProperties.this.xiframe);
            }
        });
        fixedProperty.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object value = evt.getNewValue();
                IFrameComponentProperties.this.changeProperty("src", value);
                IFrameComponentProperties.this.changeProperty("src", value, IFrameComponentProperties.this.xiframe);
            }
        });
        final FormDesignerMultiProperty valueProperty = new FormDesignerMultiProperty(isFixed ? 0 : 1, new AbstractProperty[]{fixedProperty, referenceProperty});
        Property typeProperty = this.createCombo(DesignerMsg.TEXT_TYPE);
        typeProperty.setValue((Object)(isFixed ? TextType.FIXED : TextType.REFERENCE));
        typeProperty.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TextType newValue = (TextType)evt.getNewValue();
                valueProperty.changeCurrent(newValue.ordinal());
                IFrameComponentProperties.this.changeProperty("srctype", (Object)newValue.name(), IFrameComponentProperties.this.xiframe);
            }
        });
        typeProperty.setValue((Object)scrType);
        valueProperty.changeCurrent(scrType.ordinal());
        this.addProperty(DesignerMsg.PROPERTY_SRC, typeProperty, "srctype");
        this.addProperty(DesignerMsg.PROPERTY_SRC, (Property)valueProperty, "src");
    }

    private Property createCombo(Msg linkTypeMsg) {
        return Factory.createCombo((Msg)linkTypeMsg, (Object[])TextType.values(), (int)0);
    }
}

