/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.properties;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Vector;
import oracle.bpm.designer.formdesigner.ChangeListener;
import oracle.bpm.designer.formdesigner.properties.ComponentInteractionProvider;
import oracle.bpm.designer.formdesigner.properties.ReferenceableComponentProperties;
import oracle.bpm.designer.formdesigner.properties.SimpleComponentProperties;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.IntervalFormat;
import oracle.bpm.lang.IntervalUnit;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.prop.AbstractProperty;
import oracle.bpm.ui.prop.Factory;
import oracle.bpm.ui.prop.Property;
import oracle.bpm.ui.prop.PropertyEditor;
import oracle.bpm.ui.prop.PropertyRenderer;
import oracle.bpm.ui.prop.impl.AbstractEditor;
import oracle.bpm.ui.prop.impl.BooleanProperty;
import oracle.bpm.ui.prop.impl.ComboProperty;
import oracle.bpm.ui.prop.impl.ComboValueProvider;
import oracle.bpm.ui.prop.impl.LazyComboProperty;
import oracle.bpm.ui.prop.impl.NumericProperty;
import oracle.bpm.ui.text.IntervalField;
import oracle.bpm.xobject.GraphicType;
import oracle.bpm.xobject.presentationmodel.XFormGraphic;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;

public abstract class GraphicComponentProperties
extends ReferenceableComponentProperties {
    public GraphicComponentProperties(XFormPresentationXMLObject object, ComponentInteractionProvider componentInteractionProvider, ChangeListener listener) {
        super(object, componentInteractionProvider, listener);
    }

    protected abstract Vector getClickMethods();

    protected abstract Vector getCtrlClickMethods();

    protected abstract Vector getMethods();

    protected abstract Vector getSortedValues();

    protected void addDefaultProperties() {
        XFormGraphic graphic = (XFormGraphic)this.getReferencedObject();
        this.addIdProperty(graphic.getId());
        ComboValueProvider valueProvider = new ComboValueProvider(){

            public Vector getValues() {
                return GraphicComponentProperties.this.getMethods();
            }

            public boolean isAllowNullValues() {
                return true;
            }
        };
        this.addLazyMethodCombo(DesignerMsg.PROPERTY_METHODINVOCATION, "methodinvocation", graphic.methodinvocation, valueProvider);
        Vector values1 = this.getSortedValues();
        ComboProperty comboProperty = Factory.createCombo((Msg)DesignerMsg.PROPERTY_GRAPHIC_TYPE, (Vector)values1, (Object)graphic.getEnumType());
        SimpleComponentProperties.PreParser parser = new SimpleComponentProperties.PreParser(){

            @Override
            public Object preParse(Object val) {
                GraphicType value = null;
                if (val != null && val != Property.NULL_VALUE && val instanceof GraphicType) {
                    value = (GraphicType)val;
                }
                return value;
            }
        };
        comboProperty.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                GraphicComponentProperties.this.changedGraphicType(evt.getNewValue());
            }
        });
        this.addProperty((Property)comboProperty, "type", parser);
        Property refreshrate = GraphicComponentProperties.createIntervalSpinner(DesignerMsg.PROPERTY_REFRESHRATE, Interval.valueOf(Interval.ONE_SECOND.getMicroSeconds() * (long)graphic.refreshrate));
        SimpleComponentProperties.PreParser intervalPreParser = new SimpleComponentProperties.PreParser(){

            @Override
            public Object preParse(Object object) {
                if (object != null && object != Property.NULL_VALUE) {
                    return ((Interval)object).getSeconds();
                }
                return null;
            }
        };
        this.addProperty(refreshrate, "refreshrate", intervalPreParser);
        this.addOnClickProperties();
        this.addBackgroundColorProperty(graphic.bgcolor);
        this.addColorProperty(DesignerMsg.PROPERTY_VALUE_COLOR, "valuecolor", graphic.valuecolor);
        this.addFontProperty(DesignerMsg.PROPERTY_VALUE_FONT, "valuefonttype", graphic.valuefonttype, "valuefontface", graphic.getValueFontProperties().getFontStyle(), "valuefontsize", graphic.valuefontsize);
        this.addColorProperty(DesignerMsg.PROPERTY_OUTLINE_COLOR, "outlinecolor", graphic.outlinecolor);
        BooleanProperty hasDynamicType = Factory.createBoolean((Msg)DesignerMsg.PROPERTY_HAS_DYNAMIC_TYPE, (boolean)graphic.getHasdynamictype());
        BooleanProperty hasForcedRefresh = Factory.createBoolean((Msg)DesignerMsg.PROPERTY_HAS_FORCED_REFRESH, (boolean)graphic.getHasforcedrefresh());
        this.addProperty((Property)hasForcedRefresh, "hasforcedrefresh");
        this.addProperty((Property)hasDynamicType, "hasdynamictype");
        this.addSimpleBorderProperty(graphic.getBorderstyle(), graphic.getBorderwidth(), graphic.getBordercolor());
    }

    protected void addLazyMethodCombo(Msg propertyMsg, String propertyId, String currentValue, ComboValueProvider values) {
        LazyComboProperty comboProperty = this.createLazyMethodCombo(propertyMsg, currentValue, values);
        this.addProperty((Property)comboProperty, propertyId);
    }

    protected void addSizeProperties() {
        XFormGraphic graphic = (XFormGraphic)this.getReferencedObject();
        NumericProperty width = Factory.createIntegerNumber((Msg)DesignerMsg.PROPERTY_WIDTH, (int)graphic.getWidth(), (int)150, (int)1000, (int)1);
        NumericProperty height = Factory.createIntegerNumber((Msg)DesignerMsg.PROPERTY_HEIGHT, (int)graphic.getHeight(), (int)150, (int)1000, (int)1);
        this.addProperty(ProjectMsg.SIZE, (Property)width, "width");
        this.addProperty(ProjectMsg.SIZE, (Property)height, "height");
    }

    protected void addTitleProperties() {
        XFormGraphic graphic = (XFormGraphic)this.getReferencedObject();
        AbstractProperty title = this.createTranslatable(DesignerMsg.PROPERTY_TITLE, graphic.getTitle());
        this.addProperty(DesignerMsg.PROPERTY_TITLE, (Property)title, "title");
        this.addFontProperty(DesignerMsg.PROPERTY_TITLE, graphic.fonttype, graphic.getFontStyle(), graphic.fontsize);
        this.addColorProperty(DesignerMsg.PROPERTY_TITLE, DesignerMsg.PROPERTY_TITLE_BGCOLOR, "titlebackground", graphic.titlebackground);
        this.addColorProperty(DesignerMsg.PROPERTY_TITLE, DesignerMsg.PROPERTY_TITLE_FGCOLOR, "titleforeground", graphic.titleforeground);
    }

    protected void changedGraphicType(Object o) {
    }

    @Override
    protected void initProperties() {
        this.properties_d = new ArrayList();
        this.addDefaultProperties();
        this.addSizeProperties();
        this.addTitleProperties();
    }

    private static int getArgCount(String signature) {
        if (signature != null && !signature.equals("")) {
            int startIndex = signature.indexOf("(");
            int endIndex = signature.indexOf(")");
            if (endIndex > startIndex) {
                if ((signature = signature.substring(startIndex, endIndex)).indexOf(59) != -1) {
                    if (signature.indexOf(59) != signature.lastIndexOf(59)) {
                        return 2;
                    }
                    return 1;
                }
                return 0;
            }
        }
        return 0;
    }

    private static Property createIntervalSpinner(Msg id, Interval value) {
        IntervalSpinnerProperty p = new IntervalSpinnerProperty(id, value);
        return p;
    }

    private void addOnClickProperties() {
        XFormGraphic graphic = (XFormGraphic)this.getReferencedObject();
        ComboValueProvider onClickProvider = new ComboValueProvider(){

            public Vector getValues() {
                return GraphicComponentProperties.this.getClickMethods();
            }

            public boolean isAllowNullValues() {
                return true;
            }
        };
        ComboValueProvider onCtrlClickProvider = new ComboValueProvider(){

            public Vector getValues() {
                return GraphicComponentProperties.this.getCtrlClickMethods();
            }

            public boolean isAllowNullValues() {
                return true;
            }
        };
        LazyComboProperty onClickProperty = this.createLazyMethodCombo(DesignerMsg.PROPERTY_ONCLICK, graphic.getOnclick(), onClickProvider);
        onClickProperty.addPropertyChangeListener(this.createOnClickListener("onclick", "onclickargqty"));
        this.properties_d.add(onClickProperty);
        LazyComboProperty onCtrlClickProperty = this.createLazyMethodCombo(DesignerMsg.PROPERTY_BACKMETHOD, graphic.getBackmethod(), onCtrlClickProvider);
        onCtrlClickProperty.addPropertyChangeListener(this.createOnClickListener("backmethod", "backargqty"));
        this.properties_d.add(onCtrlClickProperty);
    }

    private PropertyChangeListener createOnClickListener(final String onClickMethodName, final String argQtyName) {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object newValue = evt.getNewValue();
                if (newValue == Property.NULL_VALUE) {
                    newValue = null;
                }
                int argQty = GraphicComponentProperties.getArgCount((String)newValue);
                GraphicComponentProperties.this.changeProperty(onClickMethodName, newValue);
                GraphicComponentProperties.this.changeProperty(argQtyName, argQty);
            }
        };
    }

    private static class IntervalSpinnerRenderer
    implements PropertyRenderer {
        private IntervalSpinnerRenderer() {
        }

        public String getRenderer(Property property) {
            return IntervalSpinnerRenderer.renderProperty(property);
        }

        public String getToolTip(Property property) {
            return IntervalSpinnerRenderer.renderProperty(property);
        }

        private static String renderProperty(Property property) {
            Object value = property.getValue();
            if (value == null || value == Property.NULL_VALUE) {
                return "()";
            }
            IntervalFormat format = IntervalFormat.getInstance(IntervalUnit.HOURS, IntervalUnit.SECONDS, Locale.getDefault());
            return format.format(value);
        }
    }

    private static final class IntervalSpinnerProperty
    extends AbstractProperty {
        public IntervalSpinnerProperty(Msg key, Interval value) {
            this.setKey(key);
            this.setValue(value);
            this.setPropertyRenderer(new IntervalSpinnerRenderer());
            this.setPropertyEditor((PropertyEditor)new IntervalSpinnerEditor());
        }
    }

    private static class IntervalSpinnerEditor
    extends AbstractEditor {
        private IntervalField editor;

        private IntervalSpinnerEditor() {
        }

        public Object getCellEditorValue() {
            return this.editor.getInterval();
        }

        public UiComponent getEditor(UiContainer parent) {
            this.editor = this.createEditor(parent);
            Object value = this.getProperty().getValue();
            if (value != null) {
                this.editor.setInterval((Interval)value);
            }
            return this.editor;
        }

        private IntervalField createEditor(UiContainer parent) {
            this.editor = new IntervalField(parent, IntervalUnit.HOURS, IntervalUnit.SECONDS);
            this.editor.setBorder(null);
            return this.editor;
        }
    }
}

