/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.properties;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import oracle.bpm.designer.formdesigner.ChangeListener;
import oracle.bpm.designer.formdesigner.properties.ComponentInteractionProvider;
import oracle.bpm.designer.formdesigner.properties.GraphicComponentProperties;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.prop.Factory;
import oracle.bpm.ui.prop.Property;
import oracle.bpm.ui.prop.PropertyGroup;
import oracle.bpm.ui.prop.impl.NumericProperty;
import oracle.bpm.ui.prop.impl.TextProperty;
import oracle.bpm.xobject.GraphicType;
import oracle.bpm.xobject.presentationmodel.XFormGauge;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;

public class GaugeComponentProperties
extends GraphicComponentProperties {
    private static Vector values;

    public GaugeComponentProperties(XFormPresentationXMLObject object, ComponentInteractionProvider componentInteractionProvider, ChangeListener listener) {
        super(object, componentInteractionProvider, listener);
    }

    protected void addBoundaryProperties() {
        XFormGauge gauge = (XFormGauge)this.getReferencedObject();
        this.addRangeProperty(DesignerMsg.BOUNDARIES, LibMsg.RANGE, "min_limit", "max_limit", gauge.getMin_limit(), gauge.getMax_limit());
        this.addRangeProperty(DesignerMsg.BOUNDARIES, DesignerMsg.NORMAL_RANGE, "normal_level", "normal_level_max", gauge.getNormal_level(), gauge.getNormal_level_max());
        this.addRangeProperty(DesignerMsg.BOUNDARIES, DesignerMsg.WARNING_RANGE, "warning_level", "warning_level_max", gauge.getWarning_level(), gauge.getWarning_level_max());
        this.addRangeProperty(DesignerMsg.BOUNDARIES, DesignerMsg.CRITICAL_RANGE, "alarm_level", "alarm_level_max", gauge.getAlarm_level(), gauge.getAlarm_level_max());
        this.addColorProperty(DesignerMsg.BOUNDARIES, DesignerMsg.PROPERTY_CRITICAL_COLOR, "criticalcolor", gauge.criticalcolor);
        this.addColorProperty(DesignerMsg.BOUNDARIES, DesignerMsg.PROPERTY_WARNING_COLOR, "warningcolor", gauge.warningcolor);
        this.addColorProperty(DesignerMsg.BOUNDARIES, DesignerMsg.PROPERTY_NORMAL_COLOR, "normalcolor", gauge.normalcolor);
    }

    @Override
    protected void addDefaultProperties() {
        super.addDefaultProperties();
        XFormGauge gauge = (XFormGauge)this.getReferencedObject();
        this.addColorProperty(DesignerMsg.PROPERTY_CONTENT_COLOR, "contentcolor", gauge.contentcolor);
        TextProperty property = Factory.createText((Msg)DesignerMsg.PROPERTY_UNIT, (String)gauge.unit, (boolean)false);
        this.addProperty((Property)property, "unit");
    }

    @Override
    protected Vector getClickMethods() {
        return this.getComponentInteractionProvider().getInvokeableMethods(this);
    }

    @Override
    protected Vector getCtrlClickMethods() {
        return this.getComponentInteractionProvider().getInvokeableMethods(this);
    }

    @Override
    protected Vector getMethods() {
        ObjectTypeDescription otd = this.getComponentInteractionProvider().getObjectTypeDescription();
        List<MethodTypeDescription> methods = otd.getMethods();
        Vector<String> values = new Vector<String>();
        for (MethodTypeDescription method : methods) {
            if (method.getArgumentCount() != 0 || !this.isGraphType(method.getResultType())) continue;
            values.add(method.getSignature());
        }
        return values;
    }

    @Override
    protected Vector getSortedValues() {
        if (values == null) {
            Vector<GraphicType> result;
            values = result = new Vector<GraphicType>(GraphicType.getSubtypes("GAUGE"));
        }
        return values;
    }

    @Override
    protected void initProperties() {
        this.properties_d = new ArrayList();
        this.addDefaultProperties();
        this.addBoundaryProperties();
        super.addSizeProperties();
        super.addTitleProperties();
    }

    private void addRangeProperty(Msg where, Msg propertyId, String minId, String maxId, double min, double max) {
        PropertyGroup rangeProperty = new PropertyGroup(propertyId);
        NumericProperty minProperty = Factory.createDoubleNumber((Msg)DesignerMsg.PROPERTY_MIN_LIMIT, (double)min, (double)Double.NEGATIVE_INFINITY, (double)Double.POSITIVE_INFINITY, (double)0.5);
        NumericProperty maxProperty = Factory.createDoubleNumber((Msg)DesignerMsg.PROPERTY_MAX_LIMIT, (double)max, (double)Double.NEGATIVE_INFINITY, (double)Double.POSITIVE_INFINITY, (double)0.5);
        this.setValue((Property)rangeProperty, (Property)minProperty, (Property)maxProperty);
        PropertyChangeListener minChangeListener = this.createModifyValueListener((Property)minProperty, minId);
        PropertyChangeListener minListener = new PropertyChangeListener((Property)minProperty, (Property)maxProperty, minChangeListener, rangeProperty){
            final /* synthetic */ Property val$minProperty;
            final /* synthetic */ Property val$maxProperty;
            final /* synthetic */ PropertyChangeListener val$minChangeListener;
            final /* synthetic */ PropertyGroup val$rangeProperty;
            {
                this.val$minProperty = property;
                this.val$maxProperty = property2;
                this.val$minChangeListener = propertyChangeListener;
                this.val$rangeProperty = propertyGroup;
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Double minValue = (Double)this.val$minProperty.getValue();
                if (minValue.compareTo((Double)this.val$maxProperty.getValue()) >= 0) {
                    this.val$maxProperty.setValue((Object)(minValue + 1.0));
                    this.val$maxProperty.valueChanged();
                }
                this.val$minChangeListener.propertyChange(evt);
                GaugeComponentProperties.this.setValue((Property)this.val$rangeProperty, this.val$minProperty, this.val$maxProperty);
            }
        };
        minProperty.addPropertyChangeListener(minListener);
        PropertyChangeListener maxChangeListener = this.createModifyValueListener((Property)maxProperty, maxId);
        PropertyChangeListener maxListener = new PropertyChangeListener((Property)maxProperty, (Property)minProperty, maxChangeListener, rangeProperty){
            final /* synthetic */ Property val$maxProperty;
            final /* synthetic */ Property val$minProperty;
            final /* synthetic */ PropertyChangeListener val$maxChangeListener;
            final /* synthetic */ PropertyGroup val$rangeProperty;
            {
                this.val$maxProperty = property;
                this.val$minProperty = property2;
                this.val$maxChangeListener = propertyChangeListener;
                this.val$rangeProperty = propertyGroup;
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Double maxValue = (Double)this.val$maxProperty.getValue();
                if (maxValue.compareTo((Double)this.val$minProperty.getValue()) <= 0) {
                    this.val$minProperty.setValue((Object)(maxValue - 1.0));
                    this.val$minProperty.valueChanged();
                }
                this.val$maxChangeListener.propertyChange(evt);
                GaugeComponentProperties.this.setValue((Property)this.val$rangeProperty, this.val$minProperty, this.val$maxProperty);
            }
        };
        maxProperty.addPropertyChangeListener(maxListener);
        rangeProperty.add((Property)minProperty);
        rangeProperty.add((Property)maxProperty);
        this.addPropertyTo(where, (Property)rangeProperty);
    }

    private PropertyChangeListener createModifyValueListener(Property property, String propertyName) {
        return this.createListener(property, propertyName, null, false);
    }

    private boolean isGraphType(TypeDescription resultType) {
        return resultType.isNumber();
    }

    private void setValue(Property rangeProperty, Property minProperty, Property maxProperty) {
        rangeProperty.setValue((Object)("( " + minProperty.getValue() + " ; " + maxProperty.getValue() + " )"));
    }
}

