/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.properties;

import java.util.ArrayList;
import java.util.Vector;
import oracle.bpm.designer.formdesigner.ChangeListener;
import oracle.bpm.designer.formdesigner.properties.ComponentInteractionProvider;
import oracle.bpm.designer.formdesigner.properties.SimpleComponentProperties;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.prop.Factory;
import oracle.bpm.ui.prop.Property;
import oracle.bpm.ui.prop.impl.ComboProperty;
import oracle.bpm.ui.prop.impl.NumericProperty;
import oracle.bpm.xobject.presentationmodel.XFormCell;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;

public class CellComponentProperties
extends SimpleComponentProperties {
    private XFormCell referencedCell_d;
    private static SimpleComponentProperties.PreParser verticalAlignmentPreparser;

    public CellComponentProperties(XFormPresentationXMLObject referencedObject, ComponentInteractionProvider componentInteractionProvider, ChangeListener listener) {
        super(referencedObject, componentInteractionProvider, listener);
        this.referencedCell_d = (XFormCell)referencedObject;
    }

    protected void addVerticalAlignmentProperty(String currentAlignment) {
        Vector<Msg> validAlignments = new Vector<Msg>();
        Msg currentAlignmentMsg = DesignerMsg.CENTER;
        if (currentAlignment != null) {
            if (currentAlignment.equals("top")) {
                currentAlignmentMsg = DesignerMsg.TOP;
            } else if (currentAlignment.equals("bottom")) {
                currentAlignmentMsg = DesignerMsg.BOTTOM;
            }
        }
        validAlignments.add(DesignerMsg.TOP);
        validAlignments.add(DesignerMsg.CENTER);
        validAlignments.add(DesignerMsg.BOTTOM);
        ComboProperty alignment = Factory.createCombo((Msg)DesignerMsg.PROPERTY_VALIGNMENT, validAlignments, (Object)currentAlignmentMsg);
        this.addProperty((Property)alignment, "valignment", CellComponentProperties.getVerticalAlignParser());
    }

    @Override
    protected void initProperties() {
        this.properties_d = new ArrayList();
        this.addIdPropertyRO(this.referencedCell_d.getId());
        this.addBackgroundColorProperty(this.referencedCell_d.getBgcolor());
        this.addAlignmentProperty(this.referencedCell_d.getAlignment());
        this.addVerticalAlignmentProperty(this.referencedCell_d.getValignment());
        NumericProperty hexpand = Factory.createIntegerNumber((Msg)DesignerMsg.PROPERTY_HEXPAND, (int)this.referencedCell_d.getHexpand(), (int)1, (int)72, (int)1);
        this.addProperty((Property)hexpand, "hexpand");
        NumericProperty vexpand = Factory.createIntegerNumber((Msg)DesignerMsg.PROPERTY_VEXPAND, (int)this.referencedCell_d.getVexpand(), (int)1, (int)72, (int)1);
        this.addProperty((Property)vexpand, "vexpand");
        this.addFullBorderProperty(this.referencedCell_d);
    }

    private static SimpleComponentProperties.PreParser getVerticalAlignParser() {
        if (verticalAlignmentPreparser == null) {
            verticalAlignmentPreparser = new SimpleComponentProperties.PreParser(){

                @Override
                public Object preParse(Object alignMsg) {
                    String value = null;
                    if (alignMsg != null && alignMsg != Property.NULL_VALUE) {
                        value = alignMsg.equals(DesignerMsg.CENTER) ? "center" : (alignMsg.equals(DesignerMsg.TOP) ? "top" : "bottom");
                    }
                    return value;
                }
            };
        }
        return verticalAlignmentPreparser;
    }
}

