/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.properties;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Vector;
import oracle.bpm.designer.formdesigner.ChangeListener;
import oracle.bpm.designer.formdesigner.command.ModifyPropertyValueCommand;
import oracle.bpm.designer.formdesigner.properties.ComponentInteractionProvider;
import oracle.bpm.designer.formdesigner.properties.ReferenceableComponentProperties;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.prop.Factory;
import oracle.bpm.ui.prop.Property;
import oracle.bpm.ui.prop.impl.ComboProperty;
import oracle.bpm.ui.prop.impl.LazyComboProperty;
import oracle.bpm.xobject.presentationmodel.XFormButton;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;

public class ButtonComponentProperties
extends ReferenceableComponentProperties {
    private XFormButton referencedButton_d;

    public ButtonComponentProperties(XFormPresentationXMLObject referencedObject, ComponentInteractionProvider componentInteractionProvider, ChangeListener listener) {
        super(referencedObject, componentInteractionProvider, listener);
        this.referencedButton_d = (XFormButton)referencedObject;
    }

    protected void actionChanged(String newValue) {
        this.actionChanged(newValue, true);
    }

    protected void actionChanged(final String newValue, final boolean invokeCommands) {
        UiUtilities.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                ButtonComponentProperties.this.changeAction(newValue, invokeCommands);
            }
        });
    }

    @Override
    protected void initProperties() {
        this.properties_d = new ArrayList();
        this.addIdProperty(this.referencedButton_d.id);
        this.addTabIndexProperty(this.referencedButton_d.getTabindex());
        this.addDisplayProperty(this.referencedButton_d.display);
        LazyComboProperty comboMethodsProperty = this.createLazyMethodCombo(DesignerMsg.PROPERTY_METHODINVOCATION, this.referencedButton_d.methodinvocation);
        Property actionProperty = this.createActionProperty(this.referencedButton_d.action);
        actionProperty.addPropertyChangeListener(new PropertyChangeListener((Property)comboMethodsProperty){
            final /* synthetic */ Property val$comboMethodsProperty;
            {
                this.val$comboMethodsProperty = property;
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object oldValue = evt.getOldValue();
                Object newValue = evt.getNewValue();
                if (oldValue != null && !oldValue.equals(newValue) || oldValue == null && newValue != null) {
                    String newAction;
                    String string = newAction = newValue != null ? (String)newValue : null;
                    if (newAction != null) {
                        this.val$comboMethodsProperty.setEditable("action".equals(newAction));
                        if (!"action".equals(newAction)) {
                            this.val$comboMethodsProperty.setValue((Object)"");
                        }
                    }
                    ButtonComponentProperties.this.actionChanged(newAction);
                }
            }
        });
        this.properties_d.add(actionProperty);
        comboMethodsProperty.setEditable("action".equals(this.referencedButton_d.action));
        this.addProperty((Property)comboMethodsProperty, "methodinvocation");
        this.addConfirmMsgProperty(this.referencedButton_d.getConfirmationmessage());
        this.addTransparentProperty(this.referencedButton_d.transparent);
        this.actionChanged(this.referencedButton_d.action, false);
        this.addFontProperty(this.referencedButton_d.fonttype, this.referencedButton_d.getFontStyle(), this.referencedButton_d.fontsize);
        this.addBackgroundColorProperty(this.referencedButton_d.bgcolor);
        this.addForegroundColorProperty(this.referencedButton_d.fgcolor);
        this.addSimpleBorderProperty(this.referencedButton_d.getBorderstyle(), this.referencedButton_d.borderwidth, this.referencedButton_d.bordercolor);
    }

    private void addConfirmMsgProperty(String currentMsg) {
        this.addMessageProperty(DesignerMsg.PROPERTY_CONFIRMATION_MESSAGE, currentMsg, "confirmationmessage");
    }

    private void addDisplayProperty(String currentDisplay) {
        Property display = this.createDisplayProperty(DesignerMsg.PROPERTY_DISPLAY, currentDisplay);
        this.addProperty(display, "display");
    }

    private void changeAction(String newValue, boolean invokeCommands) {
        ModifyPropertyValueCommand actionCommand = new ModifyPropertyValueCommand(this.getReferencedObject(), newValue, "action", null);
        ModifyPropertyValueCommand comboCommand = new ModifyPropertyValueCommand(this.getReferencedObject(), "", "methodinvocation", this.listener_d);
        if (newValue != null && invokeCommands) {
            this.invokeCommand(actionCommand);
            this.invokeCommand(comboCommand);
        }
    }

    private Property createActionProperty(String currentAction) {
        Vector<String> posibleVector = new Vector<String>();
        int count = XFormButton.possibleAction_d.length;
        for (int i = 0; i < count; ++i) {
            posibleVector.add(XFormButton.possibleAction_d[i]);
        }
        ComboProperty action = Factory.createCombo((Msg)DesignerMsg.PROPERTY_ACTION, posibleVector, (Object)(currentAction == null ? "" : currentAction));
        return action;
    }
}

