/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.properties;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.designer.formdesigner.ChangeListener;
import oracle.bpm.designer.formdesigner.command.Command;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.BorderStyle;
import oracle.bpm.xobject.presentationmodel.BorderProperties;
import oracle.bpm.xobject.presentationmodel.FullBorderProperties;
import oracle.bpm.xobject.presentationmodel.SimpleBorderProperties;
import oracle.bpm.xobject.presentationmodel.SimpleToFullBorderPropertiesAdapter;
import oracle.bpm.xobject.xml.XFormXMLObject;

public class BorderHelper {
    public static final int TOP = 0;
    public static final int BOTTOM = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    public static final int STYLE = 0;
    public static final int COLOR = 1;
    public static final int WIDTH = 2;

    public static PropertyChanger getSetter(int what, int wich, FullBorderProperties fullBorderProperties) {
        PropertyChanger result = null;
        switch (what) {
            case 0: {
                result = BorderHelper.getStyleSetter(wich, fullBorderProperties);
                break;
            }
            case 2: {
                result = BorderHelper.getWidthSetter(wich, fullBorderProperties);
                break;
            }
            case 1: {
                result = BorderHelper.getColorSetter(wich, fullBorderProperties);
            }
        }
        return result;
    }

    public static PropertyChanger createBottomColorSetter(final FullBorderProperties fullBorderProperties) {
        return new PropertyChanger("color", fullBorderProperties){

            @Override
            protected Object getValue() {
                return fullBorderProperties.getBottomColor();
            }

            @Override
            protected void setValue(Object value) {
                fullBorderProperties.setBottomColor((String)value);
            }
        };
    }

    public static PropertyChanger createBottomStyleSetter(final FullBorderProperties fullBorderProperties) {
        return new PropertyChanger("style", fullBorderProperties){

            @Override
            protected Object getValue() {
                return fullBorderProperties.getBottomStyle();
            }

            @Override
            protected void setValue(Object value) {
                fullBorderProperties.setBottomborderstyle((BorderStyle)value);
            }
        };
    }

    public static PropertyChanger createBottomWidthSetter(final FullBorderProperties fullBorderProperties) {
        return new PropertyChanger("width", fullBorderProperties){

            @Override
            protected Object getValue() {
                return fullBorderProperties.getBottomWidth();
            }

            @Override
            protected void setValue(Object value) {
                fullBorderProperties.setBottomWidth((Integer)value);
            }
        };
    }

    public static List createChangeCommands(BorderProperties target, ChangeListener cl, BorderProperties border) {
        if (target instanceof FullBorderProperties) {
            return BorderHelper.createChangeCommands((FullBorderProperties)target, cl, border);
        }
        if (target instanceof SimpleBorderProperties) {
            return BorderHelper.createChangeCommands((SimpleBorderProperties)target, cl, border);
        }
        return new ArrayList();
    }

    public static List createChangeCommands(FullBorderProperties target, ChangeListener cl, BorderProperties border) {
        FullBorderProperties properties;
        PropertyChanger topColorSetter = BorderHelper.createTopColorSetter(target);
        PropertyChanger bottomColorSetter = BorderHelper.createBottomColorSetter(target);
        PropertyChanger leftColorSetter = BorderHelper.createLeftColorSetter(target);
        PropertyChanger rigthColorSetter = BorderHelper.createRightColorSetter(target);
        PropertyChanger topStyleSetter = BorderHelper.createTopStyleSetter(target);
        PropertyChanger bottomStyleSetter = BorderHelper.createBottomStyleSetter(target);
        PropertyChanger leftStyleSetter = BorderHelper.createLeftStyleSetter(target);
        PropertyChanger rightStyleSetter = BorderHelper.createRightStyleSetter(target);
        PropertyChanger topWidthSetter = BorderHelper.createTopWidthSetter(target);
        PropertyChanger bottomWidthSetter = BorderHelper.createBottomWidthSetter(target);
        PropertyChanger leftWidthSetter = BorderHelper.createLeftWidthSetter(target);
        PropertyChanger rightWidthSetter = BorderHelper.createRightWidthSetter(target);
        ArrayList<PropertyChangerCommand> commands = new ArrayList<PropertyChangerCommand>();
        if (border instanceof FullBorderProperties) {
            properties = (FullBorderProperties)border;
        } else if (border instanceof SimpleBorderProperties) {
            properties = new SimpleToFullBorderPropertiesAdapter((SimpleBorderProperties)border);
        } else {
            return commands;
        }
        commands.add(new PropertyChangerCommand(topColorSetter, cl, properties.getTopColor()));
        commands.add(new PropertyChangerCommand(bottomColorSetter, cl, properties.getBottomColor()));
        commands.add(new PropertyChangerCommand(leftColorSetter, cl, properties.getLeftColor()));
        commands.add(new PropertyChangerCommand(rigthColorSetter, cl, properties.getRightColor()));
        commands.add(new PropertyChangerCommand(topStyleSetter, cl, properties.getTopStyle()));
        commands.add(new PropertyChangerCommand(bottomStyleSetter, cl, properties.getBottomStyle()));
        commands.add(new PropertyChangerCommand(leftStyleSetter, cl, properties.getLeftStyle()));
        commands.add(new PropertyChangerCommand(rightStyleSetter, cl, properties.getRightStyle()));
        commands.add(new PropertyChangerCommand(topWidthSetter, cl, properties.getTopWidth()));
        commands.add(new PropertyChangerCommand(bottomWidthSetter, cl, properties.getBottomWidth()));
        commands.add(new PropertyChangerCommand(leftWidthSetter, cl, properties.getLeftWidth()));
        commands.add(new PropertyChangerCommand(rightWidthSetter, cl, properties.getRightWidth()));
        return commands;
    }

    public static List createChangeCommands(SimpleBorderProperties target, ChangeListener cl, BorderProperties border) {
        int width;
        BorderStyle style;
        String color;
        ArrayList<PropertyChangerCommand> commands = new ArrayList<PropertyChangerCommand>();
        if (border instanceof FullBorderProperties) {
            FullBorderProperties fullBorderProperties = (FullBorderProperties)border;
            color = fullBorderProperties.getTopColor();
            style = fullBorderProperties.getTopStyle();
            width = fullBorderProperties.getTopWidth();
        } else if (border instanceof SimpleBorderProperties) {
            SimpleBorderProperties simpleBorderProperties = (SimpleBorderProperties)border;
            color = simpleBorderProperties.getBordercolor();
            style = simpleBorderProperties.getBorderstyle();
            width = simpleBorderProperties.getBorderwidth();
        } else {
            return commands;
        }
        commands.add(new PropertyChangerCommand(BorderHelper.createColorChanger(target), cl, color));
        commands.add(new PropertyChangerCommand(BorderHelper.createStyleChanger(target), cl, style));
        commands.add(new PropertyChangerCommand(BorderHelper.createWidthChanger(target), cl, width));
        return commands;
    }

    public static PropertyChanger createColorChanger(final SimpleBorderProperties simpleBorderProperties) {
        return new PropertyChanger("color", simpleBorderProperties){

            @Override
            protected Object getValue() {
                return simpleBorderProperties.getBordercolor();
            }

            @Override
            protected void setValue(Object value) {
                simpleBorderProperties.setBordercolor((String)value);
            }
        };
    }

    public static PropertyChanger createLeftColorSetter(final FullBorderProperties fullBorderProperties) {
        return new PropertyChanger("color", fullBorderProperties){

            @Override
            protected Object getValue() {
                return fullBorderProperties.getLeftColor();
            }

            @Override
            protected void setValue(Object value) {
                fullBorderProperties.setLeftColor((String)value);
            }
        };
    }

    public static PropertyChanger createLeftStyleSetter(final FullBorderProperties fullBorderProperties) {
        return new PropertyChanger("style", fullBorderProperties){

            @Override
            protected Object getValue() {
                return fullBorderProperties.getLeftStyle();
            }

            @Override
            protected void setValue(Object value) {
                fullBorderProperties.setLeftborderstyle((BorderStyle)value);
            }
        };
    }

    public static PropertyChanger createLeftWidthSetter(final FullBorderProperties fullBorderProperties) {
        return new PropertyChanger("width", fullBorderProperties){

            @Override
            protected Object getValue() {
                return fullBorderProperties.getLeftWidth();
            }

            @Override
            protected void setValue(Object value) {
                fullBorderProperties.setLeftWidth((Integer)value);
            }
        };
    }

    public static PropertyChanger createRightColorSetter(final FullBorderProperties fullBorderProperties) {
        return new PropertyChanger("color", fullBorderProperties){

            @Override
            protected Object getValue() {
                return fullBorderProperties.getRightColor();
            }

            @Override
            protected void setValue(Object value) {
                fullBorderProperties.setRightColor((String)value);
            }
        };
    }

    public static PropertyChanger createRightStyleSetter(final FullBorderProperties fullBorderProperties) {
        return new PropertyChanger("style", fullBorderProperties){

            @Override
            protected Object getValue() {
                return fullBorderProperties.getRightStyle();
            }

            @Override
            protected void setValue(Object value) {
                fullBorderProperties.setRightborderstyle((BorderStyle)value);
            }
        };
    }

    public static PropertyChanger createRightWidthSetter(final FullBorderProperties fullBorderProperties) {
        return new PropertyChanger("width", fullBorderProperties){

            @Override
            protected Object getValue() {
                return fullBorderProperties.getRightWidth();
            }

            @Override
            protected void setValue(Object value) {
                fullBorderProperties.setRightWidth((Integer)value);
            }
        };
    }

    public static PropertyChanger createStyleChanger(final SimpleBorderProperties simpleBorderProperties) {
        return new PropertyChanger("style", simpleBorderProperties){

            @Override
            protected Object getValue() {
                return simpleBorderProperties.getBorderstyle();
            }

            @Override
            protected void setValue(Object value) {
                simpleBorderProperties.setBorderstyle((BorderStyle)value);
            }
        };
    }

    public static PropertyChanger createTopColorSetter(final FullBorderProperties fullBorderProperties) {
        return new PropertyChanger("color", fullBorderProperties){

            @Override
            protected Object getValue() {
                return fullBorderProperties.getTopColor();
            }

            @Override
            protected void setValue(Object value) {
                fullBorderProperties.setTopColor((String)value);
            }
        };
    }

    public static PropertyChanger createTopStyleSetter(final FullBorderProperties fullBorderProperties) {
        return new PropertyChanger("style", fullBorderProperties){

            @Override
            protected Object getValue() {
                return fullBorderProperties.getTopStyle();
            }

            @Override
            protected void setValue(Object value) {
                fullBorderProperties.setTopborderstyle((BorderStyle)value);
            }
        };
    }

    public static PropertyChanger createTopWidthSetter(final FullBorderProperties fullBorderProperties) {
        return new PropertyChanger("width", fullBorderProperties){

            @Override
            protected Object getValue() {
                return fullBorderProperties.getTopWidth();
            }

            @Override
            protected void setValue(Object value) {
                fullBorderProperties.setTopWidth((Integer)value);
            }
        };
    }

    public static PropertyChanger createWidthChanger(final SimpleBorderProperties simpleBorderProperties) {
        return new PropertyChanger("width", simpleBorderProperties){

            @Override
            protected Object getValue() {
                int value = simpleBorderProperties.getBorderwidth();
                return value;
            }

            @Override
            protected void setValue(Object value) {
                simpleBorderProperties.setBorderwidth((Integer)value);
            }
        };
    }

    private static PropertyChanger getColorSetter(int wich, FullBorderProperties fullBorderProperties) {
        PropertyChanger result = null;
        switch (wich) {
            case 0: {
                result = BorderHelper.createTopColorSetter(fullBorderProperties);
                break;
            }
            case 1: {
                result = BorderHelper.createBottomColorSetter(fullBorderProperties);
                break;
            }
            case 2: {
                result = BorderHelper.createLeftColorSetter(fullBorderProperties);
                break;
            }
            case 3: {
                result = BorderHelper.createRightColorSetter(fullBorderProperties);
            }
        }
        return result;
    }

    private static PropertyChanger getStyleSetter(int wich, FullBorderProperties fullBorderProperties) {
        PropertyChanger result = null;
        switch (wich) {
            case 0: {
                result = BorderHelper.createTopStyleSetter(fullBorderProperties);
                break;
            }
            case 1: {
                result = BorderHelper.createBottomStyleSetter(fullBorderProperties);
                break;
            }
            case 2: {
                result = BorderHelper.createLeftStyleSetter(fullBorderProperties);
                break;
            }
            case 3: {
                result = BorderHelper.createRightStyleSetter(fullBorderProperties);
            }
        }
        return result;
    }

    private static PropertyChanger getWidthSetter(int wich, FullBorderProperties fullBorderProperties) {
        PropertyChanger result = null;
        switch (wich) {
            case 0: {
                result = BorderHelper.createTopWidthSetter(fullBorderProperties);
                break;
            }
            case 1: {
                result = BorderHelper.createBottomWidthSetter(fullBorderProperties);
                break;
            }
            case 2: {
                result = BorderHelper.createLeftWidthSetter(fullBorderProperties);
                break;
            }
            case 3: {
                result = BorderHelper.createRightWidthSetter(fullBorderProperties);
            }
        }
        return result;
    }

    protected static abstract class PropertyChanger {
        private String propertyName;
        private XFormXMLObject where;

        public PropertyChanger(String propertyName, BorderProperties where) {
            this.propertyName = propertyName;
            this.where = (XFormXMLObject)((Object)where);
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public XFormXMLObject getWhere() {
            return this.where;
        }

        protected abstract void setValue(Object var1);

        protected abstract Object getValue();
    }

    public static class PropertyChangerCommand
    extends Command {
        private ChangeListener listener;
        private Object newValue;
        private Object oldValue;
        private PropertyChanger propertyChanger;

        public PropertyChangerCommand(PropertyChanger propertyChanger, ChangeListener listener) {
            this.propertyChanger = propertyChanger;
            this.listener = listener;
        }

        public PropertyChangerCommand(PropertyChanger propertyChanger, ChangeListener listener, Object newValue) {
            this(propertyChanger, listener);
            this.setNewValue(newValue);
        }

        @Override
        public Msg getMsg() {
            return DesignerMsg.MODIFIED_VALUE_COMMAND(this.propertyChanger.getPropertyName(), this.oldValue + "", this.newValue + "");
        }

        public void setNewValue(Object newValue) {
            this.newValue = newValue;
        }

        @Override
        public boolean doIt() {
            this.oldValue = this.propertyChanger.getValue();
            this.propertyChanger.setValue(this.newValue);
            this.notifyListener(this.newValue);
            return true;
        }

        @Override
        public boolean undoIt() {
            this.propertyChanger.setValue(this.oldValue);
            this.notifyListener(this.oldValue);
            return true;
        }

        private void notifyListener(Object value) {
            if (this.listener != null) {
                ChangeListener.ChangeEvent change = ChangeListener.EventFactory.createChange(this.propertyChanger.getPropertyName(), value, this.propertyChanger.getWhere());
                this.listener.changeOccured(change);
            }
        }
    }
}

