/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.preferences;

import java.util.Hashtable;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.Font;
import oracle.bpm.geom.Dimension;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.ColorChooser;
import oracle.bpm.ui.FontProvider;
import oracle.bpm.ui.FontStyle;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.border.BorderFactory;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.utils.FontUtils;

public class Utils {
    public static final String NONE = " ";
    private static String[] possibleFaces;
    private static String[] possibleCellAlignments;
    private static final String[] possibleCellOverrideAlignments;
    private static String[] possibleControlAlignments;
    private static String[] possibleVAlignments;
    private static final String[] possibleTypes;
    private static Hashtable<String, Font> fontHash;

    public static String[] getPossibleCellAlignments() {
        return possibleCellAlignments;
    }

    public static String[] getPossibleCellOverrideAlignments() {
        return possibleCellOverrideAlignments;
    }

    public static String[] getPossibleControlAlignments() {
        return possibleControlAlignments;
    }

    public static String[] getPossibleFaces() {
        if (possibleFaces == null) {
            String[] tempArray = FontUtils.getAvailableFontFamilyNames();
            possibleFaces = new String[tempArray.length + 1];
            Utils.possibleFaces[0] = NONE;
            System.arraycopy(tempArray, 0, possibleFaces, 1, tempArray.length);
        }
        return possibleFaces;
    }

    public static String[] getPossibleTypes() {
        return possibleTypes;
    }

    public static String[] getPossibleVAlignments() {
        return possibleVAlignments;
    }

    public static void init() {
        Utils.loadFonts();
    }

    public static FontProvider<String> getFontTypeProvider() {
        return new FontProvider<String>(){

            public Font getFont(String element) {
                return fontHash != null && element != null ? (Font)fontHash.get(element) : null;
            }
        };
    }

    public static Button createColorButton(final UiContainer parent) {
        final Button bgColorButton = new Button(parent);
        bgColorButton.setExactSize(Dimension.valueOf(20, 20));
        bgColorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Color resultColor = ColorChooser.showDialog((UiComponent)parent, (Color)bgColorButton.getForeground());
                Utils.setColor(resultColor, bgColorButton);
            }
        });
        return bgColorButton;
    }

    public static void setButtonColor(Button button, String colorText) {
        Color color = Utils.getColor(colorText);
        button.setText(colorText == null ? "" : colorText);
        button.setBackground(color);
        button.setForeground(color);
    }

    public static void setLabelColor(Label label, String colorText) {
        Color color = Utils.getColor(colorText);
        label.setText(colorText == null ? "" : colorText);
        label.setBackground(color);
        label.setForeground(label.getBackground());
        if (colorText != null && !colorText.equals("")) {
            label.setToolTipText(colorText);
        }
    }

    public static void linkColorLabelAndButton(final Label label, final Button button) {
        button.setExactSize(Dimension.valueOf(20, 20));
        button.setText("...");
        label.setBorder(BorderFactory.createLineBorder((Color)Color.BLACK, (int)1));
        label.setSize(16, 16);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Color resultColor = ColorChooser.showDialog((UiComponent)button.getParent(), (Color)label.getForeground());
                label.setBackground(resultColor);
                label.setForeground(resultColor);
                String s = Utils.getString(resultColor);
                label.setText(s);
                label.setToolTipText(s);
            }
        });
    }

    public static String getColor(Button bgColorButton) {
        String text = bgColorButton.getText();
        return "".equals(text) ? null : text;
    }

    public static String getString(Msg msg) {
        return msg != null ? msg.getString() : "";
    }

    private static void loadFonts() {
        Thread d = new Thread(new Runnable(){

            @Override
            public void run() {
                String[] possibleFaces;
                for (String possibleFace : possibleFaces = Utils.getPossibleFaces()) {
                    Font f = Font.decode((String)possibleFace);
                    if (f == null) continue;
                    fontHash.put(possibleFace, f);
                }
            }
        });
        d.start();
    }

    private static void setColor(Color color, Button button) {
        if (button != null) {
            button.setForeground(color);
            button.setBackground(color);
            button.setText(Utils.getString(color));
        }
    }

    private static String getString(Color currentColor) {
        return currentColor == null ? null : "#" + Utils.getColorString(currentColor.getRed()) + Utils.getColorString(currentColor.getGreen()) + Utils.getColorString(currentColor.getBlue());
    }

    private static String getColorString(int colorValue) {
        String colorString = Integer.toHexString(colorValue);
        while (colorString.length() < 2) {
            colorString = "0" + colorString;
        }
        return colorString;
    }

    private static Color getColor(String currentColor) {
        Color result = null;
        if (currentColor != null && !currentColor.trim().equals("") && currentColor.charAt(0) == '#' && currentColor.length() == 7) {
            result = Color.decode((String)currentColor);
        }
        return result;
    }

    static {
        possibleCellAlignments = new String[]{"center", "left", "right"};
        possibleCellOverrideAlignments = new String[]{"<" + DesignerMsg.USE_CELL_ALIGNMENT + ">", "center", "left", "right"};
        possibleControlAlignments = new String[]{"center", "left", "right"};
        possibleVAlignments = new String[]{"center", "top", "bottom"};
        possibleTypes = new String[]{NONE, FontStyle.BOLD.toString(), FontStyle.ITALIC.toString(), FontStyle.BOLD_ITALIC.toString(), FontStyle.NORMAL.toString()};
        fontHash = new Hashtable();
    }
}

