/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.preferences;

import oracle.bpm.designer.formdesigner.preferences.AbstractPreferencesManager;
import oracle.bpm.designer.formdesigner.preferences.AlignLabelProvider;
import oracle.bpm.designer.formdesigner.preferences.ComboHelper;
import oracle.bpm.designer.formdesigner.preferences.FontBoldEtcRenderer;
import oracle.bpm.designer.formdesigner.preferences.Utils;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.FontProvider;
import oracle.bpm.ui.FontStyle;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.text.NumericField;
import oracle.bpm.webformdesigner.msg.WebformdesignerMsg;
import oracle.bpm.xobject.presentationmodel.PresentationGenerationOptions;

public class TextPreferencesManager
extends AbstractPreferencesManager {
    private ComboBox<String> alignmentCombo;
    private Label bgLabel;
    private ComboHelper.NullDefaultJComboBox cellAlignmentCombo;
    private NumericField<Integer> columnsField;
    private Label fgLabel;
    private ComboBox<FontStyle> fontFaceCombo;
    private NumericField<Integer> fontSizeField;
    private ComboHelper.NullDefaultJComboBox numberAlignmentCombo;
    private static final String columns = "2dlu, max(50dlu;pref), 4dlu, max(50dlu;pref), 1dlu";

    public TextPreferencesManager() {
        super(WebformdesignerMsg.TEXT);
    }

    @Override
    public void storePreferences(PresentationGenerationOptions options) {
        FontStyle style = (FontStyle)this.fontFaceCombo.getSelectedItem();
        if (style != null && this.fontFaceCombo.getSelectedIndex() != 0) {
            options.setTextDefaultFontStyle(style);
        }
        options.setTextDefaultAlignment((String)this.alignmentCombo.getSelectedItem());
        options.setNumberDefaultAlignment((String)this.numberAlignmentCombo.getSelectedValue());
        options.setTextCellDefaultAlignment((String)this.cellAlignmentCombo.getSelectedValue());
        options.setTextDefaultFontSize((Integer)this.fontSizeField.getValue());
        options.setTextDefaultColQty((Integer)this.columnsField.getValue());
        options.setTextDefaultBgColor(this.bgLabel.getText());
        options.setTextDefaultFgColor(this.fgLabel.getText());
    }

    @Override
    public void loadPreferences(PresentationGenerationOptions options) {
        ComboHelper.selectItem(this.fontFaceCombo, options.getTextDefaultFontStyle());
        this.alignmentCombo.setSelectedItem((Object)options.getTextDefaultAlignment());
        this.numberAlignmentCombo.setSelectedValue(options.getNumberDefaultAlignment());
        this.cellAlignmentCombo.setSelectedValue(options.getTextCellDefaultAlignment());
        this.fontSizeField.setValue((Number)options.getTextDefaultFontSize());
        this.columnsField.setValue((Number)options.getTextDefaultColQty());
        Utils.setLabelColor(this.bgLabel, options.getTextDefaultBgColor());
        Utils.setLabelColor(this.fgLabel, options.getTextDefaultFgColor());
    }

    @Override
    protected UiComponent createPreferencesPanel(UiContainer parent) {
        return this.createTextPreferencesPanel(parent);
    }

    private Panel createTextPreferencesPanel(UiContainer parent) {
        FormLayout layout = new FormLayout("2dlu, pref, 1dlu, fill:pref:grow, min", "min, pref, 2dlu, pref, 0dlu");
        Panel panel = new Panel(parent);
        panel.setLayout((Layout)layout);
        CellConstraints cc = layout.createCellConstraints();
        panel.add((UiComponent)this.createTextFontPanel((UiContainer)panel), (Object)cc.xy(2, 2));
        panel.add((UiComponent)this.createTextColorPanel((UiContainer)panel, "2dlu, max(30dlu;pref), 4dlu, 15dlu, 1dlu, 15dlu, 2dlu"), (Object)cc.xy(4, 2));
        panel.add((UiComponent)this.createTextAlignmentPanel((UiContainer)panel), (Object)cc.xywh(2, 4, 3, 1));
        return panel;
    }

    private Panel createTextAlignmentPanel(UiContainer parent) {
        FormLayout layout = new FormLayout(columns, "2dlu, pref, 4dlu, pref, 4dlu, pref, 2dlu");
        layout.setRowGroups((int[][])new int[][]{{2, 4, 6}});
        Panel alignment = new Panel(parent, DesignerMsg.LAYOUT);
        alignment.setLayout((Layout)layout);
        this.alignmentCombo = UiFactory.createComboBox((UiContainer)alignment, (Object[])Utils.getPossibleControlAlignments());
        this.alignmentCombo.setLabelProvider((LabelProvider)new AlignLabelProvider());
        this.numberAlignmentCombo = ComboHelper.createCombo(alignment, Utils.getPossibleControlAlignments());
        this.numberAlignmentCombo.setLabelProvider((LabelProvider)new AlignLabelProvider());
        this.cellAlignmentCombo = ComboHelper.createCombo(alignment, Utils.getPossibleCellOverrideAlignments());
        this.cellAlignmentCombo.setLabelProvider((LabelProvider)new AlignLabelProvider());
        CellConstraints cc = layout.createCellConstraints();
        alignment.add((UiComponent)Label.create((UiContainer)alignment, (Msg)DesignerMsg.ALIGNMENT), (Object)cc.xy(2, 2));
        alignment.add(this.alignmentCombo, (Object)cc.xy(4, 2));
        alignment.add((UiComponent)Label.create((UiContainer)alignment, (Msg)DesignerMsg.NUM_ALIGNMENT), (Object)cc.xy(2, 4));
        alignment.add((UiComponent)this.numberAlignmentCombo, (Object)cc.xy(4, 4));
        alignment.add((UiComponent)Label.create((UiContainer)alignment, (Msg)DesignerMsg.CELL_ALIGNMENT), (Object)cc.xy(2, 6));
        alignment.add((UiComponent)this.cellAlignmentCombo, (Object)cc.xy(4, 6));
        return alignment;
    }

    private Panel createTextColorPanel(UiContainer parent, String columns) {
        FormLayout colorLayout = new FormLayout(columns, "min, pref, 4dlu, pref, 2dlu, pref, 2dlu");
        colorLayout.setRowGroups((int[][])new int[][]{{2, 4}});
        Panel colorPanel = new Panel(parent, DesignerMsg.COLOR);
        colorPanel.setLayout((Layout)colorLayout);
        Button bgButton = new Button((UiContainer)colorPanel);
        this.bgLabel = Label.create((UiContainer)colorPanel);
        Utils.linkColorLabelAndButton(this.bgLabel, bgButton);
        Button fgButton = new Button((UiContainer)colorPanel);
        this.fgLabel = Label.create((UiContainer)colorPanel);
        Utils.linkColorLabelAndButton(this.fgLabel, fgButton);
        CellConstraints cc = colorLayout.createCellConstraints();
        colorPanel.add((UiComponent)Label.create((UiContainer)colorPanel, (Msg)DesignerMsg.BACK_COLOR), (Object)cc.xy(2, 2));
        colorPanel.add((UiComponent)this.bgLabel, (Object)cc.xy(4, 2));
        colorPanel.add((UiComponent)bgButton, (Object)cc.xy(6, 2));
        colorPanel.add((UiComponent)Label.create((UiContainer)colorPanel, (Msg)DesignerMsg.FG_COLOR), (Object)cc.xy(2, 4));
        colorPanel.add((UiComponent)this.fgLabel, (Object)cc.xy(4, 4));
        colorPanel.add((UiComponent)fgButton, (Object)cc.xy(6, 4));
        return colorPanel;
    }

    private Panel createTextFontPanel(UiContainer parent) {
        FormLayout fontLayout = new FormLayout(columns, "min, pref, 4dlu, pref, 4dlu, pref, 5dlu");
        fontLayout.setRowGroups((int[][])new int[][]{{2, 4, 6}});
        Panel fontPanel = new Panel(parent);
        fontPanel.setLayout((Layout)fontLayout);
        this.fontFaceCombo = UiFactory.createComboBox((UiContainer)fontPanel, (Object[])FontStyle.values());
        FontBoldEtcRenderer provider = new FontBoldEtcRenderer(parent);
        this.fontFaceCombo.setLabelProvider((LabelProvider)provider);
        this.fontFaceCombo.setFontProvider((FontProvider)provider);
        this.fontSizeField = NumericField.createIntegerNumericField((UiContainer)fontPanel);
        this.fontSizeField.setScale(0);
        this.columnsField = NumericField.createIntegerNumericField((UiContainer)fontPanel);
        this.columnsField.setScale(0);
        CellConstraints cc = fontLayout.createCellConstraints();
        fontPanel.add((UiComponent)Label.create((UiContainer)fontPanel, (Msg)DesignerMsg.FONT_BOLD_ITALIC), (Object)cc.xy(2, 2));
        fontPanel.add(this.fontFaceCombo, (Object)cc.xy(4, 2));
        fontPanel.add((UiComponent)Label.create((UiContainer)fontPanel, (Msg)DesignerMsg.FONT_SIZE), (Object)cc.xy(2, 4));
        fontPanel.add(this.fontSizeField, (Object)cc.xy(4, 4));
        fontPanel.add((UiComponent)Label.create((UiContainer)fontPanel, (Msg)DesignerMsg.COLQTY), (Object)cc.xy(2, 6));
        fontPanel.add(this.columnsField, (Object)cc.xy(4, 6));
        return fontPanel;
    }
}

