/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.preferences;

import oracle.bpm.designer.formdesigner.preferences.AbstractPreferencesManager;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.AttributeType;
import oracle.bpm.ui.layout.GridBagLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.RelativeLayout;
import oracle.bpm.ui.text.NumericField;
import oracle.bpm.webformdesigner.msg.WebformdesignerMsg;
import oracle.bpm.xobject.presentationmodel.PresentationGenerationOptions;

public class TablePreferencesManager
extends AbstractPreferencesManager {
    private NumericField<Integer> defaultPaddingTextField;
    private NumericField<Integer> defaultSpacingTextField;

    public TablePreferencesManager() {
        super(WebformdesignerMsg.TABLE);
    }

    @Override
    public void storePreferences(PresentationGenerationOptions options) {
        options.setDefaultTablePadding((Integer)this.defaultPaddingTextField.getValue());
        options.setDefaultTableSpacing((Integer)this.defaultSpacingTextField.getValue());
    }

    @Override
    public void loadPreferences(PresentationGenerationOptions options) {
        this.defaultPaddingTextField.setValue((Number)options.getDefaultTablePadding());
        this.defaultSpacingTextField.setValue((Number)options.getDefaultTableSpacing());
    }

    @Override
    protected UiComponent createPreferencesPanel(UiContainer parent) {
        Panel panel = new Panel(parent);
        panel.setLayout((Layout)new GridBagLayout());
        Label cellPaddingLabel = Label.create((UiContainer)panel, (Msg)DesignerMsg.CELL_PADDING);
        this.defaultPaddingTextField = NumericField.createIntegerNumericField((UiContainer)panel);
        this.defaultPaddingTextField.setColumns(15);
        this.defaultPaddingTextField.setScale(0);
        Label cellSpacingLabel = Label.create((UiContainer)panel, (Msg)DesignerMsg.CELL_SPACING);
        this.defaultSpacingTextField = NumericField.createIntegerNumericField((UiContainer)panel);
        this.defaultSpacingTextField.setColumns(15);
        this.defaultSpacingTextField.setScale(0);
        RelativeLayout l = new RelativeLayout();
        panel.setLayout((Layout)l);
        panel.add((UiComponent)cellPaddingLabel, (Object)"paddingLabel");
        panel.add(this.defaultPaddingTextField, (Object)"padding");
        panel.add((UiComponent)cellSpacingLabel, (Object)"spacingLabel");
        panel.add(this.defaultSpacingTextField, (Object)"spacing");
        oracle.bpm.ui.utils.Layout.fixToRoot((RelativeLayout)l, (String)"padding", (AttributeType)AttributeType.TOP, (int)5);
        oracle.bpm.ui.utils.Layout.fixToRoot((RelativeLayout)l, (String)"paddingLabel", (AttributeType)AttributeType.LEFT, (int)10);
        oracle.bpm.ui.utils.Layout.fixToComp((RelativeLayout)l, (String)"spacingLabel", (AttributeType)AttributeType.LEFT, (String)"paddingLabel");
        oracle.bpm.ui.utils.Layout.fixToComp((RelativeLayout)l, (String)"spacing", (AttributeType)AttributeType.TOP, (String)"padding", (AttributeType)AttributeType.BOTTOM, (int)5);
        oracle.bpm.ui.utils.Layout.fixToComp((RelativeLayout)l, (String)"paddingLabel", (AttributeType)AttributeType.VERTICAL_CENTER, (String)"padding");
        oracle.bpm.ui.utils.Layout.fixToComp((RelativeLayout)l, (String)"spacingLabel", (AttributeType)AttributeType.VERTICAL_CENTER, (String)"spacing");
        oracle.bpm.ui.utils.Layout.fixToComp((RelativeLayout)l, (String)"spacing", (AttributeType)AttributeType.LEFT, (String)"spacingLabel", (AttributeType)AttributeType.RIGHT, (int)5);
        oracle.bpm.ui.utils.Layout.fixToComp((RelativeLayout)l, (String)"padding", (AttributeType)AttributeType.LEFT, (String)"spacing");
        return panel;
    }
}

