/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.preferences;

import java.util.List;
import java.util.Vector;
import oracle.bpm.designer.formdesigner.preferences.PresentationPreferencesBuilder;
import oracle.bpm.draw.Color;
import oracle.bpm.geom.Dimension;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.AbstractLabelProvider;
import oracle.bpm.ui.Box;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.TitlePanel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiManager;
import oracle.bpm.ui.event.TreeSelectionEvent;
import oracle.bpm.ui.event.TreeSelectionListener;
import oracle.bpm.ui.layout.CardLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.pref.Category;
import oracle.bpm.ui.tree.Tree;
import oracle.bpm.xobject.presentationmodel.PresentationGenerationOptions;

public class PresentationPreferencesPanel
extends Panel {
    private PresentationPreferencesBuilder builder;
    private Vector<Msg> components = new Vector();

    public PresentationPreferencesPanel(UiContainer parent) {
        this(parent, PresentationGenerationOptions.load());
    }

    public PresentationPreferencesPanel(UiContainer parent, PresentationGenerationOptions options) {
        super(parent);
        this.builder = new PresentationPreferencesBuilder(options);
        this.initPanel();
    }

    public Category[] getCategories() {
        return this.builder.getCategoryArray();
    }

    public void reset() {
        this.builder.reset();
    }

    public void storeOptions() {
        this.builder.storeOptions();
    }

    public Dimension getMinimumSize() {
        return Dimension.valueOf(620, 350);
    }

    private void addComponent(PresentationPreferencesBuilder.PresentationCategory category, UiContainer parent) {
        this.components.add(category.getMsg());
        Panel categoryPanel = new Panel(parent);
        TitlePanel foTitlePanel = new TitlePanel((UiContainer)categoryPanel);
        foTitlePanel.setTitle(category.getMsg());
        TitlePanel.TopPanel topPanel = foTitlePanel.getTopPanel();
        topPanel.setBackground(Color.FUEGO_LIGHT_BLUE);
        topPanel.setForeground(Color.GRAY);
        topPanel.setFont(UiManager.font((String)"InternalFrame.titleFont"));
        UiComponent uiComponent = category.getEditor((UiContainer)foTitlePanel);
        foTitlePanel.addContent(uiComponent);
        categoryPanel.setLayout((Layout)new BorderLayout());
        categoryPanel.add(Box.createVerticalStrut((UiContainer)categoryPanel, (int)5), (Object)"North");
        categoryPanel.add(Box.createHorizontalStrut((UiContainer)categoryPanel, (int)10), (Object)"East");
        categoryPanel.add((UiComponent)foTitlePanel, (Object)"Center");
        categoryPanel.add(Box.createHorizontalStrut((UiContainer)categoryPanel, (int)10), (Object)"West");
        parent.add((UiComponent)categoryPanel, (Object)category.getMsg().getString());
    }

    private void initPanel() {
        this.setLayout((Layout)new BorderLayout());
        Panel cardPanel = new Panel((UiContainer)this);
        cardPanel.setLayout((Layout)new CardLayout());
        this.add((UiComponent)cardPanel, "Center");
        List<PresentationPreferencesBuilder.PresentationCategory> categories = this.builder.getCategories();
        for (PresentationPreferencesBuilder.PresentationCategory category : categories) {
            this.addComponent(category, (UiContainer)cardPanel);
        }
        this.add((UiComponent)this.createScrollableTree((UiContainer)this, (UiContainer)cardPanel), "West");
    }

    private Tree createScrollableTree(UiContainer parent, final UiContainer cardPanel) {
        Tree tree = new Tree(parent, this.components.toArray());
        tree.setRootVisible(false);
        tree.getRoot().getFirstChild().select();
        tree.setLabelProvider((LabelProvider)new AbstractLabelProvider(){

            public String getText(Object element) {
                return String.valueOf(element);
            }
        });
        final CardLayout cardLayout = (CardLayout)cardPanel.getLayout();
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                String s = e.getNewLeadSelectionPath().getLastPathComponent().toString();
                cardLayout.show(cardPanel, s);
            }
        });
        return tree;
    }
}

