/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.preferences;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.designer.formdesigner.preferences.AbstractPreferencesManager;
import oracle.bpm.designer.formdesigner.preferences.ButtonPreferencesManager;
import oracle.bpm.designer.formdesigner.preferences.CellPreferencesManager;
import oracle.bpm.designer.formdesigner.preferences.ComboPreferencesManager;
import oracle.bpm.designer.formdesigner.preferences.GeneralPreferencesManager;
import oracle.bpm.designer.formdesigner.preferences.LabelPreferencesManager;
import oracle.bpm.designer.formdesigner.preferences.TablePreferencesManager;
import oracle.bpm.designer.formdesigner.preferences.TextPreferencesManager;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.pref.Category;
import oracle.bpm.xobject.presentationmodel.PresentationGenerationOptions;

public class PresentationPreferencesBuilder {
    private List<PresentationCategory> categories = new ArrayList<PresentationCategory>();
    private Category[] categoryArray;
    private List<AbstractPreferencesManager> managers;
    private PresentationGenerationOptions options;

    public PresentationPreferencesBuilder(PresentationGenerationOptions options) {
        this.init(options);
    }

    public List<PresentationCategory> getCategories() {
        if (this.categories.size() == 0) {
            this.createCategories();
        }
        return this.categories;
    }

    public Category[] getCategoryArray() {
        if (this.categoryArray == null) {
            List<PresentationCategory> categories = this.getCategories();
            this.categoryArray = categories.toArray(new Category[categories.size()]);
        }
        return this.categoryArray;
    }

    public void storeOptions() {
        for (AbstractPreferencesManager manager : this.managers) {
            manager.storePreferences(this.options);
        }
        this.options.store();
    }

    public void reset() {
        this.options.reset();
        this.initOptions();
    }

    private void addCategory(AbstractPreferencesManager manager, Category.Listener listener) {
        this.categories.add(new PresentationCategory(manager, listener, this.options));
    }

    private void initOptions() {
        for (AbstractPreferencesManager manager : this.managers) {
            manager.loadPreferences(this.options);
        }
    }

    private void init(PresentationGenerationOptions options) {
        this.options = options;
        this.initManagers();
    }

    private void initManagers() {
        this.managers = new ArrayList<AbstractPreferencesManager>();
        this.managers.add(new GeneralPreferencesManager());
        this.managers.add(new TablePreferencesManager());
        this.managers.add(new CellPreferencesManager());
        this.managers.add(new TextPreferencesManager());
        this.managers.add(new ComboPreferencesManager());
        this.managers.add(new ButtonPreferencesManager());
        this.managers.add(new LabelPreferencesManager());
    }

    private List<PresentationCategory> createCategories() {
        Category.Listener listener = new Category.Listener(){

            public void load() {
            }

            public void save() {
                PresentationPreferencesBuilder.this.storeOptions();
            }
        };
        for (AbstractPreferencesManager manager : this.managers) {
            this.addCategory(manager, listener);
        }
        return this.categories;
    }

    public static class PresentationCategory
    extends Category {
        private AbstractPreferencesManager manager;
        private PresentationGenerationOptions options;

        public PresentationCategory(AbstractPreferencesManager manager, Category.Listener listener, PresentationGenerationOptions options) {
            super(manager.getMsg().getString(), null, listener);
            this.manager = manager;
            this.options = options;
        }

        public Msg getMsg() {
            return this.manager.getMsg();
        }

        public UiComponent getEditor(UiContainer parent) {
            UiComponent scrollableView = this.manager.createScrollableView(parent);
            this.manager.loadPreferences(this.options);
            return scrollableView;
        }
    }
}

