/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.preferences;

import oracle.bpm.designer.formdesigner.preferences.AbstractPreferencesManager;
import oracle.bpm.designer.formdesigner.preferences.AlignLabelProvider;
import oracle.bpm.designer.formdesigner.preferences.ComboHelper;
import oracle.bpm.designer.formdesigner.preferences.Utils;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.webformdesigner.msg.WebformdesignerMsg;
import oracle.bpm.xobject.presentationmodel.PresentationGenerationOptions;

public class LabelPreferencesManager
extends AbstractPreferencesManager {
    private ComboHelper.NullDefaultJComboBox alignmentComboBox;
    private CheckBox shiftFirstCheck;
    private CheckBox shiftSplitedCheck;
    private CheckBox splitCheck;

    public LabelPreferencesManager() {
        super(WebformdesignerMsg.LABEL);
    }

    @Override
    public void storePreferences(PresentationGenerationOptions options) {
        options.setLabelCellDefaultAlignment((String)this.alignmentComboBox.getSelectedValue());
        options.setLabelShiftFirstLetter(this.shiftFirstCheck.isSelected());
        options.setLabelSeparateUnderscoresAndCaps(this.splitCheck.isSelected());
        options.setLabelShiftSeparatedWords(this.shiftSplitedCheck.isSelected());
    }

    @Override
    public void loadPreferences(PresentationGenerationOptions options) {
        this.alignmentComboBox.setSelectedValue(options.getLabelCellDefaultAlignment());
        this.shiftFirstCheck.setSelected(options.doLabelShiftFirstLetter());
        this.splitCheck.setSelected(options.doLabelSeparateUnderscoresAndCaps());
        this.shiftSplitedCheck.setSelected(options.doLabelShiftSeparatedWords());
    }

    @Override
    protected UiComponent createPreferencesPanel(UiContainer parent) {
        Panel panel = new Panel(parent);
        FormLayout layout = new FormLayout("5dlu, pref, 4dlu, 100dlu, 5dlu:grow", "5dlu, pref, 4dlu, pref, min");
        panel.setLayout((Layout)layout);
        this.alignmentComboBox = ComboHelper.createCombo(panel, Utils.getPossibleCellOverrideAlignments());
        this.alignmentComboBox.setLabelProvider((LabelProvider)new AlignLabelProvider());
        CellConstraints cc = layout.createCellConstraints();
        panel.add((UiComponent)Label.create((UiContainer)panel, (Msg)DesignerMsg.CELL_ALIGNMENT), (Object)cc.xy(2, 2));
        panel.add((UiComponent)this.alignmentComboBox, (Object)cc.xy(4, 2));
        panel.add((UiComponent)this.createCapitalizePanel(panel), (Object)cc.xyw(2, 4, 3));
        return panel;
    }

    private Panel createCapitalizePanel(Panel panel) {
        Panel capitalize = new Panel((UiContainer)panel, WebformdesignerMsg.LABEL);
        FormLayout layout = new FormLayout("5dlu, pref, min", "min, pref, 2dlu, pref, 2dlu,pref, 2dlu:grow");
        capitalize.setLayout((Layout)layout);
        this.shiftFirstCheck = CheckBox.create((UiContainer)capitalize, (Msg)DesignerMsg.UPPER_CASE_FIRST);
        this.splitCheck = CheckBox.create((UiContainer)capitalize, (Msg)DesignerMsg.SEPARATE_UNDERSCRE_UPPER);
        this.shiftSplitedCheck = CheckBox.create((UiContainer)capitalize, (Msg)DesignerMsg.UPPER_SEPARATED);
        CellConstraints cc = layout.createCellConstraints();
        capitalize.add((UiComponent)this.shiftFirstCheck, (Object)cc.xy(2, 2));
        capitalize.add((UiComponent)this.splitCheck, (Object)cc.xy(2, 4));
        capitalize.add((UiComponent)this.shiftSplitedCheck, (Object)cc.xy(2, 6));
        return capitalize;
    }
}

