/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.preferences;

import oracle.bpm.designer.formdesigner.preferences.AbstractPreferencesManager;
import oracle.bpm.designer.formdesigner.preferences.Utils;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.AbstractButton;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.ButtonGroup;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.RadioButton;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.xobject.presentationmodel.PresentationGenerationOptions;

public class GeneralPreferencesManager
extends AbstractPreferencesManager {
    private Button bgColorButton;
    private Label bgColorLabel;
    private RadioButton defaultLayout;
    private RadioButton headerLayout;

    public GeneralPreferencesManager() {
        super(DesignerMsg.GENERAL);
    }

    @Override
    public void storePreferences(PresentationGenerationOptions options) {
        options.setPresentationBackGround(this.bgColorLabel.getText());
        options.setUseDefaultLayout(this.defaultLayout.isSelected());
    }

    @Override
    public void loadPreferences(PresentationGenerationOptions options) {
        Utils.setLabelColor(this.bgColorLabel, options.getPresentationBackGround());
        this.defaultLayout.setSelected(options.useDefaultLayout());
        this.headerLayout.setSelected(!options.useDefaultLayout());
    }

    @Override
    protected UiComponent createPreferencesPanel(UiContainer parent) {
        FormLayout layout = new FormLayout("5dlu, pref, 15dlu, 15dlu, 15dlu:grow, 5dlu", "5dlu, pref, 4dlu, pref, min");
        Panel panel = new Panel(parent);
        panel.setLayout((Layout)layout);
        this.bgColorButton = new Button((UiContainer)panel);
        this.bgColorLabel = Label.create((UiContainer)panel);
        Utils.linkColorLabelAndButton(this.bgColorLabel, this.bgColorButton);
        CellConstraints cc = layout.createCellConstraints();
        panel.add((UiComponent)Label.create((UiContainer)panel, (Msg)DesignerMsg.BACK_COLOR), (Object)cc.xy(2, 2));
        panel.add((UiComponent)this.bgColorLabel, (Object)cc.xy(3, 2));
        panel.add((UiComponent)this.bgColorButton, (Object)cc.xy(4, 2));
        Panel layoutPanel = this.createLayoutPanel((UiContainer)panel);
        this.buildLayoutPanel((UiContainer)layoutPanel);
        panel.add((UiComponent)layoutPanel, (Object)cc.xyw(2, 4, 4));
        return panel;
    }

    private Panel createLayoutPanel(UiContainer panel) {
        return new Panel(panel, DesignerMsg.LAYOUT);
    }

    private void buildLayoutPanel(UiContainer layoutPanel) {
        FormLayout layout = new FormLayout("2dlu, pref, 2dlu:grow", "2dlu, pref, 2dlu, pref, 2dlu");
        layoutPanel.setLayout((Layout)layout);
        BaseAction defaultPres = new BaseAction(DesignerMsg.TABLE_PRESENTATION){

            public void run() {
            }
        };
        this.defaultLayout = new RadioButton(layoutPanel, defaultPres);
        this.headerLayout = new RadioButton(layoutPanel, DesignerMsg.HEADER_FOOTER_TABLE_LAYOUT);
        ButtonGroup g = new ButtonGroup();
        g.add((AbstractButton)this.defaultLayout);
        g.add((AbstractButton)this.headerLayout);
        CellConstraints cc = layout.createCellConstraints();
        layoutPanel.add((UiComponent)this.defaultLayout, (Object)cc.xy(2, 2));
        layoutPanel.add((UiComponent)this.headerLayout, (Object)cc.xy(2, 4));
    }
}

