/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.preferences;

import oracle.bpm.designer.formdesigner.preferences.AbstractPreferencesManager;
import oracle.bpm.designer.formdesigner.preferences.AlignLabelProvider;
import oracle.bpm.designer.formdesigner.preferences.Utils;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.webformdesigner.msg.WebformdesignerMsg;
import oracle.bpm.xobject.presentationmodel.PresentationGenerationOptions;

public class ComboPreferencesManager
extends AbstractPreferencesManager {
    private ComboBox alignmentCombo;

    public ComboPreferencesManager() {
        super(WebformdesignerMsg.COMBO);
    }

    @Override
    public void storePreferences(PresentationGenerationOptions options) {
        options.setDefaultComboAlignment((String)this.alignmentCombo.getSelectedItem());
    }

    @Override
    public void loadPreferences(PresentationGenerationOptions options) {
        this.alignmentCombo.setSelectedItem((Object)options.getDefaultComboAlignment());
    }

    @Override
    protected UiComponent createPreferencesPanel(UiContainer parent) {
        FormLayout layout = new FormLayout("5dlu, pref, 4dlu, pref, 5dlu:grow", "5dlu, pref, 5dlu:grow");
        Panel panel = new Panel(parent);
        panel.setLayout((Layout)layout);
        this.alignmentCombo = UiFactory.createComboBox((UiContainer)panel, (Object[])Utils.getPossibleControlAlignments());
        this.alignmentCombo.setLabelProvider((LabelProvider)new AlignLabelProvider());
        CellConstraints cc = layout.createCellConstraints();
        panel.add((UiComponent)Label.create((UiContainer)panel, (Msg)DesignerMsg.ALIGNMENT), (Object)cc.xy(2, 2));
        panel.add((UiComponent)this.alignmentCombo, (Object)cc.xy(4, 2));
        return panel;
    }
}

