/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.preferences;

import oracle.bpm.designer.formdesigner.preferences.AbstractPreferencesManager;
import oracle.bpm.designer.formdesigner.preferences.AlignLabelProvider;
import oracle.bpm.designer.formdesigner.preferences.Utils;
import oracle.bpm.designer.formdesigner.preferences.VAlignLabelProvider;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.webformdesigner.msg.WebformdesignerMsg;
import oracle.bpm.xobject.presentationmodel.PresentationGenerationOptions;

public class CellPreferencesManager
extends AbstractPreferencesManager {
    private ComboBox<String> defaultAlignmentCombo;
    private ComboBox<String> defaultVAlignmentCombo;
    private static final String columns = "5dlu, max(75dlu;pref), 4dlu, max(80dlu;pref), 5dlu";

    public CellPreferencesManager() {
        super(WebformdesignerMsg.CELL);
    }

    @Override
    public void storePreferences(PresentationGenerationOptions options) {
        options.setCellDefaultAlignment((String)this.defaultAlignmentCombo.getSelectedItem());
        options.setCellDefaultVerticalAlignment((String)this.defaultVAlignmentCombo.getSelectedItem());
    }

    @Override
    public void loadPreferences(PresentationGenerationOptions options) {
        this.defaultAlignmentCombo.setSelectedItem((Object)options.getCellDefaultAlignment());
        this.defaultVAlignmentCombo.setSelectedItem((Object)options.getCellDefaultVerticalAlignment());
    }

    @Override
    protected UiComponent createPreferencesPanel(UiContainer parent) {
        Panel panel = new Panel(parent);
        FormLayout layout = new FormLayout("5dlu, pref, min", "min, pref, min");
        panel.setLayout((Layout)layout);
        CellConstraints cc = layout.createCellConstraints();
        panel.add((UiComponent)this.createCellAlignmentPanel((UiContainer)panel), (Object)cc.xy(2, 2));
        return panel;
    }

    private Panel createCellAlignmentPanel(UiContainer parent) {
        Panel container = new Panel(parent, DesignerMsg.ALIGNMENT_TITLE);
        FormLayout layout = new FormLayout(columns, "min, pref, 4dlu, pref, 2dlu");
        layout.setRowGroups((int[][])new int[][]{{2, 4}});
        container.setLayout((Layout)layout);
        this.defaultAlignmentCombo = UiFactory.createComboBox((UiContainer)container, (Object[])Utils.getPossibleCellAlignments());
        this.defaultAlignmentCombo.setLabelProvider((LabelProvider)new AlignLabelProvider());
        this.defaultVAlignmentCombo = UiFactory.createComboBox((UiContainer)container, (Object[])Utils.getPossibleVAlignments());
        this.defaultVAlignmentCombo.setLabelProvider((LabelProvider)new VAlignLabelProvider());
        this.defaultVAlignmentCombo.setPrototypeDisplayValue("XXXXXXXXXXXX");
        CellConstraints cc = layout.createCellConstraints();
        container.add((UiComponent)Label.create((UiContainer)container, (Msg)DesignerMsg.ALIGNMENT), (Object)cc.xy(2, 2));
        container.add(this.defaultAlignmentCombo, (Object)cc.xy(4, 2));
        container.add((UiComponent)Label.create((UiContainer)container, (Msg)DesignerMsg.VALIGNMENT), (Object)cc.xy(2, 4));
        container.add(this.defaultVAlignmentCombo, (Object)cc.xy(4, 4));
        return container;
    }
}

