/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.preferences;

import javax.swing.DefaultListModel;
import javax.swing.ListModel;
import oracle.bpm.designer.formdesigner.preferences.AbstractPreferencesManager;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.geom.Dimension;
import oracle.bpm.geom.Insets;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.List;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.GridBagConstraints;
import oracle.bpm.ui.layout.GridBagLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.webformdesigner.msg.WebformdesignerMsg;
import oracle.bpm.xobject.presentationmodel.PresentationGenerationOptions;

public class ButtonPreferencesManager
extends AbstractPreferencesManager {
    private ButtonInfo cancelButtonInfo;
    private DefaultListModel displayButtonsModel;
    private ButtonInfo refreshButtonInfo;
    private ButtonInfo resetButtonInfo;
    private ButtonInfo submitButtonInfo;
    private CheckBox transparentCheck;

    public ButtonPreferencesManager() {
        super(WebformdesignerMsg.BUTTON);
    }

    @Override
    public void storePreferences(PresentationGenerationOptions options) {
        options.setButtonsTransparent(this.transparentCheck.isSelected());
        options.setOkButtonDefaultDisplay(this.submitButtonInfo.getText());
        options.setCancelButtonDefaultDisplay(this.cancelButtonInfo.getText());
        options.setRefreshButtonDefaultDisplay(this.refreshButtonInfo.getText());
        options.setResetButtonDefaultDisplay(this.resetButtonInfo.getText());
        int size = this.displayButtonsModel.getSize();
        int[] buttons = new int[size];
        for (int i = 0; i < size; ++i) {
            Object o = this.displayButtonsModel.get(i);
            if (o.equals(WebformdesignerMsg.SUBMIT_BUTTON)) {
                buttons[i] = 0;
                continue;
            }
            if (o.equals(WebformdesignerMsg.RESET_BUTTON)) {
                buttons[i] = 2;
                continue;
            }
            if (o.equals(WebformdesignerMsg.REFRESH_BUTTON)) {
                buttons[i] = 3;
                continue;
            }
            if (!o.equals(WebformdesignerMsg.CANCEL_BUTTON)) continue;
            buttons[i] = 1;
        }
        options.setButtonPanelLayout(buttons);
    }

    @Override
    public void loadPreferences(PresentationGenerationOptions options) {
        this.transparentCheck.setSelected(options.areButtonsTransparent());
        this.submitButtonInfo.setText(options.getOkButtonDefaultDisplay());
        this.cancelButtonInfo.setText(options.getCancelButtonDefaultDisplay());
        this.refreshButtonInfo.setText(options.getRefreshButtonDefaultDisplay());
        this.resetButtonInfo.setText(options.getResetButtonDefaultDisplay());
        int[] buttons = options.getButtonPanelLayout();
        for (int i = 0; i < buttons.length; ++i) {
            if (buttons[i] == 0) {
                this.submitButtonInfo.setSelected(true);
                this.displayButtonsModel.add(this.displayButtonsModel.getSize(), this.submitButtonInfo.getMsg());
                continue;
            }
            if (buttons[i] == 1) {
                this.cancelButtonInfo.setSelected(true);
                this.displayButtonsModel.add(this.displayButtonsModel.getSize(), this.cancelButtonInfo.getMsg());
                continue;
            }
            if (buttons[i] == 2) {
                this.resetButtonInfo.setSelected(true);
                this.displayButtonsModel.add(this.displayButtonsModel.getSize(), this.resetButtonInfo.getMsg());
                continue;
            }
            if (buttons[i] != 3) continue;
            this.refreshButtonInfo.setSelected(true);
            this.displayButtonsModel.add(this.displayButtonsModel.getSize(), this.refreshButtonInfo.getMsg());
        }
    }

    @Override
    protected UiComponent createPreferencesPanel(UiContainer parent) {
        return this.createButtonPreferencesPanel(parent);
    }

    private static GridBagConstraints getFldConstraints(int gridy, int gridx) {
        GridBagConstraints constr = new GridBagConstraints();
        constr.gridx = gridx;
        constr.gridy = gridy;
        constr.fill = 1;
        constr.anchor = 17;
        constr.insets = new Insets(8, 10, 8, 10);
        return constr;
    }

    private Panel createButtonPreferencesPanel(UiContainer parent) {
        this.displayButtonsModel = new DefaultListModel();
        Panel panel = new Panel(parent);
        String cols = "8dlu, pref, min";
        String rows = "min, pref, 2dlu, pref, 2dlu, pref, 2dlu";
        FormLayout layout = new FormLayout(cols, rows);
        panel.setLayout((Layout)layout);
        this.transparentCheck = CheckBox.create((UiContainer)panel, (Msg)DesignerMsg.TRANSPARENT_QUESTION);
        CellConstraints cc = layout.createCellConstraints();
        panel.add((UiComponent)this.transparentCheck, (Object)cc.xy(2, 2));
        panel.add((UiComponent)this.createButtonsToIncludePanel((UiContainer)panel), (Object)cc.xy(2, 4));
        panel.add((UiComponent)this.createButtonLayoutPanel((UiContainer)panel), (Object)cc.xy(2, 6));
        return panel;
    }

    private Panel createButtonLayoutPanel(UiContainer parent) {
        Panel panel = new Panel(parent, DesignerMsg.BUTTON_LAYOUT);
        panel.setLayout((Layout)new BorderLayout());
        final List displayButtons = new List((UiContainer)panel, (ListModel)this.displayButtonsModel);
        int x = 0;
        int y = 0;
        Dimension size = Dimension.valueOf(x, y);
        displayButtons.setMaximumSize(size);
        displayButtons.setPreferredSize(size);
        panel.add((UiComponent)displayButtons, (Object)"Center");
        Panel moveButtons = new Panel((UiContainer)panel);
        moveButtons.setLayout((Layout)new GridBagLayout());
        Button upButton = new Button((UiContainer)moveButtons, Image.create((Msg)UIMsg.MOVE_UP));
        Button downButton = new Button((UiContainer)moveButtons, Image.create((Msg)UIMsg.MOVE_DOWN));
        upButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                int index = displayButtons.getSelectedIndex();
                if (index <= 0) {
                    return;
                }
                Object toMove = ButtonPreferencesManager.this.displayButtonsModel.get(index);
                ButtonPreferencesManager.this.displayButtonsModel.remove(index);
                ButtonPreferencesManager.this.displayButtonsModel.add(--index, toMove);
                displayButtons.setSelectedIndex(index);
            }
        });
        downButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                int index = displayButtons.getSelectedIndex();
                if (index < 0 || index == ButtonPreferencesManager.this.displayButtonsModel.getSize() - 1) {
                    return;
                }
                Object toMove = ButtonPreferencesManager.this.displayButtonsModel.get(index);
                ButtonPreferencesManager.this.displayButtonsModel.remove(index);
                ButtonPreferencesManager.this.displayButtonsModel.add(++index, toMove);
                displayButtons.setSelectedIndex(index);
            }
        });
        moveButtons.add((UiComponent)upButton, (Object)ButtonPreferencesManager.getFldConstraints(0, 0));
        moveButtons.add((UiComponent)downButton, (Object)ButtonPreferencesManager.getFldConstraints(1, 0));
        panel.add((UiComponent)moveButtons, (Object)"East");
        return panel;
    }

    private Panel createButtonsToIncludePanel(UiContainer parent) {
        Panel checkPanel = new Panel(parent, DesignerMsg.INCLUDE_BUTTONS);
        String cols = "5dlu, max(75dlu;pref), 4dlu, max(80dlu;pref), 2dlu";
        String rows = "0dlu, pref, 1dlu, pref, 1dlu, pref, 1dlu, pref, 0dlu";
        FormLayout layout = new FormLayout(cols, rows);
        checkPanel.setLayout((Layout)layout);
        CellConstraints cc = layout.createCellConstraints();
        layout.setRowGroups((int[][])new int[][]{{2, 4, 6, 8}});
        this.submitButtonInfo = new ButtonInfo(WebformdesignerMsg.SUBMIT_BUTTON, checkPanel);
        this.cancelButtonInfo = new ButtonInfo(WebformdesignerMsg.CANCEL_BUTTON, checkPanel);
        this.resetButtonInfo = new ButtonInfo(WebformdesignerMsg.RESET_BUTTON, checkPanel);
        this.refreshButtonInfo = new ButtonInfo(WebformdesignerMsg.REFRESH_BUTTON, checkPanel);
        this.submitButtonInfo.addToLayout(checkPanel, cc, 2);
        this.cancelButtonInfo.addToLayout(checkPanel, cc, 4);
        this.resetButtonInfo.addToLayout(checkPanel, cc, 6);
        this.refreshButtonInfo.addToLayout(checkPanel, cc, 8);
        this.submitButtonInfo.addListener(this.displayButtonsModel);
        this.cancelButtonInfo.addListener(this.displayButtonsModel);
        this.resetButtonInfo.addListener(this.displayButtonsModel);
        this.refreshButtonInfo.addListener(this.displayButtonsModel);
        return checkPanel;
    }

    private static class ButtonInfo {
        private CheckBox check;
        private Msg msg;
        private TextField text;

        public ButtonInfo(Msg msg, Panel parent) {
            this.msg = msg;
            this.check = CheckBox.create((UiContainer)parent, (Msg)msg);
            this.text = new TextField((UiContainer)parent);
            this.text.setEnabled(false);
        }

        public void setSelected(boolean b) {
            this.check.setSelected(b);
            this.checkEnableText();
        }

        public void setText(String text) {
            this.text.setText(text);
        }

        public String getText() {
            return this.text.getText();
        }

        public void addToLayout(Panel parent, CellConstraints cc, int y) {
            parent.add((UiComponent)this.check, (Object)cc.xy(2, y));
            parent.add((UiComponent)this.text, (Object)cc.xy(4, y));
        }

        public Msg getMsg() {
            return this.msg;
        }

        public void checkEnableText() {
            this.text.setEnabled(this.isSelected());
        }

        public boolean isSelected() {
            return this.check.isSelected();
        }

        public void addListener(final DefaultListModel buttonModel) {
            this.check.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent ie) {
                    ButtonInfo.this.checkEnableText();
                    if (ButtonInfo.this.isSelected()) {
                        buttonModel.add(buttonModel.getSize(), ButtonInfo.this.getMsg());
                    } else {
                        buttonModel.removeElement(ButtonInfo.this.getMsg());
                    }
                }
            });
        }
    }
}

