/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.outline;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import oracle.bpm.designer.StructureTree;
import oracle.bpm.designer.formdesigner.AbstractPresentationEditor;
import oracle.bpm.designer.formdesigner.ChangeListener;
import oracle.bpm.designer.formdesigner.CommandManager;
import oracle.bpm.designer.formdesigner.PresentationDesignerPanel;
import oracle.bpm.designer.formdesigner.PresentationPanel;
import oracle.bpm.designer.formdesigner.SelectionChangedListener;
import oracle.bpm.designer.formdesigner.Utilities;
import oracle.bpm.designer.formdesigner.XFormSelectionBuilder;
import oracle.bpm.designer.formdesigner.command.Command;
import oracle.bpm.designer.formdesigner.components.PresentationComponent;
import oracle.bpm.designer.formdesigner.outline.DataModelTreeNode;
import oracle.bpm.designer.formdesigner.outline.DataTree;
import oracle.bpm.designer.formdesigner.outline.DataTreeHelper;
import oracle.bpm.designer.formdesigner.outline.MoveToolbar;
import oracle.bpm.designer.formdesigner.outline.PopupMenuManager;
import oracle.bpm.designer.formdesigner.properties.MethodFilter;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.log.Log;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.PopupMenu;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.selection.Selection;
import oracle.bpm.ui.selection.SelectionProvider;
import oracle.bpm.ui.tree.TreeNode;
import oracle.bpm.xobject.presentationmodel.XFormCell;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.xml.XFormXMLObject;

public class PresentationStructureView {
    private MoveToolbar.Actions actions;
    private XFormSelectionBuilder builder;
    private final ChangeListener changeListener;
    private DataTree dataTree;
    private DataTreeHelper helper;
    private PopupMenu lastPopup;
    private Hashtable<String, Integer> names;
    private PopupMenuManager popupManager;
    private AbstractPresentationEditor presentationEditor;
    private DataModelTreeNode rootNode;
    private List<XFormPresentationXMLObject> selectionList;
    private SelectionChangedListener selectionListener;

    public PresentationStructureView(AbstractPresentationEditor panel, ChangeListener changeListener, DataTreeHelper helper) {
        this.presentationEditor = panel;
        this.changeListener = changeListener;
        this.popupManager = new PopupMenuManager(this);
        this.rootNode = new DataModelTreeNode(this.popupManager);
        this.helper = helper;
        this.selectionList = new ArrayList<XFormPresentationXMLObject>();
        this.initTree();
    }

    public SelectionProvider getSelectionProvider() {
        return this.presentationEditor;
    }

    public void setTree(StructureTree structureTree) {
        this.dataTree.setTree(structureTree);
        this.dataTree.setData(this.helper.getModel());
    }

    public UiComponent createStructureView(UiContainer parent) {
        Panel topLevel = new Panel(parent);
        this.doSelect(this.selectionList);
        this.initListeners(topLevel);
        this.dataTree.createTree((UiContainer)topLevel);
        this.dataTree.setData(this.helper.getModel());
        return topLevel;
    }

    public void invoke(Command command) {
        CommandManager.invokeCommand(command);
    }

    public UiComponent createToolbarView(UiContainer parent) {
        return new MoveToolbar(parent, this, this.getToolbarActions());
    }

    public Msg getId() {
        return DesignerMsg.PRESENTATION;
    }

    public void setSelectedComponent(PresentationComponent theComponent) {
        if (this.actions != null) {
            this.actions.setSelectedComponent(theComponent);
        }
    }

    public DataTree getTree() {
        if (this.dataTree == null) {
            Thread.dumpStack();
        }
        return this.dataTree;
    }

    public UiComponent getDisplayComponent() {
        return this.presentationEditor;
    }

    public void recalculateMethods() {
        this.getHelper().recalculateMethods();
    }

    public TreeNode getNode(Object o) {
        return this.helper.getNode(o);
    }

    public boolean isChild(XFormPresentationXMLObject referencedObject, XFormPresentationXMLObject formPresentationXMLObject) {
        return this.helper.isChild(referencedObject, formPresentationXMLObject);
    }

    public ObjectTypeDescription getObjectTypeDescription() {
        return this.helper.getObjectTypeDescription();
    }

    public String getRepeatable(XFormPresentationXMLObject object) {
        return this.helper.getRepeatable(object);
    }

    public Object getArray(XFormCell cell) {
        return this.helper.getArray(cell);
    }

    public Vector getMethods(XFormPresentationXMLObject referencedObject, MethodFilter methodFilter) {
        return this.helper.getMethods(referencedObject, methodFilter);
    }

    public String getPathFor(XFormXMLObject object) {
        return this.helper.getPathFor(object);
    }

    public void select(XFormXMLObject object) {
        if (object instanceof XFormPresentationXMLObject) {
            this.doSelect((XFormPresentationXMLObject)object, false);
        } else {
            Log.logDebug(new IllegalArgumentException());
        }
    }

    public void select(String id) {
        XFormPresentationXMLObject object = this.helper.getObjectForKey(id);
        if (object != null) {
            this.doSelect(object, false);
        }
    }

    public void doSelect(List<XFormPresentationXMLObject> references) {
        this.selectionList.clear();
        boolean add = false;
        for (XFormPresentationXMLObject reference : references) {
            this.selectOnTree(this.helper.get(reference), add);
            add = true;
            if (this.selectionList.contains(reference)) continue;
            this.selectionList.add(reference);
        }
        this.selectionListener.selectionChanged(references);
    }

    public void doSelect(XFormPresentationXMLObject reference, boolean addToSelection) {
        this.selectOnTree(this.helper.get(reference), addToSelection);
        if (!addToSelection) {
            this.selectionList.clear();
        }
        if (!this.selectionList.contains(reference)) {
            this.selectionList.add(reference);
        }
        if (addToSelection) {
            this.selectionListener.selectionAdded(reference);
        } else {
            this.selectionListener.selectionChanged(reference);
        }
    }

    public void addToSelection(XFormPresentationXMLObject referencedObject) {
        this.doSelect(referencedObject, true);
    }

    public boolean isSelected(XFormPresentationXMLObject reference) {
        boolean result = this.dataTree == null ? this.selectionList != null && this.selectionList.contains(reference) : this.dataTree.isSelected(reference);
        return result;
    }

    public PopupMenu getPopUpMenuForSelection(UiContainer menuParent) {
        this.lastPopup = this.popupManager.fillPopUpMenu(this.lastPopup, menuParent, this.getSelectedItems());
        return this.lastPopup;
    }

    public void ensureVisibleSelection() {
        if (this.dataTree != null) {
            this.dataTree.ensureVisibleSelection();
        }
    }

    public DataTreeHelper getHelper() {
        return this.helper;
    }

    public int getIdFor(String name) {
        Integer used = this.getId(name);
        if (used == null) {
            used = 0;
        }
        Integer n = used;
        Integer n2 = used = Integer.valueOf(used + 1);
        this.names.put(name, used);
        return used;
    }

    public void clearIds() {
    }

    public void ensureIdFor(String name, Integer s) {
        Integer used = this.getId(name);
        if (used == null || used.compareTo(s) < 0) {
            this.names.put(name, s);
        }
    }

    public XFormPresentationXMLObject[] getSelectedItems() {
        return this.selectionList.toArray(new XFormPresentationXMLObject[this.selectionList.size()]);
    }

    public void putNode(XFormXMLObject parent, XFormXMLObject child, boolean notify) {
        this.putNode(parent, child, parent.getChildCount(), notify);
    }

    public XFormXMLObject addObject(XFormXMLObject parent, XFormPresentationXMLObject child) {
        return this.addObject(parent, child, true);
    }

    public XFormXMLObject addObject(XFormXMLObject parent, XFormPresentationXMLObject child, int indexWhere, boolean notify) {
        return this.addObject(parent, child, indexWhere, notify, true);
    }

    public XFormXMLObject addObject(XFormXMLObject parent, XFormPresentationXMLObject child, int indexWhere, boolean notify, boolean scrollAndSelect) {
        boolean result;
        child.setParent(parent);
        if (this.dataTree == null || !this.dataTree.hasTree()) {
            result = this.addNode(parent, child, indexWhere, notify);
        } else {
            DataModelTreeNode parentNode = this.helper.getNode(parent);
            boolean bl = result = this.getTree().addObject(parentNode, child, indexWhere, scrollAndSelect) != null;
            if (notify) {
                this.notifyListeners(parent);
            }
        }
        return result ? child : null;
    }

    public PresentationComponent getPresentationComponent(XFormXMLObject parent) {
        if (this.presentationEditor instanceof PresentationDesignerPanel) {
            PresentationPanel presentationPanel = ((PresentationDesignerPanel)this.presentationEditor).getPresentationPanel();
            return presentationPanel.getPresentationComponent(parent);
        }
        return null;
    }

    public ChangeListener getChangeListener() {
        return this.changeListener;
    }

    public XFormXMLObject putNode(XFormXMLObject parent, XFormXMLObject child, int index, boolean notify) {
        if (parent == null) {
            parent = this.rootNode.getContent();
        }
        XFormXMLObject parentObject = parent;
        Class<?> c = parentObject.getClass();
        Field[] f = c.getFields();
        Class<?> childClass = child.getClass();
        for (Field eachField : f) {
            if (java.lang.reflect.Modifier.isStatic(eachField.getModifiers())) continue;
            try {
                if (eachField.getType().equals(childClass) && eachField.get(parentObject) == null) {
                    eachField.set(parentObject, child);
                    break;
                }
                if (!Utilities.isArray(eachField, childClass)) continue;
                Object[] val = (Object[])eachField.get(parentObject);
                if (val == null) {
                    val = (Object[])Array.newInstance(eachField.getType().getComponentType(), 0);
                }
                for (Object aVal : val) {
                    if (!aVal.equals(child)) continue;
                    return child;
                }
                Object newArray = Array.newInstance(eachField.getType().getComponentType(), val.length + 1);
                assert (index <= val.length);
                System.arraycopy(val, 0, newArray, 0, index);
                Array.set(newArray, index, child);
                if (index < val.length) {
                    System.arraycopy(val, index, newArray, index + 1, val.length - index);
                }
                eachField.set(parentObject, newArray);
                break;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        if (notify) {
            this.notifyListeners(parent);
        }
        return child;
    }

    public void notifyListeners(XFormXMLObject parent) {
        this.getChangeListener().changeOccured(ChangeListener.EventFactory.createChange(parent));
    }

    public void clear() {
        this.popupManager.clear(this.getSelectedItems());
    }

    public void requestFocusOn(XFormXMLObject object, boolean innerCompo) {
        this.getPresentationEditor().requestFocusOn(object, innerCompo);
    }

    public List<BaseAction> getActions() {
        return this.getToolbarActions().getActions();
    }

    public void setCollapse(boolean selected) {
        if (this.dataTree != null) {
            this.dataTree.setCollapse(selected);
        }
    }

    public AbstractPresentationEditor getPresentationEditor() {
        return this.presentationEditor;
    }

    public void setSelectionBuilder(XFormSelectionBuilder selectionBuilder) {
        this.builder = selectionBuilder;
    }

    public XFormXMLObject addObject(XFormXMLObject parent, XFormPresentationXMLObject child, boolean notify) {
        return this.addObject(parent, child, -1, notify);
    }

    protected void initTree() {
        this.dataTree = new DataTree(this.presentationEditor, this.helper, this, this.rootNode, this.popupManager);
        this.dataTree.addChangeListener(this.changeListener);
        this.addListener();
    }

    private void setData(Object object, XFormXMLObject parentNode, boolean notify) {
        Field[] fields;
        if (object == null) {
            return;
        }
        Class<?> aClass = object.getClass();
        for (Field field : fields = aClass.getFields()) {
            if (java.lang.reflect.Modifier.isStatic(field.getModifiers())) continue;
            try {
                Object[] val;
                if (object instanceof XFormXMLObject) {
                    String fieldName = field.getName();
                    boolean isId = fieldName.equals("id") || fieldName.equals("id_d");
                    XFormXMLObject xformObject = (XFormXMLObject)object;
                    String xformName = xformObject.getName();
                    if (isId && xformName != null) {
                        String val2 = (String)field.get(object);
                        String xoName = xformName.toLowerCase();
                        if (val2 != null && val2.indexOf(xoName) > -1) {
                            try {
                                int startIndex = val2.indexOf(xoName) + xoName.length();
                                String temp = val2.substring(startIndex, val2.length());
                                this.ensureIdFor(xoName, Integer.valueOf(temp));
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                    }
                }
                if (!field.getType().isArray()) {
                    Object value = field.get(object);
                    if (!(value instanceof XFormPresentationXMLObject)) continue;
                    XFormXMLObject temp = this.addObject(parentNode, (XFormPresentationXMLObject)value, notify);
                    this.setData(value, temp, notify);
                    continue;
                }
                if (field.getType().getComponentType().isPrimitive() || (val = (Object[])field.get(object)) == null) continue;
                for (Object value : val) {
                    if (!(value instanceof XFormPresentationXMLObject)) continue;
                    XFormXMLObject temp = this.addObject(parentNode, (XFormPresentationXMLObject)value, notify);
                    this.setData(value, temp, notify);
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean addNode(XFormXMLObject parent, XFormPresentationXMLObject child, int indexWhere, boolean notify) {
        String childId = child.getId();
        if (childId != null) {
            this.helper.addKey(childId, child);
        }
        boolean done = false;
        if (parent != null) {
            Class<?> parentObjectClass = parent.getClass();
            Field[] parentFields = parentObjectClass.getFields();
            Class<?> childClass = child.getClass();
            for (Field parentField : parentFields) {
                if (Modifier.isStatic(parentField.getModifiers())) continue;
                try {
                    if (parentField.getType().equals(childClass)) {
                        if (DataTree.uniqueViolated(parentObjectClass, parent, parentField.getName())) {
                            return false;
                        }
                        Object parentFieldValue = parentField.get(parent);
                        if (parentFieldValue == null) {
                            parentField.set(parent, child);
                            this.setData(child, child, false);
                            done = true;
                        } else {
                            if (!parentFieldValue.equals(child)) continue;
                            done = true;
                        }
                    } else {
                        if (!Utilities.isArray(parentField, childClass)) continue;
                        Object[] fieldValue = this.getOrCreateFieldValue(parent, parentField);
                        DataTree.addToArray(parentField, indexWhere, parent, child, fieldValue);
                        done = true;
                    }
                    break;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        } else {
            done = true;
        }
        if (!done) {
            this.helper.remove(child, childId);
        }
        if (notify) {
            this.notifyListeners(parent);
        }
        return done;
    }

    private Object[] getOrCreateFieldValue(XFormXMLObject parent, Field parentField) throws IllegalArgumentException, IllegalAccessException {
        Object[] fieldValue = (Object[])parentField.get(parent);
        if (fieldValue == null) {
            fieldValue = (Object[])Array.newInstance(parentField.getType().getComponentType(), 0);
        }
        return fieldValue;
    }

    private void selectOnTree(TreeNode node, boolean addToSelection) {
        if (node != null && this.dataTree != null) {
            this.dataTree.selectOnTree(node, this.selectionListener, addToSelection);
        }
    }

    private void addListener() {
        this.selectionListener = new SelectionChangedListener(){
            boolean isFireing = false;
            Object lastSelection = null;

            @Override
            public void selectionChanged(Object newSelection) {
                if (!this.isFireing && this.checkDisposed() && newSelection != this.lastSelection) {
                    this.lastSelection = newSelection;
                    this.isFireing = true;
                    Selection selection = null;
                    if (newSelection instanceof XFormPresentationXMLObject) {
                        selection = PresentationStructureView.this.builder.buildSelection((XFormPresentationXMLObject)newSelection);
                    } else if (newSelection instanceof List) {
                        List selectionList = (List)newSelection;
                        XFormPresentationXMLObject[] selectionArray = new XFormPresentationXMLObject[selectionList.size()];
                        selectionList.toArray(selectionArray);
                        selection = PresentationStructureView.this.builder.buildSelection(selectionArray);
                    }
                    if (selection != null) {
                        PresentationStructureView.this.getSelectionProvider().setSelection(selection);
                    }
                    this.isFireing = false;
                }
            }

            @Override
            public void selectionAdded(Object newSelection) {
                if (this.checkDisposed()) {
                    XFormPresentationXMLObject xformSelection = (XFormPresentationXMLObject)newSelection;
                    Selection currentSelection = PresentationStructureView.this.getSelectionProvider().getSelection();
                    Selection selection = PresentationStructureView.this.builder.buildSelection(currentSelection, xformSelection);
                    PresentationStructureView.this.getSelectionProvider().setSelection(selection);
                }
            }

            private boolean checkDisposed() {
                boolean isDisposed = PresentationStructureView.this.presentationEditor.isDisposed();
                if (isDisposed) {
                    PresentationStructureView.this.dataTree.removeSelectionChangeListener(this);
                }
                return !isDisposed;
            }
        };
        this.dataTree.addSelectionChangedListener(this.selectionListener);
    }

    private void initListeners(Panel treePanel) {
        if (Ui.isSwing() && this.dataTree.hasTree()) {
            this.dataTree.initListeners(treePanel, this.getPresentationEditor().getActions());
        }
    }

    private Integer getId(String name) {
        if (this.names == null) {
            this.names = new Hashtable();
        }
        return this.names.get(name);
    }

    private MoveToolbar.Actions getToolbarActions() {
        if (this.actions == null) {
            this.actions = new MoveToolbar.Actions(this);
        }
        return this.actions;
    }
}

