/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.outline;

import java.util.ArrayList;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.formdesigner.ChangeListener;
import oracle.bpm.designer.formdesigner.CommandManager;
import oracle.bpm.designer.formdesigner.XFormSelection;
import oracle.bpm.designer.formdesigner.actions.FormDesignerActions;
import oracle.bpm.designer.formdesigner.actions.PresentationAdapterFactory;
import oracle.bpm.designer.formdesigner.command.AddDataCommand;
import oracle.bpm.designer.formdesigner.command.ClearDataCommand;
import oracle.bpm.designer.formdesigner.command.Command;
import oracle.bpm.designer.formdesigner.command.CompoundCommand;
import oracle.bpm.designer.formdesigner.command.RemoveColumnCommand;
import oracle.bpm.designer.formdesigner.model.ComponentType;
import oracle.bpm.designer.formdesigner.outline.DeleteComponentAction;
import oracle.bpm.designer.formdesigner.outline.InsertColumnAction;
import oracle.bpm.designer.formdesigner.outline.InsertRowAction;
import oracle.bpm.designer.formdesigner.outline.PopupActions;
import oracle.bpm.designer.formdesigner.outline.PresentationStructureView;
import oracle.bpm.designer.formdesigner.web.Utils;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CompositeMenu;
import oracle.bpm.ui.PopupMenu;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.ActionGroup;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.selection.DefaultSelection;
import oracle.bpm.ui.selection.Selection;
import oracle.bpm.web.formdesigner.protocol.ComponentContextAction;
import oracle.bpm.webformdesigner.msg.WebformdesignerMsg;
import oracle.bpm.xobject.presentationmodel.XFormArraybutton;
import oracle.bpm.xobject.presentationmodel.XFormCell;
import oracle.bpm.xobject.presentationmodel.XFormComponentType;
import oracle.bpm.xobject.presentationmodel.XFormPresentationComponent;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.presentationmodel.XFormRepeatable;
import oracle.bpm.xobject.presentationmodel.XFormRow;
import oracle.bpm.xobject.presentationmodel.XFormTable;
import oracle.bpm.xobject.xml.XFormXMLObject;

public class PopupMenuManager {
    private final PresentationStructureView view;

    public PopupMenuManager(PresentationStructureView view) {
        this.view = view;
    }

    public static ArrayList<ClearDataCommand> getClearCommands(PresentationStructureView view, XFormPresentationXMLObject selectedNode) {
        ArrayList<ClearDataCommand> result = new ArrayList<ClearDataCommand>();
        if (!Utils.isInModel(selectedNode)) {
            return result;
        }
        ClearDataCommand command = new ClearDataCommand(view, selectedNode);
        XFormXMLObject parentNode = selectedNode.getParent();
        result.add(command);
        if (selectedNode.getComponentType() == XFormComponentType.TABLE && !(parentNode instanceof XFormCell)) {
            return null;
        }
        if (parentNode instanceof XFormPresentationXMLObject) {
            ArrayList<ClearDataCommand> list;
            XFormPresentationXMLObject selectionParent = (XFormPresentationXMLObject)parentNode;
            if (selectedNode.getComponentType() == XFormComponentType.CELL && parentNode.getParent() instanceof XFormTable && selectionParent.getComponentType() == XFormComponentType.ROW && ((XFormRow)parentNode).cell.length == 1) {
                ArrayList<ClearDataCommand> list2 = PopupMenuManager.getClearCommands(view, selectionParent);
                if (list2 != null) {
                    result.addAll(list2);
                }
            } else if (selectedNode.getComponentType() == XFormComponentType.ROW && (selectionParent.getComponentType() == XFormComponentType.TABLE && ((XFormTable)selectionParent).row.length == 1 || selectionParent.getComponentType() == XFormComponentType.ARRAY) && (list = PopupMenuManager.getClearCommands(view, selectionParent)) != null) {
                result.addAll(list);
            }
        }
        return result;
    }

    public static PopupActions.MoveDownAction createMoveCellRightMostAction(PresentationStructureView view, Msg msg) {
        return new PopupActions.MoveDownAction(XFormCell.class, msg, 2, view);
    }

    public static PopupActions.MoveDownAction createMoveCellRightAction(PresentationStructureView view, Msg msg) {
        return new PopupActions.MoveDownAction(XFormCell.class, msg, 1, view);
    }

    public static PopupActions.MoveUpAction createMoveCellLeftMostAction(PresentationStructureView view, Msg msg) {
        return new PopupActions.MoveUpAction(XFormCell.class, msg, 3, view);
    }

    public static FormDesignerAction createDupliacateRowAction(PresentationStructureView view) {
        return PopupMenuManager.createDupliacateRowAction(view, XFormSelection.class, XFormPresentationComponent.class);
    }

    public static FormDesignerAction createDupliacateRowAction(final PresentationStructureView view, Class ... requiredClass) {
        return new FormDesignerAction(DesignerMsg.DUPLICATE_COMPONENT(WebformdesignerMsg.ROW.getString()), requiredClass){

            @Override
            public void run() {
                XFormRow row = this.getSelectionParent(XFormRow.class);
                XFormPresentationXMLObject theNewRow = row.clone();
                XFormXMLObject tableNode = row.getParent();
                int index = tableNode.getIndex(row);
                this.getRunner().run(AddDataCommand.getPasteCommand(tableNode, theNewRow, index, true, view));
            }

            protected void updateEnableStatus(Selection selection) {
                boolean isRepeatableSon = FormDesignerActions.isRepeatableDirectSon(selection);
                XFormRow row = this.getParent(selection, XFormRow.class);
                this.setEnabled(!isRepeatableSon && row != null);
            }
        };
    }

    public static PopupActions.MoveDownAction createMoveRowBottomAction(PresentationStructureView view, Msg msg) {
        return new PopupActions.MoveDownAction(XFormRow.class, msg, 2, view);
    }

    public static PopupActions.MoveDownAction createMoveRowDownAction(PresentationStructureView view, Msg msg) {
        return new PopupActions.MoveDownAction(XFormRow.class, msg, 1, view);
    }

    public static PopupActions.MoveUpAction createMoveRowTopAction(PresentationStructureView view, Msg msg) {
        return new PopupActions.MoveUpAction(XFormRow.class, msg, 3, view);
    }

    public static PopupActions.MoveUpAction createMoveRowUpAction(PresentationStructureView view, Msg msg) {
        return new PopupActions.MoveUpAction(XFormRow.class, msg, 0, view);
    }

    public static FormDesignerAction createRemoveRowAction(PresentationStructureView view) {
        return new RemoveSomethingAction<XFormRow>(WebformdesignerMsg.ROW, XFormRow.class, view);
    }

    public static FormDesignerAction createRemoveTableCommand(PresentationStructureView view) {
        return new RemoveSomethingAction<XFormTable>(WebformdesignerMsg.TABLE, XFormTable.class, view){

            @Override
            protected boolean shouldEnable(XFormTable parent) {
                return parent.getParent() instanceof XFormCell;
            }
        };
    }

    public static FormDesignerAction createRemoveCellCommand(PresentationStructureView view) {
        return new RemoveSomethingAction<XFormCell>(WebformdesignerMsg.CELL, XFormCell.class, view);
    }

    public static FormDesignerAction createRemoveColumnCommand(final PresentationStructureView view) {
        return new FormDesignerAction(UIMsg.DELETE_SOMETHING((String)DesignerMsg.COLUMN.getString()), new Class[]{Void.class}){

            protected void updateEnableStatus(Selection selection) {
                XFormTable table = this.getParent(selection, XFormTable.class);
                XFormCell theCell = this.getParent(selection, XFormCell.class);
                XFormRow theRow = this.getParent(selection, XFormRow.class);
                boolean isRepeatableSon = FormDesignerActions.isRepeatableDirectSon(selection);
                this.setEnabled(table != null && theCell != null && theRow != null && !isRepeatableSon);
            }

            @Override
            public void run() {
                XFormTable table = this.getSelectionParent(XFormTable.class);
                XFormCell theCell = this.getSelectionParent(XFormCell.class);
                XFormRow theRow = this.getSelectionParent(XFormRow.class);
                int cellSpanH = Math.max(theCell.getHexpand(), 1);
                int cellGridColumn = PopupMenuManager.getCellGridColumn(theRow, theCell);
                this.getRunner().run(new RemoveColumnCommand(view, cellGridColumn, cellSpanH, table));
            }
        };
    }

    public static PopupActions.MoveUpAction createMoveCellLeftAction(PresentationStructureView view, Msg msg) {
        return new PopupActions.MoveUpAction(XFormCell.class, msg, 0, view);
    }

    public static ActionGroup createReplaceActionGroup(final PresentationStructureView view) {
        FormDesignerActionGroup replaceMenu = new FormDesignerActionGroup(DesignerMsg.REPLACE_WITH, XFormPresentationComponent.class);
        ActionFactory addActionFactory = new ActionFactory(){

            @Override
            public BaseAction createAction(ComponentType type) {
                return new PopupActions.ReplaceAction(type, view, XFormPresentationComponent.class);
            }
        };
        PopupMenuManager.addComponentActionToMenu(replaceMenu, addActionFactory, false);
        return replaceMenu;
    }

    public PopupMenu fillPopUpMenu(PopupMenu lastPopup, UiContainer menuParent, XFormPresentationXMLObject[] selection) {
        if (selection.length == 1) {
            PopupMenu menu = lastPopup;
            ActionGroup ag = this.getActionGroup();
            Selection selection1 = DefaultSelection.createSingle((Object)selection[0]);
            ag.setSelection(selection1);
            ag.setInline(true);
            menu = this.clearMenu(menu, menuParent);
            ag.addToMenu((CompositeMenu)menu);
            lastPopup = menu;
        } else {
            lastPopup = this.getPopUpFor(menuParent, selection, lastPopup);
        }
        return lastPopup;
    }

    public void clear(XFormPresentationXMLObject[] objects) {
        ArrayList<ClearDataCommand> commmands = new ArrayList<ClearDataCommand>();
        for (XFormPresentationXMLObject object : objects) {
            ArrayList<ClearDataCommand> currentCommmands = PopupMenuManager.getClearCommands(this.view, object);
            if (currentCommmands == null) continue;
            commmands.addAll(currentCommmands);
        }
        CompoundCommand compoundCommand = new CompoundCommand(commmands, UIMsg.MENU_DELETE);
        CommandManager.invokeCommand(compoundCommand);
        for (ClearDataCommand command : commmands) {
            this.view.notifyListeners(command.getNodeParent());
        }
    }

    public ArrayList<ClearDataCommand> getClearCommands(XFormPresentationXMLObject selectedNode) {
        return PopupMenuManager.getClearCommands(this.view, selectedNode);
    }

    public ActionGroup createReplaceActionGroup() {
        return PopupMenuManager.createReplaceActionGroup(this.view);
    }

    protected static int getCellGridColumn(XFormRow row, XFormCell theCell) {
        int result = 1;
        int columnIndex = row.indexOf(theCell);
        for (int i = 0; i < columnIndex; ++i) {
            result += Math.max(row.cell[i].hexpand, 1);
        }
        return result;
    }

    protected ActionGroup getActionGroup() {
        ActionGroup result = new ActionGroup(null);
        result.add((BaseAction)this.createTableActionGroup(true, XFormRow.class, XFormCell.class, XFormPresentationComponent.class));
        result.add((BaseAction)this.createColumnActionGroup());
        result.add((BaseAction)this.createRowActionGroup(true, XFormTable.class, XFormCell.class, XFormPresentationComponent.class));
        result.add((BaseAction)this.createRepeatableActionGroup());
        result.add((BaseAction)this.createCellActionGroup(true, XFormTable.class, XFormRow.class, XFormPresentationComponent.class));
        ChangeListener changeListener = this.view.getChangeListener();
        result.add((BaseAction)new PopupActions.ChangeIdAction(changeListener));
        result.add((BaseAction)new PopupActions.ChangeReferenceAction(changeListener));
        result.add((BaseAction)new PopupActions.ResetReferenceAction(changeListener));
        result.addSeparator();
        result.add((BaseAction)this.createAddActionGroup());
        result.add((BaseAction)this.createReplaceContentActionGroup());
        result.add((BaseAction)this.createReplaceActionGroup());
        ActionGroup rowActionGroup = this.createRowActionGroup(false, XFormRow.class);
        rowActionGroup.setInline(true);
        result.add((BaseAction)rowActionGroup);
        ActionGroup cellActionGroup = this.createCellActionGroup(false, XFormCell.class);
        cellActionGroup.setInline(true);
        result.add((BaseAction)cellActionGroup);
        result.add((BaseAction)new PopupActions.SplitAction(this.view));
        ActionGroup tableActionGroup = this.createTableActionGroup(false, XFormTable.class);
        tableActionGroup.setInline(true);
        result.add((BaseAction)tableActionGroup);
        result.add((BaseAction)new PopupActions.InsertColumnInArrayAction(DesignerMsg.INSERT_COLUMN, this.view));
        DeleteComponentAction removeAction = new DeleteComponentAction(this.view);
        result.add((BaseAction)removeAction);
        return result;
    }

    private static void addComponentActionToMenu(FormDesignerActionGroup actionGroup, ActionFactory actionFactory, boolean addLayoutComponents) {
        FormDesignerActionGroup layout = new FormDesignerActionGroup(WebformdesignerMsg.LAYOUT);
        actionGroup.add((BaseAction)layout);
        layout.add(actionFactory.createAction(ComponentType.TABLE));
        if (addLayoutComponents) {
            layout.add(actionFactory.createAction(ComponentType.ROW));
            layout.add(actionFactory.createAction(ComponentType.CELL));
        }
        FormDesignerActionGroup display = new FormDesignerActionGroup(WebformdesignerMsg.DISPLAY);
        actionGroup.add((BaseAction)display);
        display.add(actionFactory.createAction(ComponentType.LABEL));
        display.add(actionFactory.createAction(ComponentType.LINK));
        display.add(actionFactory.createAction(ComponentType.IMAGE));
        display.add(actionFactory.createAction(ComponentType.IFRAME));
        FormDesignerActionGroup input = new FormDesignerActionGroup(WebformdesignerMsg.INPUT);
        actionGroup.add((BaseAction)input);
        input.add(actionFactory.createAction(ComponentType.TEXT));
        input.add(actionFactory.createAction(ComponentType.MULTILINETEXT));
        input.add(actionFactory.createAction(ComponentType.PASSWORD));
        input.add(actionFactory.createAction(ComponentType.DATETIMEPIKER));
        input.add(actionFactory.createAction(ComponentType.INTERVAL));
        input.add(actionFactory.createAction(ComponentType.COMBO));
        input.add(actionFactory.createAction(ComponentType.CHECK));
        input.add(actionFactory.createAction(ComponentType.RADIO));
        FormDesignerActionGroup buttons = new FormDesignerActionGroup(WebformdesignerMsg.BUTTONS);
        actionGroup.add((BaseAction)buttons);
        buttons.add(actionFactory.createAction(ComponentType.BUTTON));
        buttons.add(actionFactory.createAction(ComponentType.SUBMIT_BUTTON));
        buttons.add(actionFactory.createAction(ComponentType.CANCEL_BUTTON));
        buttons.add(actionFactory.createAction(ComponentType.REFRESH_BUTTON));
        buttons.add(actionFactory.createAction(ComponentType.RESET_BUTTON));
        buttons.add(actionFactory.createAction(ComponentType.SAVE_BUTTON));
        buttons.add(actionFactory.createAction(ComponentType.PRINT_BUTTON));
        FormDesignerActionGroup graphs = new FormDesignerActionGroup(WebformdesignerMsg.GRAPH);
        actionGroup.add((BaseAction)graphs);
        graphs.add(actionFactory.createAction(ComponentType.PIE));
        graphs.add(actionFactory.createAction(ComponentType.CHART));
        graphs.add(actionFactory.createAction(ComponentType.GAUGE));
        FormDesignerActionGroup group = new FormDesignerActionGroup(WebformdesignerMsg.GROUP);
        actionGroup.add((BaseAction)group);
        group.add(actionFactory.createAction(ComponentType.ARRAY));
        group.add(actionFactory.createAction(ComponentType.REPEATABLESECTION));
    }

    private static Command getClearCommand(PresentationStructureView view, XFormPresentationXMLObject object) {
        return object == null ? null : new CompoundCommand(PopupMenuManager.getClearCommands(view, object), UIMsg.MENU_DELETE);
    }

    private PopupMenu getPopUpFor(UiContainer menuParent, final XFormPresentationXMLObject[] selectedObjects, PopupMenu menu) {
        menu = this.clearMenu(menu, menuParent);
        boolean addRemoveAction = true;
        for (XFormPresentationXMLObject node : selectedObjects) {
            if (node.getParent() != null && !(node instanceof XFormArraybutton)) continue;
            addRemoveAction = false;
            break;
        }
        if (addRemoveAction) {
            BaseAction remove = new BaseAction(UIMsg.DELETE_SOMETHING((String)DesignerMsg.SELECTED_ELEMENTS.toString())){

                public void run() {
                    PopupMenuManager.this.clear(selectedObjects);
                }
            };
            menu.add(remove);
        }
        return menu;
    }

    private PopupMenu clearMenu(PopupMenu menu, UiContainer parent) {
        if (menu == null) {
            menu = new PopupMenu(parent);
        } else {
            menu.removeAll();
        }
        return menu;
    }

    private ActionGroup createAddActionGroup() {
        FormDesignerActionGroup addMenu = new FormDesignerActionGroup(DesignerMsg.FORMDESIGNER_ADD, XFormCell.class, XFormTable.class, XFormRow.class);
        ActionFactory addActionFactory = new ActionFactory(){

            @Override
            public BaseAction createAction(ComponentType type) {
                return new PopupActions.AddAction(type, PopupMenuManager.this.view);
            }
        };
        PopupMenuManager.addComponentActionToMenu(addMenu, addActionFactory, true);
        return addMenu;
    }

    private ActionGroup createReplaceContentActionGroup() {
        FormDesignerActionGroup replaceMenu = new FormDesignerActionGroup(DesignerMsg.REPLACE_CONTAINED_COMPONENT, XFormCell.class);
        ActionFactory addActionFactory = new ActionFactory(){

            @Override
            public BaseAction createAction(ComponentType type) {
                return new PopupActions.ReplaceContentAction(type, PopupMenuManager.this.view);
            }
        };
        PopupMenuManager.addComponentActionToMenu(replaceMenu, addActionFactory, false);
        return replaceMenu;
    }

    private ActionGroup createCellActionGroup(boolean addRemoveAction, Class ... requiredClasses) {
        FormDesignerActionGroup result = new FormDesignerActionGroup(WebformdesignerMsg.CELL, requiredClasses){

            protected void updateEnableStatus(Selection selection) {
                PresentationAdapterFactory paf = new PresentationAdapterFactory();
                Object innerSelection = selection.as(Object.class);
                this.setEnabled(paf.adapt(innerSelection, XFormCell.class) != null);
            }
        };
        result.add(PopupMenuManager.createMoveCellLeftAction(this.view, DesignerMsg.MOVE_LEFT));
        result.add(PopupMenuManager.createMoveCellLeftMostAction(this.view, DesignerMsg.MOVE_LEFTMOST));
        result.add(PopupMenuManager.createMoveCellRightAction(this.view, DesignerMsg.MOVE_RIGHT));
        result.add(PopupMenuManager.createMoveCellRightMostAction(this.view, DesignerMsg.MOVE_RIGHTMOST));
        result.addSeparator();
        if (addRemoveAction) {
            FormDesignerAction removeAction = PopupMenuManager.createRemoveCellCommand(this.view);
            result.add(removeAction);
        }
        return result;
    }

    private ActionGroup createRepeatableActionGroup() {
        FormDesignerActionGroup result = new FormDesignerActionGroup(DesignerMsg.GROUP, new Class[]{XFormRow.class, XFormCell.class, XFormPresentationComponent.class}){

            protected void updateEnableStatus(Selection selection) {
                this.setEnabled(this.getSelection().as(XFormRepeatable.class) != null);
            }
        };
        FormDesignerAction insertColArrAction = new FormDesignerAction(DesignerMsg.INSERT_COLUMN, new Class[]{Void.class}){

            @Override
            public void run() {
                XFormRepeatable array = (XFormRepeatable)this.getSelection().as(XFormRepeatable.class);
                AddDataCommand command = PopupActions.getAddColumnCommand(array, PopupMenuManager.this.view);
                this.getRunner().run(command);
            }
        };
        result.add(insertColArrAction);
        return result;
    }

    private ActionGroup createRowActionGroup(boolean addRemoveAction, Class ... requiredClass) {
        FormDesignerActionGroup result = new FormDesignerActionGroup(WebformdesignerMsg.ROW, requiredClass);
        FormDesignerAction duplicate = PopupMenuManager.createDupliacateRowAction(this.view, requiredClass);
        result.add(duplicate);
        result.add(PopupMenuManager.createMoveRowUpAction(this.view, DesignerMsg.FORM_DESIGNER_MOVE_UP));
        result.add(PopupMenuManager.createMoveRowTopAction(this.view, DesignerMsg.MOVE_TOP));
        result.add(PopupMenuManager.createMoveRowDownAction(this.view, DesignerMsg.FORMDESIGNER_MOVE_DOWN));
        result.add(PopupMenuManager.createMoveRowBottomAction(this.view, DesignerMsg.MOVE_BOTTOM));
        if (addRemoveAction) {
            result.addSeparator();
            result.add(PopupMenuManager.createRemoveRowAction(this.view));
        }
        result.setShowOnDisabled(false);
        return result;
    }

    private ActionGroup createColumnActionGroup() {
        FormDesignerActionGroup result = new FormDesignerActionGroup(DesignerMsg.COLUMN, XFormRow.class, XFormCell.class, XFormPresentationComponent.class);
        FormDesignerAction removeColAction = PopupMenuManager.createRemoveColumnCommand(this.view);
        result.add(removeColAction);
        return result;
    }

    private ActionGroup createTableActionGroup(boolean addRemoveAction, Class ... requiredClasses) {
        FormDesignerActionGroup result = new FormDesignerActionGroup(WebformdesignerMsg.TABLE, requiredClasses);
        FormDesignerAction selectAction = new FormDesignerAction(LibMsg.SELECT, new Class[]{Void.class}){

            @Override
            public void run() {
                XFormTable theTable = this.getSelectionParent(XFormTable.class);
                if (theTable != null) {
                    PopupMenuManager.this.view.select(theTable);
                }
            }
        };
        result.add(selectAction);
        result.add(new InsertRowAction(this.view));
        result.add(new InsertColumnAction(this.view));
        result.add(new PopupActions.AppendColumnAction(this.view));
        if (addRemoveAction) {
            result.addSeparator();
            result.add(PopupMenuManager.createRemoveTableCommand(this.view));
        }
        return result;
    }

    private static class RemoveSomethingAction<T extends XFormPresentationXMLObject>
    extends FormDesignerAction {
        private Class<T> parentClass;
        private String typeId;
        private PresentationStructureView view;

        public RemoveSomethingAction(Msg typeToRemove, Class<T> parentClass, PresentationStructureView view) {
            super(UIMsg.DELETE_SOMETHING((String)typeToRemove.getString()), Void.class);
            this.typeId = typeToRemove.getString();
            this.parentClass = parentClass;
            this.view = view;
        }

        @Override
        public String getId() {
            return super.getId() + "_" + this.typeId;
        }

        @Override
        public void run() {
            Command command = PopupMenuManager.getClearCommand(this.view, (XFormPresentationXMLObject)this.getSelectionParent(this.parentClass));
            this.getRunner().run(command);
        }

        protected void updateEnableStatus(Selection selection) {
            XFormPresentationXMLObject parent = (XFormPresentationXMLObject)this.getParent(selection, this.parentClass);
            this.setEnabled(parent != null && this.shouldEnable(parent));
        }

        protected boolean shouldEnable(T parent) {
            return true;
        }
    }

    static class FormDesignerActionGroup
    extends ActionGroup {
        public FormDesignerActionGroup(Msg msg) {
            this(msg, Void.class);
        }

        public FormDesignerActionGroup(Msg msg, Class ... requiredClasses) {
            super(msg, requiredClasses);
            this.setShowOnDisabled(false);
        }

        public void addToMenu(CompositeMenu menu) {
            if (this.isEnabled() || this.isShowOnDisabled()) {
                super.addToMenu(menu);
            }
        }
    }

    public static class FormDesignerAction
    extends DesignerAction
    implements ComponentContextAction {
        public FormDesignerAction(Msg msg) {
            super(msg);
        }

        public FormDesignerAction(Msg msg, Class ... requires) {
            super(msg);
            for (Class require : requires) {
                this.requires(require);
            }
        }

        public String getLabel() {
            return this.getMsg().getString();
        }

        public String getId() {
            return this.getMsg().getCode();
        }

        public <T> T getSelectionParent(Class<T> type) {
            return this.getParent(this.getSelection(), type);
        }

        public <T> T getParent(Selection selection, Class<T> type) {
            return FormDesignerActions.getParent(selection, type);
        }
    }

    private static interface ActionFactory {
        public BaseAction createAction(ComponentType var1);
    }
}

