/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.outline;

import java.util.ArrayList;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.formdesigner.ChangeListener;
import oracle.bpm.designer.formdesigner.ChooseReferenceDialog;
import oracle.bpm.designer.formdesigner.Dialogs;
import oracle.bpm.designer.formdesigner.XFormSelection;
import oracle.bpm.designer.formdesigner.actions.FormDesignerActions;
import oracle.bpm.designer.formdesigner.actions.PresentationAdapterFactory;
import oracle.bpm.designer.formdesigner.command.AddDataCommand;
import oracle.bpm.designer.formdesigner.command.Command;
import oracle.bpm.designer.formdesigner.command.CompoundCommand;
import oracle.bpm.designer.formdesigner.command.ModifyPropertyValueCommand;
import oracle.bpm.designer.formdesigner.command.MoveNodeCommand;
import oracle.bpm.designer.formdesigner.command.ReplaceDataCommand;
import oracle.bpm.designer.formdesigner.components.PresentationTable;
import oracle.bpm.designer.formdesigner.model.ComponentType;
import oracle.bpm.designer.formdesigner.outline.DataTreeHelper;
import oracle.bpm.designer.formdesigner.outline.PopupMenuManager;
import oracle.bpm.designer.formdesigner.outline.PresentationStructureView;
import oracle.bpm.designer.formdesigner.web.RefreshCommand;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.Platform;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.selection.Selection;
import oracle.bpm.web.formdesigner.protocol.ComponentContextAction;
import oracle.bpm.webformdesigner.msg.WebformdesignerMsg;
import oracle.bpm.xobject.presentationmodel.XFormArray;
import oracle.bpm.xobject.presentationmodel.XFormButton;
import oracle.bpm.xobject.presentationmodel.XFormCell;
import oracle.bpm.xobject.presentationmodel.XFormComponentType;
import oracle.bpm.xobject.presentationmodel.XFormPresentation;
import oracle.bpm.xobject.presentationmodel.XFormPresentationComponent;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.presentationmodel.XFormRepeatable;
import oracle.bpm.xobject.presentationmodel.XFormRow;
import oracle.bpm.xobject.presentationmodel.XFormTable;
import oracle.bpm.xobject.xml.XFormXMLObject;

public class PopupActions {
    private static final String HEXPAND = "hexpand";
    private static final String VEXPAND = "vexpand";

    public static UiContainer getDisplayComponent() {
        return Ui.getRoot();
    }

    public static AddDataCommand getAddColumnCommand(XFormRepeatable array, PresentationStructureView view) {
        return array.row == null ? null : new AddDataCommand((XFormXMLObject)array.row, (XFormCell)ComponentType.CELL.createInstance(), view);
    }

    private static class PopupAction
    extends PopupMenuManager.FormDesignerAction {
        public PopupAction(Msg msg) {
            super(msg);
        }

        public void invoke(Command command) {
            this.getRunner().run(command);
        }
    }

    private static class DummyCommand
    extends CompoundCommand {
        ArrayList<? super Command> commands;
        boolean firstTime = true;

        public DummyCommand(ArrayList<? super Command> commands, Msg commandMsg) {
            super(commands, commandMsg);
            this.commands = commands;
        }

        @Override
        public void addCommand(Command command) {
            if (command.doIt()) {
                this.commands.add(command);
            }
        }

        @Override
        public boolean doIt() {
            return this.firstTime || super.doIt();
        }

        @Override
        public boolean undoIt() {
            this.firstTime = false;
            return super.undoIt();
        }
    }

    private static class ChangePopupAction
    extends PopupAction {
        private final ChangeListener listener;

        public ChangePopupAction(Msg msg, ChangeListener listener) {
            super(msg);
            this.listener = listener;
        }

        protected void setValue(String attribute, String newValue, XFormXMLObject where) {
            ModifyPropertyValueCommand c = new ModifyPropertyValueCommand(where, newValue, attribute, this.listener);
            this.invoke(c);
            this.notifyListeners(attribute, newValue, where);
        }

        protected void notifyListeners(String propertyId, Object newValue, XFormXMLObject object) {
            ChangeListener.ChangeEvent change = ChangeListener.EventFactory.createChange(propertyId, newValue, object);
            if (this.listener != null) {
                this.listener.changeOccured(change);
            }
        }
    }

    public static final class SplitAction
    extends ChangePopupAction {
        private final PresentationStructureView view;

        public SplitAction(PresentationStructureView view) {
            super(DesignerMsg.SPLIT_CELL, (ChangeListener)null);
            this.requires(XFormCell.class);
            this.setShowOnDisabled(false);
            this.view = view;
        }

        @Override
        public void run() {
            int count;
            String result = this.getSplitType();
            if (result == null) {
                return;
            }
            XFormCell cell = (XFormCell)this.getSelection().as(XFormCell.class);
            boolean cols = result.equals(DesignerMsg.HORIZONTAL.getString());
            int separation = -1;
            int n = count = !cols ? cell.vexpand : cell.hexpand;
            if (count == 2) {
                separation = 1;
            } else {
                Object[] values = new Object[count - 1];
                int[] firstCol = new int[count - 1];
                for (int i = 1; i < count; ++i) {
                    firstCol[i - 1] = i;
                    values[i - 1] = "" + i;
                }
                Msg msg1 = UIMsg.TO_MSG((String)(DesignerMsg.SPLIT_CELL_AT + " " + (cols ? DesignerMsg.COLUMN : WebformdesignerMsg.ROW) + " "));
                Object option = MessageDialog.showOptions((UiWindow)Ui.getRoot(), (Msg)DesignerMsg.SPLIT_CELL, (Msg)msg1, (Object[])values, (Object)values[0]);
                if (option != null) {
                    for (int i = 0; i < values.length; ++i) {
                        if (!values[i].equals(option)) continue;
                        separation = firstCol[i];
                        break;
                    }
                }
            }
            if (separation != -1) {
                this.split(cell, cell, cols, separation, this.getMsg());
            }
        }

        protected void updateEnableStatus(Selection s) {
            XFormCell cell = (XFormCell)this.getSelection().as(XFormCell.class);
            this.setEnabled(cell != null && (cell.hexpand > 1 || cell.vexpand > 1));
        }

        private boolean split(XFormCell cell, XFormXMLObject dataModelTreeNode, boolean horizontal, int howManyMantain, Msg splitId) {
            XFormXMLObject theRow;
            DummyCommand allCommands = new DummyCommand(new ArrayList(), splitId);
            if (horizontal) {
                theRow = dataModelTreeNode.getParent();
                int pos = theRow.getChildCount() - theRow.getIndex(dataModelTreeNode) - 1;
                AddDataCommand command = new AddDataCommand(theRow, XFormCell.class, this.view);
                allCommands.addCommand(command);
                if (howManyMantain >= 0 && howManyMantain < cell.hexpand) {
                    int other = cell.hexpand - howManyMantain;
                    ModifyPropertyValueCommand hexpandCommand = new ModifyPropertyValueCommand(cell, howManyMantain, PopupActions.HEXPAND);
                    ModifyPropertyValueCommand otherVexpandCommand = new ModifyPropertyValueCommand(dataModelTreeNode, other, PopupActions.VEXPAND);
                    ModifyPropertyValueCommand vexpandCommand = new ModifyPropertyValueCommand(dataModelTreeNode, cell.vexpand, PopupActions.VEXPAND);
                    allCommands.addCommand(hexpandCommand);
                    allCommands.addCommand(otherVexpandCommand);
                    allCommands.addCommand(vexpandCommand);
                }
                while (pos > 0) {
                    MoveNodeCommand c = new MoveNodeCommand(dataModelTreeNode, 0, this.view.getChangeListener(), this.view);
                    allCommands.addCommand(c);
                    --pos;
                }
            } else {
                AddDataCommand command;
                theRow = dataModelTreeNode.getParent();
                PresentationTable presentaitonTable = (PresentationTable)this.view.getPresentationComponent(theRow.getParent());
                if (presentaitonTable == null) {
                    return false;
                }
                int horizontalPos = presentaitonTable.getOccupants().getHorizontalPositionFor((XFormCell)dataModelTreeNode);
                XFormTable theTable = (XFormTable)theRow.getParent();
                int rowIndex = theTable.getIndex(theRow) + howManyMantain;
                if (theTable.getChildCount() <= rowIndex) {
                    command = new AddDataCommand((XFormXMLObject)theTable, XFormRow.class, this.view);
                    allCommands.addCommand(command);
                    rowIndex = theTable.getIndex(theRow) + 1;
                }
                command = new AddDataCommand(theTable.getChildAt(rowIndex), XFormCell.class, this.view);
                XFormCell addedCell = (XFormCell)command.getAddedObject();
                allCommands.addCommand(command);
                if (howManyMantain >= 0 && howManyMantain < cell.vexpand) {
                    ModifyPropertyValueCommand modify1 = new ModifyPropertyValueCommand(cell, howManyMantain, PopupActions.VEXPAND);
                    ModifyPropertyValueCommand modify2 = new ModifyPropertyValueCommand(addedCell, cell.vexpand - howManyMantain, PopupActions.VEXPAND);
                    ModifyPropertyValueCommand modify3 = new ModifyPropertyValueCommand(addedCell, cell.hexpand, PopupActions.HEXPAND);
                    allCommands.addCommand(modify1);
                    allCommands.addCommand(modify2);
                    allCommands.addCommand(modify3);
                }
                if (addedCell.getParent().getChildCount() > 1) {
                    for (int movePos = presentaitonTable.recreateOccupants().getBackMoves(addedCell, horizontalPos); movePos > 0; --movePos) {
                        MoveNodeCommand c = new MoveNodeCommand(addedCell, 0, this.view.getChangeListener(), this.view);
                        allCommands.addCommand(c);
                    }
                }
            }
            this.invoke(allCommands);
            theRow = dataModelTreeNode.getParent();
            XFormXMLObject theTable = theRow.getParent();
            this.recreateLayout(theTable);
            return true;
        }

        private void recreateLayout(XFormXMLObject obj) {
            super.notifyListeners(null, null, obj);
        }

        private String getSplitType() {
            String result;
            XFormCell cell = (XFormCell)this.getSelection().as(XFormCell.class);
            boolean columns = cell.hexpand > 1;
            boolean rows = cell.vexpand > 1;
            boolean isTable = cell.getParent().getParent() instanceof XFormTable;
            String string = result = columns ? DesignerMsg.HORIZONTAL.getString() : DesignerMsg.VERTICAL.getString();
            if (rows && columns && isTable) {
                Object[] options = new String[]{DesignerMsg.HORIZONTAL.getString(), DesignerMsg.VERTICAL.getString()};
                result = (String)MessageDialog.showOptions((UiWindow)Ui.getRoot(), (Msg)DesignerMsg.SPLIT_CELL, (Msg)DesignerMsg.SELECT_CELL_SPLIT_ORIENTATION, (Object[])options, (Object)options[0]);
            }
            return result;
        }
    }

    public static class ResetReferenceAction
    extends ChangePopupAction {
        public ResetReferenceAction(ChangeListener listener) {
            super(CoreMsg.RESET, listener);
            this.requires(XFormPresentationXMLObject.class);
        }

        @Override
        public void run() {
            XFormPresentationXMLObject object = (XFormPresentationXMLObject)this.getSelection().as(XFormPresentationXMLObject.class);
            this.setValue("reference", null, object);
        }

        protected void updateEnableStatus(Selection s) {
            this.setEnabled(((XFormPresentationXMLObject)s.as(XFormPresentationXMLObject.class)).isReferenceable() && s.as(XFormPresentation.class) == null);
        }
    }

    public static class ReplaceContentAction
    extends ReplaceAction {
        public ReplaceContentAction(ComponentType componentType, PresentationStructureView view) {
            super(componentType, view, componentType.requires());
        }

        @Override
        protected XFormXMLObject getParentObject() {
            return (XFormXMLObject)this.getSelection().as(XFormPresentationXMLObject.class);
        }

        @Override
        protected void updateEnableStatus(Selection s) {
            XFormRepeatable repeatable = this.getParent(s, XFormRepeatable.class);
            boolean enable = repeatable == null || this.componentType.canAddIn(repeatable.getComponentID());
            XFormCell cell = (XFormCell)s.as(XFormCell.class);
            enable = enable && cell != null && !cell.hasSpace();
            this.setEnabled(enable);
        }
    }

    public static class ReplaceAction
    extends PopupAction {
        protected ComponentType componentType;
        protected final PresentationStructureView view;
        private Class originalRequiredClass;
        static final long serialVersionUID = -1860462581760210144L;
        static final long serialCheck = -2201328991513075174L;

        public ReplaceAction(ComponentType componentType, PresentationStructureView view, Class requiredClass) {
            super(componentType.getMsg());
            this.originalRequiredClass = requiredClass;
            this.requires(requiredClass);
            this.requires(XFormSelection.class);
            this.componentType = componentType;
            this.view = view;
        }

        @Override
        public void run() {
            boolean copyProperties;
            XFormXMLObject parentObject = this.getParentObject();
            int opt = MessageDialog.showQuestion((UiContainer)PopupActions.getDisplayComponent(), (Msg)DesignerMsg.REPLACE_COMPONENT, (Msg)DesignerMsg.COPY_PROPERTIES, null, (int)14, null);
            if (opt == 2) {
                copyProperties = true;
            } else if (opt == 4) {
                copyProperties = false;
            } else {
                return;
            }
            ReplaceDataCommand command = null;
            switch (this.componentType) {
                case TABLE: {
                    int[] parameters = Dialogs.showTableDimensionsDialog((UiComponent)PopupActions.getDisplayComponent());
                    if (parameters == null) break;
                    XFormTable theTable = new XFormTable(parameters[0], parameters[1]);
                    command = new ReplaceDataCommand(parentObject, (XFormPresentationXMLObject)theTable, copyProperties, this.view);
                    String name = theTable.getName().toLowerCase();
                    command.setId(this.view.getIdFor(name));
                    break;
                }
                case ARRAY: {
                    int parameter = Dialogs.showArrayDimensionsDialog((UiComponent)PopupActions.getDisplayComponent());
                    if (parameter == -1) break;
                    XFormArray theTable = new XFormArray(parameter);
                    command = new ReplaceDataCommand(parentObject, (XFormPresentationXMLObject)theTable, copyProperties, this.view);
                    String name = theTable.getName().toLowerCase();
                    command.setId(this.view.getIdFor(name));
                    break;
                }
                case BUTTON: {
                    Object[] actions = XFormButton.possibleAction_d;
                    String option = (String)MessageDialog.showOptions((UiWindow)Ui.getRoot(), (Msg)DesignerMsg.CREATE_BUTTON, (Msg)DesignerMsg.KIND_OF_BUTTON, (Object[])actions, (Object)actions[0]);
                    if (option == null) break;
                    XFormButton theButton = new XFormButton(option);
                    command = new ReplaceDataCommand(parentObject, (XFormPresentationXMLObject)theButton, copyProperties, this.view);
                    String name = theButton.getName().toLowerCase();
                    command.setId(this.view.getIdFor(name));
                    break;
                }
                default: {
                    XFormPresentationXMLObject newInstance = (XFormPresentationXMLObject)this.componentType.createInstance();
                    command = new ReplaceDataCommand(parentObject, newInstance, copyProperties, this.view);
                    String name = newInstance.getName().toLowerCase();
                    command.setId(this.view.getIdFor(name));
                }
            }
            if (command != null) {
                this.invoke(command);
            }
        }

        protected XFormXMLObject getParentObject() {
            XFormPresentationXMLObject xform = this.getFromSelection(this.getSelection());
            return xform.getParent();
        }

        protected void updateEnableStatus(Selection s) {
            boolean enable;
            XFormPresentationXMLObject xformSelection = this.getFromSelection(s);
            boolean bl = enable = xformSelection != null && this.originalRequiredClass.isInstance(xformSelection);
            if (enable) {
                ComponentType selectionType = ComponentType.get(xformSelection);
                boolean bl2 = enable = selectionType != this.componentType;
                if (enable && !ComponentType.isGroup(selectionType)) {
                    XFormRepeatable repeatable = this.getParent(s, XFormRepeatable.class);
                    enable = repeatable == null || this.componentType.canAddIn(repeatable.getComponentID());
                }
                enable = enable && this.componentType.canAddIn(((XFormPresentationXMLObject)this.getParentObject()).getComponentID());
            }
            this.setEnabled(enable);
        }

        private XFormPresentationXMLObject getFromSelection(Selection s) {
            XFormSelection xformSelection = (XFormSelection)s.as(XFormSelection.class);
            XFormPresentationXMLObject result = xformSelection == null ? (XFormPresentationXMLObject)s.as(XFormPresentationXMLObject.class) : xformSelection.getSelection();
            return result;
        }
    }

    public static class MoveUpAction
    extends MoveAction {
        public MoveUpAction(Class<? extends XFormXMLObject> clazz, Msg msg, int where, PresentationStructureView view) {
            super(clazz, msg, where, view);
        }

        @Override
        protected boolean shouldEnable(int index) {
            return index > 0;
        }
    }

    public static class MoveDownAction
    extends MoveAction {
        public MoveDownAction(Class<? extends XFormXMLObject> clazz, Msg msg, int where, PresentationStructureView view) {
            super(clazz, msg, where, view);
        }

        @Override
        protected boolean shouldEnable(int index) {
            XFormXMLObject object = this.getXMLObjectSelection();
            XFormXMLObject parent = object.getParent();
            int childCount = parent.getChildCount();
            return index < childCount - 1;
        }
    }

    public static class InsertColumnInArrayAction
    extends DesignerAction {
        private final PresentationStructureView view;

        InsertColumnInArrayAction(Msg msg, PresentationStructureView view) {
            super(msg);
            this.requires(XFormRepeatable.class);
            this.setShowOnDisabled(false);
            this.view = view;
        }

        @Override
        public void run() {
            XFormRepeatable repeatable = (XFormRepeatable)this.getSelection().as(XFormRepeatable.class);
            AddDataCommand command = PopupActions.getAddColumnCommand(repeatable, this.view);
            this.getRunner().run(command);
        }
    }

    public static class ChangeReferenceAction
    extends ChangePopupAction {
        public ChangeReferenceAction(ChangeListener listener) {
            super(DesignerMsg.REFERENCE, listener);
            this.requires(XFormPresentationXMLObject.class);
        }

        @Override
        public void run() {
            XFormPresentationXMLObject object = (XFormPresentationXMLObject)this.getSelection().as(XFormPresentationXMLObject.class);
            ObjectTypeDescription owner = Platform.getAdapterService().adaptTo(object, ObjectTypeDescription.class);
            String path = DataTreeHelper.getNodeReferencesPath(object);
            ChooseReferenceDialog d = new ChooseReferenceDialog(owner, path, object);
            d.pack();
            d.setLocationRelativeTo(null);
            d.setVisible(true);
            if (d.userAccepted()) {
                this.setValue("reference", d.getReference(), object);
            }
        }

        protected void updateEnableStatus(Selection s) {
            this.setEnabled(((XFormPresentationXMLObject)s.as(XFormPresentationXMLObject.class)).isReferenceable() && s.as(XFormPresentation.class) == null);
        }
    }

    public static class ChangeIdAction
    extends ChangePopupAction {
        public ChangeIdAction(ChangeListener changeListener) {
            super(CoreMsg.NAME, changeListener);
            this.requires(XFormPresentationComponent.class);
        }

        @Override
        public void run() {
            XFormPresentationComponent xFormPresentationComponent = (XFormPresentationComponent)this.getSelection().as(XFormPresentationComponent.class);
            String res = MessageDialog.showInput((UiWindow)Ui.getRoot(), (Msg)DesignerMsg.INPUT_VALUE, (Msg)CoreMsg.NAME, (String)xFormPresentationComponent.getId());
            if (res != null) {
                if ("".equals(res.trim())) {
                    res = null;
                }
                this.setValue("id", res, xFormPresentationComponent);
            }
        }
    }

    public static class AppendColumnAction
    extends PopupAction {
        private final PresentationStructureView view;

        public AppendColumnAction(PresentationStructureView view) {
            super(DesignerMsg.APPEND_COLUMN);
            this.requires(Void.class);
            this.view = view;
        }

        @Override
        public void run() {
            XFormTable table = this.getSelectionParent(XFormTable.class);
            if (table.row != null) {
                ArrayList<AddDataCommand> list = new ArrayList<AddDataCommand>();
                for (int i = 0; i < table.row.length; ++i) {
                    XFormRow eachRow = table.row[i];
                    AddDataCommand command = new AddDataCommand((XFormXMLObject)eachRow, XFormCell.class, this.view);
                    command.setFireEvents(false);
                    list.add(command);
                }
                CompoundCommand compoundCommand = new CompoundCommand(list, DesignerMsg.APPEND_COLUMN);
                this.getRunner().run(compoundCommand);
                this.view.getChangeListener().changeOccured(ChangeListener.EventFactory.createChange(table));
            }
        }

        protected void updateEnableStatus(Selection s) {
            XFormSelection xFormSelection = (XFormSelection)s.as(XFormSelection.class);
            if (xFormSelection != null && (xFormSelection.getSelection() == null || FormDesignerActions.isRepeatableDirectSon(s) || xFormSelection.getSelection().getComponentType() == XFormComponentType.PRESENTATION)) {
                this.setEnabled(false);
            }
        }
    }

    public static class AddAction
    extends PopupAction {
        private ComponentType componentType;
        private final PresentationStructureView view;
        static final long serialVersionUID = -2700559002733451315L;
        static final long serialCheck = -6343236896067683317L;

        public AddAction(ComponentType componentType, PresentationStructureView view) {
            super(componentType.getMsg());
            this.componentType = componentType;
            this.requires(componentType.requires());
            this.view = view;
        }

        public void setSelection(Selection selection) {
            super.setSelection(selection);
        }

        @Override
        public void run() {
            XFormPresentationXMLObject xFormPresentationXMLObject = (XFormPresentationXMLObject)this.getSelection().as(XFormPresentationXMLObject.class);
            XFormPresentationXMLObject component = null;
            switch (this.componentType) {
                case TABLE: {
                    int[] parameters = Dialogs.showTableDimensionsDialog((UiComponent)PopupActions.getDisplayComponent());
                    if (parameters == null) break;
                    component = new XFormTable(parameters[0], parameters[1]);
                    break;
                }
                case ARRAY: {
                    int parameter = Dialogs.showArrayDimensionsDialog((UiComponent)PopupActions.getDisplayComponent());
                    if (parameter == -1) break;
                    component = new XFormArray(parameter);
                    break;
                }
                case ROW: {
                    XFormTable table = (XFormTable)xFormPresentationXMLObject;
                    int[] rowParameters = Dialogs.showRowDimensionDialog(PopupActions.getDisplayComponent(), table.getModelTotalColumns());
                    if (rowParameters == null) break;
                    component = new XFormRow(rowParameters[0]);
                    break;
                }
                case BUTTON: {
                    String option = (String)MessageDialog.showOptions((UiWindow)Ui.getRoot(), (Msg)DesignerMsg.CREATE_BUTTON, (Msg)DesignerMsg.KIND_OF_BUTTON, (Object[])XFormButton.possibleAction_d, (Object)XFormButton.possibleAction_d[0]);
                    if (option == null) break;
                    component = new XFormButton(option);
                    break;
                }
                default: {
                    component = (XFormPresentationXMLObject)this.componentType.createInstance();
                }
            }
            if (component != null) {
                AddDataCommand command = new AddDataCommand((XFormXMLObject)xFormPresentationXMLObject, component, this.view);
                command.setCommandId();
                this.invoke(command);
            }
        }

        protected void updateEnableStatus(Selection s) {
            XFormRepeatable repeatable = this.getParent(s, XFormRepeatable.class);
            boolean enable = repeatable == null || this.componentType.canAddIn(repeatable.getComponentID());
            XFormCell cell = (XFormCell)s.as(XFormCell.class);
            enable = enable && (cell == null || cell.hasSpace());
            this.setEnabled(enable);
        }
    }

    public static abstract class MoveAction
    extends DesignerAction
    implements ComponentContextAction {
        private Class<? extends XFormXMLObject> clazz;
        private PresentationStructureView view;
        private int where;
        static final long serialVersionUID = -618945957198462747L;
        static final long serialCheck = 8091315000920602181L;

        public MoveAction(Class<? extends XFormXMLObject> clazz, Msg msg, int where, PresentationStructureView view) {
            super(msg);
            this.requires(Void.class);
            this.where = where;
            this.clazz = clazz;
            this.view = view;
        }

        public String getLabel() {
            return this.getMsg().getString();
        }

        public String getId() {
            return this.getMsg().getCode();
        }

        @Override
        public void run() {
            XFormXMLObject xFormXMLObject = this.getXMLObjectSelection();
            MoveNodeCommand command = new MoveNodeCommand(xFormXMLObject, this.where, null, this.view);
            this.getRunner().run(RefreshCommand.addRefreshAndIgnoreEvents(command, this.view));
        }

        protected void updateEnableStatus(Selection s) {
            XFormXMLObject object = this.getXMLObjectSelection();
            if (object == null) {
                this.setEnabled(false);
                return;
            }
            XFormXMLObject parent = object.getParent();
            int index = parent.getIndex(object);
            this.setEnabled(this.shouldEnable(index));
        }

        protected XFormXMLObject getXMLObjectSelection() {
            XFormXMLObject xFormXMLObject = (XFormXMLObject)this.getSelection().as(this.clazz);
            if (xFormXMLObject == null) {
                PresentationAdapterFactory paf = new PresentationAdapterFactory();
                Object innerSelection = this.getSelection().as(Object.class);
                xFormXMLObject = paf.adapt(innerSelection, this.clazz);
            }
            return xFormXMLObject;
        }

        abstract boolean shouldEnable(int var1);
    }
}

