/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.outline;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.formdesigner.command.MoveNodeCommand;
import oracle.bpm.designer.formdesigner.components.PresentationCell;
import oracle.bpm.designer.formdesigner.components.PresentationComponent;
import oracle.bpm.designer.formdesigner.components.PresentationRow;
import oracle.bpm.designer.formdesigner.outline.PresentationStructureView;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.xobject.xml.XFormXMLObject;

class MoveToolbar
extends ToolBar {
    private Actions actions;
    private PresentationStructureView view;

    public MoveToolbar(UiContainer parent, PresentationStructureView view, Actions actions) {
        super(parent);
        this.view = view;
        this.init();
    }

    public MoveToolbar(UiContainer parent, PresentationStructureView view, boolean isEditable) {
        this(parent, view, new Actions(view));
        this.actions.isEditable = isEditable;
    }

    private void init() {
        this.add(this.actions.moveUpAction);
        this.add(this.actions.moveDownAction);
        this.addToggleButton(this.actions.collapseAction);
    }

    public static class Actions {
        private BaseAction collapseAction;
        private boolean isEditable;
        private BaseAction moveDownAction;
        private BaseAction moveUpAction;
        private final PresentationStructureView presentationView;

        public Actions(PresentationStructureView view) {
            this.presentationView = view;
            this.moveUpAction = this.createAction(DesignerMsg.FORM_DESIGNER_MOVE_UP, 0);
            this.moveDownAction = this.createAction(DesignerMsg.FORMDESIGNER_MOVE_DOWN, 1);
            this.collapseAction = new BaseAction(DesignerMsg.COLLAPSE_UNSELECTED){
                boolean selected;
                {
                    this.selected = false;
                }

                public void run() {
                    this.selected = !this.selected;
                    Actions.this.presentationView.setCollapse(this.selected);
                }
            };
        }

        public void setSelectedComponent(PresentationComponent theComponent) {
            boolean visible = false;
            if (theComponent != null && this.isEditable) {
                if (theComponent instanceof PresentationRow) {
                    this.moveUpAction.setMsg(DesignerMsg.FORM_DESIGNER_MOVE_UP);
                    this.moveDownAction.setMsg(DesignerMsg.FORMDESIGNER_MOVE_DOWN);
                    visible = true;
                } else if (theComponent instanceof PresentationCell) {
                    this.moveUpAction.setMsg(DesignerMsg.MOVE_LEFT);
                    this.moveDownAction.setMsg(DesignerMsg.MOVE_RIGHT);
                    visible = true;
                }
            }
            this.moveUpAction.setEnabled(visible);
            this.moveDownAction.setEnabled(visible);
        }

        public void setEditable(boolean b) {
            this.isEditable = b;
        }

        public List<BaseAction> getActions() {
            ArrayList<BaseAction> actions = new ArrayList<BaseAction>();
            actions.add(this.moveUpAction);
            actions.add(this.moveDownAction);
            actions.add(this.collapseAction);
            return actions;
        }

        private BaseAction createAction(Msg msg, final int whereToMove) {
            DesignerAction result = new DesignerAction(msg){

                @Override
                public void run() {
                    XFormXMLObject[] selection = Actions.this.presentationView.getSelectedItems();
                    if (selection != null) {
                        MoveNodeCommand command = new MoveNodeCommand(selection, whereToMove, Actions.this.presentationView.getChangeListener(), Actions.this.presentationView);
                        this.getRunner().run(command);
                    }
                }
            };
            result.setEnabled(false);
            return result;
        }
    }
}

