/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.outline;

import oracle.bpm.designer.formdesigner.Dialogs;
import oracle.bpm.designer.formdesigner.XFormSelection;
import oracle.bpm.designer.formdesigner.actions.FormDesignerActions;
import oracle.bpm.designer.formdesigner.command.AddDataCommand;
import oracle.bpm.designer.formdesigner.outline.PopupActions;
import oracle.bpm.designer.formdesigner.outline.PopupMenuManager;
import oracle.bpm.designer.formdesigner.outline.PresentationStructureView;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.ui.selection.Selection;
import oracle.bpm.xobject.presentationmodel.XFormCell;
import oracle.bpm.xobject.presentationmodel.XFormPresentationComponent;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.presentationmodel.XFormRow;
import oracle.bpm.xobject.presentationmodel.XFormTable;
import oracle.bpm.xobject.xml.XFormXMLObject;

public class InsertRowAction
extends PopupMenuManager.FormDesignerAction {
    private PresentationStructureView view;

    public InsertRowAction(PresentationStructureView view) {
        super(DesignerMsg.INSERT_ROW, XFormCell.class, XFormPresentationComponent.class, XFormSelection.class);
        this.view = view;
    }

    @Override
    public void run() {
        XFormRow theRow;
        XFormRow component = null;
        XFormTable table = this.getSelectionParent(XFormTable.class);
        int[] rowParameters = Dialogs.showRowDimensionDialog(PopupActions.getDisplayComponent(), table.getModelTotalColumns());
        if (rowParameters != null) {
            component = new XFormRow(rowParameters[0]);
        }
        if (component != null && (theRow = this.getSelectionParent(XFormRow.class)) != null) {
            int index = table.indexOf(theRow);
            AddDataCommand command = new AddDataCommand((XFormXMLObject)table, component, this.view, index);
            command.setCommandId();
            this.getRunner().run(command);
        }
    }

    protected void updateEnableStatus(Selection s) {
        super.updateEnableStatus(s);
        XFormSelection selection = (XFormSelection)s.as(XFormSelection.class);
        if (selection != null) {
            XFormPresentationXMLObject xmlObject = selection.getSelection();
            this.setEnabled(!FormDesignerActions.isRepeatableDirectSon(s) && (xmlObject instanceof XFormCell || xmlObject instanceof XFormPresentationComponent));
        }
    }
}

