/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.outline;

import java.util.Hashtable;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import oracle.bpm.designer.formdesigner.outline.DataModelTreeNode;
import oracle.bpm.designer.formdesigner.outline.DataTree;
import oracle.bpm.designer.formdesigner.outline.NodeProvider;
import oracle.bpm.designer.formdesigner.properties.MethodFilter;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.SuperType;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.ui.tree.TreeNode;
import oracle.bpm.xobject.lib.XObjectTypeDescriptionHelper;
import oracle.bpm.xobject.presentationmodel.XFormCell;
import oracle.bpm.xobject.presentationmodel.XFormPresentation;
import oracle.bpm.xobject.presentationmodel.XFormPresentationModel;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.presentationmodel.XFormRepeatable;
import oracle.bpm.xobject.presentationmodel.XFormRow;
import oracle.bpm.xobject.xml.XFormXMLObject;

public class DataTreeHelper
implements NodeProvider {
    private Vector<String> allArrayMethods;
    private Vector<String> allComponentMethods;
    private Hashtable<XFormPresentationXMLObject, DataModelTreeNode> hash;
    private Hashtable<String, XFormPresentationXMLObject> keyHash_d;
    private String lastArray;
    private XFormPresentationModel presentation;
    private static final int[] REPEATABLE_IDS = new int[]{15, 18};
    private static final int[] ARRAY_IDS = new int[]{15};

    public DataTreeHelper(XFormPresentationModel presentation) {
        this.presentation = presentation;
        this.hash = new Hashtable();
        this.keyHash_d = new Hashtable();
    }

    public static void refreshNames(XFormXMLObject object, DataTreeHelper helper) {
        if (object != null && helper != null) {
            XFormXMLObject parent = object;
            while ((parent = parent.getParent()) instanceof XFormCell || parent instanceof XFormRow) {
                DataModelTreeNode parentNode = helper.getNode(parent);
                if (parentNode == null) continue;
                parentNode.nodeChanged();
            }
        }
    }

    public static String getNodeReferencesPath(XFormXMLObject node) {
        XFormXMLObject parentContent;
        XFormXMLObject parentnode = node;
        String resultString = null;
        while (parentnode.getParent() != null && !((parentContent = parentnode.getParent()) instanceof XFormPresentation) && parentContent instanceof XFormPresentationXMLObject) {
            XFormPresentationXMLObject presentationObject = (XFormPresentationXMLObject)parentContent;
            if (presentationObject.isReferenceable()) {
                resultString = presentationObject.getReference();
                if (!(presentationObject instanceof XFormRepeatable)) break;
                resultString = resultString + "[]";
                break;
            }
            parentnode = parentnode.getParent();
        }
        return resultString;
    }

    public static String getRepeatable(XFormXMLObject node) {
        return DataTreeHelper.isInRepeatable(node);
    }

    public XFormPresentationModel getModel() {
        return this.presentation;
    }

    public ObjectTypeDescription getObjectTypeDescription() {
        return this.presentation == null ? null : this.presentation.getOwner();
    }

    public void recalculateMethods() {
        this.allArrayMethods = null;
        this.lastArray = null;
        this.allComponentMethods = null;
    }

    public Vector getMethods(String arrayName) {
        if (this.allComponentMethods == null) {
            this.allComponentMethods = this.getAllMethods(this.getObjectTypeDescription(), "", DataTree.defaultFilter);
        }
        if (arrayName != null && arrayName.trim().length() > 0) {
            if (this.allArrayMethods == null || !arrayName.equals(this.lastArray)) {
                this.allArrayMethods = null;
                this.lastArray = arrayName;
                MethodTypeDescription arrayAttribute = this.getObjectTypeDescription().findMember(this.lastArray);
                if (arrayAttribute != null) {
                    TypeDescription attributeType = arrayAttribute.getResultType();
                    TypeDescription elementType = attributeType.getElementType();
                    if (attributeType.isArray() && elementType instanceof ObjectTypeDescription) {
                        ObjectTypeDescription arrayTD = (ObjectTypeDescription)elementType;
                        String arrayPrefix = XObjectTypeDescriptionHelper.getArrayPrefix((String)arrayName);
                        this.allArrayMethods = this.getAllMethods(arrayTD, arrayPrefix, DataTree.defaultFilter);
                    }
                }
            }
            if (this.allArrayMethods != null) {
                Vector<String> allMethods = new Vector<String>();
                allMethods.addAll(this.allComponentMethods);
                allMethods.addAll(this.allArrayMethods);
                return allMethods;
            }
        }
        return this.allComponentMethods;
    }

    public Vector getMethods(String arrayName, MethodFilter methodFilter) {
        if (methodFilter == null || methodFilter == DataTree.defaultFilter) {
            return this.getMethods(arrayName);
        }
        ObjectTypeDescription xo = this.getObjectTypeDescription();
        Vector<String> currentComponentMethods = this.getAllMethods(xo, "", methodFilter);
        Vector<String> currentArrayMethods = null;
        if (arrayName != null && arrayName.trim().length() > 0) {
            MethodTypeDescription arrayAttribute = xo.findMember(arrayName);
            if (arrayAttribute != null) {
                TypeDescription attributeType = arrayAttribute.getResultType();
                TypeDescription elementType = attributeType.getElementType();
                if (attributeType.isArray() && elementType instanceof ObjectTypeDescription) {
                    ObjectTypeDescription arrayTD = (ObjectTypeDescription)elementType;
                    String arrayPrefix = XObjectTypeDescriptionHelper.getArrayPrefix((String)arrayName);
                    currentArrayMethods = this.getAllMethods(arrayTD, arrayPrefix, methodFilter);
                }
            }
            if (currentArrayMethods != null) {
                Vector<String> allMethods = new Vector<String>();
                allMethods.addAll(currentComponentMethods);
                allMethods.addAll(currentArrayMethods);
                return allMethods;
            }
        }
        return currentComponentMethods;
    }

    @Override
    public DataModelTreeNode getNode(Object o) {
        DataModelTreeNode node = null;
        if (o != null) {
            node = this.hash.get(o);
        }
        return node;
    }

    public void add(XFormPresentationXMLObject childObject, DataModelTreeNode child) {
        this.hash.put(childObject, child);
    }

    public String getPathFor(XFormXMLObject object) {
        return DataTreeHelper.getNodeReferencesPath(object);
    }

    public TreeNode get(XFormXMLObject object) {
        return object == null ? null : this.hash.get(object);
    }

    public boolean isChild(XFormPresentationXMLObject posibleChild, XFormPresentationXMLObject posibleParent) {
        boolean isChild = false;
        DataModelTreeNode node = this.getNode(posibleChild);
        if (node != null) {
            for (DataModelTreeNode parent = (DataModelTreeNode)node.getParent(); parent != null; parent = (DataModelTreeNode)parent.getParent()) {
                if (parent.getContent() == null || !parent.getContent().equals(posibleParent)) continue;
                isChild = true;
                break;
            }
        }
        return isChild;
    }

    public void remove(XFormXMLObject childObject) {
        this.hash.remove(childObject);
    }

    public XFormPresentationXMLObject getObjectForKey(String id) {
        return this.keyHash_d.get(id);
    }

    public void add(DataModelTreeNode child) {
        XFormPresentationXMLObject childObject = child.getContent();
        String childId = child.getId();
        if (childObject != null) {
            this.add(childObject, child);
            if (childId != null && !"".equals(childId.trim())) {
                this.addKey(childId, childObject);
            }
        } else {
            System.out.println("This should not happen DataTreeHelper.add()");
            Thread.dumpStack();
        }
    }

    public void remove(XFormXMLObject childObject, String childId) {
        if (childObject != null) {
            this.remove(childObject);
        }
        if (childId != null && !"".equals(childId.trim())) {
            this.removeKey(childId);
        }
    }

    public TreeNode getNodeForKey(String id) {
        TreeNode result = null;
        XFormPresentationXMLObject object = this.keyHash_d.get(id);
        if (object != null) {
            if (object instanceof TreeNode) {
                result = (TreeNode)object;
            } else if (object instanceof XFormXMLObject) {
                result = this.get(object);
            }
        }
        return result;
    }

    public void addKey(String childId, XFormPresentationXMLObject childObject) {
        this.keyHash_d.put(childId, childObject);
    }

    public Vector getMethods(XFormPresentationXMLObject presentationObject, MethodFilter methodFilter) {
        String array = this.getRepeatable(presentationObject);
        return this.getMethods(array, methodFilter);
    }

    static String isInRepeatable(XFormXMLObject node) {
        return DataTreeHelper.isIn(node, REPEATABLE_IDS);
    }

    static String isInArray(XFormXMLObject node) {
        return DataTreeHelper.isIn(node, ARRAY_IDS);
    }

    static String isIn(XFormXMLObject formXMLObject, int[] acceptedTypes) {
        String index = null;
        while (formXMLObject.getParent() != null) {
            XFormPresentationXMLObject presentationObject;
            XFormXMLObject content = formXMLObject.getParent();
            if (content instanceof XFormPresentationXMLObject && DataTreeHelper.isValueInArray(acceptedTypes, (presentationObject = (XFormPresentationXMLObject)content).getComponentID())) {
                index = presentationObject.getReference();
                if (index != null) break;
                index = "";
                break;
            }
            formXMLObject = formXMLObject.getParent();
        }
        return index;
    }

    String getRepeatable(XFormPresentationXMLObject presentationObject) {
        DataModelTreeNode node = this.getNode(presentationObject);
        return node == null ? null : DataTreeHelper.isInRepeatable(presentationObject);
    }

    String getArray(XFormPresentationXMLObject presentationObject) {
        return DataTreeHelper.isInArray(presentationObject);
    }

    private static boolean isValueInArray(int[] ids, int id) {
        boolean result = false;
        for (int arrayId : ids) {
            if (arrayId != id) continue;
            result = true;
            break;
        }
        return result;
    }

    private Vector<String> getAllMethods(ObjectTypeDescription object, String arrayPrefix, MethodFilter methodFilter) {
        TreeSet<String> set = new TreeSet<String>();
        this.addAllMethods(object, arrayPrefix, set, methodFilter);
        Vector<String> vector = new Vector<String>();
        vector.addAll(set);
        return vector;
    }

    private void addAllMethods(ObjectTypeDescription object, String arrayPrefix, Set<String> set, MethodFilter methodFilter) {
        DataTree.addObjectMethods(object, arrayPrefix, set, methodFilter);
        for (SuperType superType : object.getSuperTypes()) {
            if (superType.isHidden()) continue;
            ObjectTypeDescription superotd = superType.getObjectType();
            this.addAllMethods(superotd, arrayPrefix, set, methodFilter);
        }
    }

    private void removeKey(String childId) {
        this.keyHash_d.remove(childId);
    }
}

