/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.outline;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import oracle.bpm.designer.StructureTree;
import oracle.bpm.designer.formdesigner.AbstractPresentationEditor;
import oracle.bpm.designer.formdesigner.ChangeListener;
import oracle.bpm.designer.formdesigner.CommandManager;
import oracle.bpm.designer.formdesigner.SelectionChangedListener;
import oracle.bpm.designer.formdesigner.Utilities;
import oracle.bpm.designer.formdesigner.actions.ClipBoardActions;
import oracle.bpm.designer.formdesigner.actions.FormDesignerActions;
import oracle.bpm.designer.formdesigner.command.ClearDataCommand;
import oracle.bpm.designer.formdesigner.command.CompoundCommand;
import oracle.bpm.designer.formdesigner.outline.DataModelTreeNode;
import oracle.bpm.designer.formdesigner.outline.DataTreeHelper;
import oracle.bpm.designer.formdesigner.outline.PopupMenuManager;
import oracle.bpm.designer.formdesigner.outline.PresentationStructureView;
import oracle.bpm.designer.formdesigner.properties.MethodFilter;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.log.Log;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.KeyStroke;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.PopupMenu;
import oracle.bpm.ui.TreeSelectionMode;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.event.TreeSelectionEvent;
import oracle.bpm.ui.event.TreeSelectionListener;
import oracle.bpm.ui.layout.GridLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.tree.Tree;
import oracle.bpm.ui.tree.TreeNode;
import oracle.bpm.ui.tree.TreePath;
import oracle.bpm.util.ArrayUtils;
import oracle.bpm.xobject.presentationmodel.XFormArraybutton;
import oracle.bpm.xobject.presentationmodel.XFormCell;
import oracle.bpm.xobject.presentationmodel.XFormPresentationModel;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.presentationmodel.XFormRow;
import oracle.bpm.xobject.xml.XFormXMLObject;

public class DataTree {
    public int ignoreNextSelectionEvents = 0;
    private List<ChangeListener> changeListenerList;
    private boolean collapse = false;
    private DataTreeHelper helper;
    private PopupMenu lastPopup;
    private PopupMenuManager popupMenuManager;
    private AbstractPresentationEditor presentationPanel;
    private DataModelTreeNode rootNode;
    private List<SelectionChangedListener> selectionChangedListeners;
    private StructureTree tree;
    private final PresentationStructureView view;
    private static Comparator<TreeNode> defaultNodeComparator;
    static final MethodFilter defaultFilter;

    public DataTree(AbstractPresentationEditor presentationPanel, DataTreeHelper helper, PresentationStructureView view, DataModelTreeNode root, PopupMenuManager popup) {
        this.rootNode = root;
        this.popupMenuManager = popup;
        this.presentationPanel = presentationPanel;
        this.helper = helper;
        this.view = view;
    }

    public static void refreshNames(DataModelTreeNode treeNode) {
        if (treeNode != null) {
            XFormPresentationXMLObject parentContent;
            treeNode.nodeChanged();
            DataModelTreeNode parent = treeNode;
            while ((parentContent = (parent = (DataModelTreeNode)parent.getParent()).getContent()) instanceof XFormCell || parentContent instanceof XFormRow) {
                parent.nodeChanged();
            }
        }
    }

    public static void addToArray(Field eachField, int indexWhere, XFormXMLObject parentObject, XFormXMLObject childObject, Object[] fieldValue) throws IllegalArgumentException, IllegalAccessException {
        Object newArray = Array.newInstance(eachField.getType().getComponentType(), fieldValue.length + 1);
        if (indexWhere < 0) {
            System.arraycopy(fieldValue, 0, newArray, 0, fieldValue.length);
            Array.set(newArray, fieldValue.length, childObject);
        } else {
            System.arraycopy(fieldValue, 0, newArray, 0, indexWhere);
            System.arraycopy(fieldValue, indexWhere, newArray, indexWhere + 1, fieldValue.length - indexWhere);
            Array.set(newArray, indexWhere, childObject);
        }
        eachField.set(parentObject, newArray);
    }

    public static boolean uniqueViolated(Class c, XFormXMLObject parentObject, String name) {
        boolean uniqueViolated;
        block3: {
            uniqueViolated = false;
            try {
                Field field = c.getField("unique_d");
                String[] vals = (String[])field.get(parentObject);
                if (!DataTree.isUnique(vals, name)) break block3;
                for (String eachVal : vals) {
                    if (name.equals(eachVal) || c.getField(eachVal).get(parentObject) == null) continue;
                    uniqueViolated = true;
                    break;
                }
            }
            catch (Exception e) {
                if (!Log.isDebugging()) break block3;
                Log.logDebug("no unique field found ");
            }
        }
        return uniqueViolated;
    }

    public void setTree(StructureTree structureTree) {
        this.tree = structureTree;
        this.initTree();
    }

    public void createTree(UiContainer container) {
        this.tree = new StructureTree(container);
        this.tree.setRoot(this.rootNode);
        container.setLayout((Layout)new GridLayout(1, 0));
        container.add((UiComponent)this.tree);
        this.initTree();
    }

    public void setCollapse(boolean collapse) {
        this.collapse = collapse;
        this.checkCollapseUnselectedPaths();
    }

    public void setData(XFormPresentationModel presentationModel) {
        this.view.clearIds();
        this.rootNode.setUserObject(presentationModel);
        this.rootNode.dataTree = this;
        this.tree.setRoot(this.rootNode);
        this.tree.setMultipleSelectionPopupProvider(new StructureTree.MultipleSelectionPopupProvider(){

            @Override
            public PopupMenu getPopupMenuForSelection(UiContainer parent, TreePath[] paths) {
                return DataTree.this.getPopUpMenuForSelection(parent, paths);
            }
        });
        this.rootNode.expand();
    }

    public void setData(Object object, DataModelTreeNode parentNode) {
        this.setData(object, parentNode, true);
    }

    public PopupMenu getPopUpMenuForSelection(UiContainer menuParent) {
        return this.getPopUpMenuForSelection(menuParent, this.tree.getSelectionPaths());
    }

    public PopupMenu getPopUpMenuForSelection(UiContainer menuParent, TreePath[] selectionPaths) {
        DataModelTreeNode[] nodes = this.getSelectedNodes(selectionPaths);
        if (nodes == null) {
            return null;
        }
        XFormPresentationXMLObject[] selection = new XFormPresentationXMLObject[nodes.length];
        for (int i = 0; i < selection.length; ++i) {
            selection[i] = nodes[i].getContent();
        }
        this.lastPopup = this.popupMenuManager.fillPopUpMenu(this.lastPopup, menuParent, selection);
        return this.lastPopup;
    }

    public void addChangeListener(ChangeListener clistener) {
        if (this.changeListenerList == null) {
            this.changeListenerList = new ArrayList<ChangeListener>();
        }
        this.changeListenerList.add(clistener);
    }

    public DataModelTreeNode addObject(DataModelTreeNode parent, XFormPresentationXMLObject childObject, int indexWhere, boolean scrollAndSelect) {
        ++this.ignoreNextSelectionEvents;
        return this.internalAddObject(parent, childObject, indexWhere, scrollAndSelect);
    }

    public void moveTreeNode(TreeNode treeNode, boolean up) {
        if (this.hasTree()) {
            TreeNode parent = treeNode.getParent();
            int index = parent.getIndex(treeNode);
            int position = up ? --index : ++index;
            ++this.ignoreNextSelectionEvents;
            this.tree.removeNodeFromParent(treeNode);
            ++this.ignoreNextSelectionEvents;
            this.tree.insertNodeInto(treeNode, parent, position, false);
        }
    }

    public void removeSelectionChangeListener(SelectionChangedListener listener) {
        if (this.selectionChangedListeners != null) {
            this.selectionChangedListeners.remove(listener);
        }
    }

    public void addSelectionChangedListener(SelectionChangedListener listener) {
        assert (listener != null) : "Null selection listener";
        if (this.selectionChangedListeners == null) {
            this.selectionChangedListeners = new ArrayList<SelectionChangedListener>();
        }
        this.selectionChangedListeners.add(listener);
    }

    public void clearTree() {
        this.rootNode.removeAllChildren();
        this.tree.reload();
    }

    public void ensureVisibleSelection() {
        if (this.hasTree()) {
            UiUtilities.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    int[] selectedRows;
                    TreePath path = DataTree.this.tree.getSelectionPath();
                    if (path != null) {
                        DataTree.this.tree.scrollPathToVisible(path);
                    }
                    if ((selectedRows = DataTree.this.tree.getSelectionRows()) != null && selectedRows.length > 0 && selectedRows[0] >= 0) {
                        DataTree.this.tree.scrollRowToVisible(selectedRows[0]);
                    }
                }
            });
        }
    }

    public void recalculateMethods() {
        this.helper.recalculateMethods();
    }

    public void removeCurrentNode() {
        TreeNode currentNode;
        TreeNode parent;
        TreePath currentSelection = this.tree.getSelectionPath();
        if (currentSelection != null && (parent = (currentNode = (TreeNode)currentSelection.getLastPathComponent()).getParent()) != null) {
            currentNode.removeFromParent();
        }
    }

    public void removeSelection(TreeNode node) {
        if (this.tree != null && node != null && node.getParent() != null) {
            this.tree.removeNodeFromParent(node);
        }
    }

    public void requestFocusOn(XFormXMLObject object, boolean innerCompo) {
        this.getPresentationPanel().requestFocusOn(object, innerCompo);
    }

    public void translate() {
        Iterator i$ = this.rootNode.iterator();
        while (i$.hasNext()) {
            TreeNode treeNode = (TreeNode)i$.next();
            treeNode.nodeChanged();
        }
    }

    public DataModelTreeNode getSelectedNode() {
        TreePath currentSelection = this.tree.getSelectionPath();
        DataModelTreeNode result = currentSelection != null ? (DataModelTreeNode)((Object)currentSelection.getLastPathComponent()) : null;
        return result;
    }

    public void clear() {
        TreePath[] currentSelection = this.tree.getSelectionPaths();
        ArrayList<ClearDataCommand> commmands = new ArrayList<ClearDataCommand>();
        for (TreePath treePath : currentSelection) {
            DataModelTreeNode eachNode = (DataModelTreeNode)((Object)treePath.getLastPathComponent());
            List<ClearDataCommand> currentCommmands = this.getClearCommands(eachNode);
            if (currentCommmands == null) continue;
            commmands.addAll(currentCommmands);
        }
        this.executeClear(commmands);
    }

    public boolean isSelected(XFormPresentationXMLObject object) {
        boolean result = false;
        TreeNode node = this.helper.get(object);
        if (node != null) {
            TreePath path = TreePath.create((Object[])node.getPath());
            result = this.tree.isPathSelected(path);
        }
        return result;
    }

    public DataTreeHelper getHelper() {
        return this.helper;
    }

    public XFormXMLObject getSelection() {
        DataModelTreeNode node = this.getSelectedNode();
        return node == null ? null : node.getContent();
    }

    public boolean hasTree() {
        return this.getTree() != null && !this.getTree().isDisposed();
    }

    public TreePath[] getSelectionPaths() {
        return this.getTree().getSelectionPaths();
    }

    public void selectOnTree(TreeNode node, SelectionChangedListener selectionListener, boolean addToSelection) {
        if (this.hasTree()) {
            Tree tree = this.getTree();
            TreePath path = TreePath.create((Object[])node.getPath());
            this.removeSelectionChangeListener(selectionListener);
            if (addToSelection) {
                if (tree.isPathSelected(path) && tree.getSelectionCount() > 1) {
                    tree.removeSelectionPath(path);
                } else {
                    TreePath[] paths = tree.getSelectionPaths();
                    paths = (TreePath[])ArrayUtils.addElement(TreePath.class, paths, path);
                    tree.setSelectionPaths(paths);
                }
            } else {
                node.select();
            }
            this.addSelectionChangedListener(selectionListener);
            tree.expandPath(path);
            tree.scrollPathToVisible(path);
        }
    }

    public void initListeners(Panel treePanel, FormDesignerActions actions) {
        InputMap focusMap = treePanel.getInputMap(1);
        focusMap.put(KeyStroke.getKeyStroke((int)127, (int)0).asSwing(), "DELETE");
        ActionMap dataTreeActionMap = treePanel.getActionMap();
        Tree tree = this.getTree();
        ActionMap treeActionMap = tree.getActionMap();
        ClipBoardActions clipBoardActions = actions.getClipBorardActionManager();
        dataTreeActionMap.put("DELETE", (Action)((Object)clipBoardActions.getClearAction()));
        treeActionMap.put("copy", (Action)clipBoardActions.getCopyAction());
        treeActionMap.put("cut", (Action)clipBoardActions.getCutAction());
        treeActionMap.put("paste", (Action)clipBoardActions.getPasteAction());
    }

    static void addObjectMethods(ObjectTypeDescription otd, String arrayPrefix, Set<String> set, MethodFilter filter) {
        List<MethodTypeDescription> methods = otd.getMethods();
        for (MethodTypeDescription method : methods) {
            String sig;
            if (method.isConstructor() || method.isDeprecated() || Modifier.isHidden(method.getModifiers()) || (sig = method.getSignature()) == null || !filter.accept(method)) continue;
            set.add(arrayPrefix + sig);
        }
    }

    DataModelTreeNode[] getSelectedNodes(TreePath[] currentSelection) {
        DataModelTreeNode[] result;
        if (currentSelection != null) {
            result = new DataModelTreeNode[currentSelection.length];
            for (int i = 0; i < currentSelection.length; ++i) {
                result[i] = (DataModelTreeNode)((Object)currentSelection[i].getLastPathComponent());
            }
        } else {
            result = null;
        }
        return result;
    }

    private static boolean isUnique(String[] vals, String name) {
        boolean isUnique = false;
        for (String val : vals) {
            if (!val.equals(name)) continue;
            isUnique = true;
            break;
        }
        return isUnique;
    }

    private static Comparator<TreeNode> getDefaultComparator() {
        if (defaultNodeComparator == null) {
            defaultNodeComparator = new Comparator<TreeNode>(){

                @Override
                public int compare(TreeNode o1, TreeNode o2) {
                    return 1;
                }
            };
        }
        return defaultNodeComparator;
    }

    private void setData(Object object, DataModelTreeNode parentNode, boolean addIfLoaded) {
        Field[] fields;
        if (object == null) {
            return;
        }
        Class<?> aClass = object.getClass();
        for (Field field : fields = aClass.getFields()) {
            boolean isStatic = java.lang.reflect.Modifier.isStatic(field.getModifiers());
            if (isStatic) continue;
            try {
                Object[] objects;
                if (object instanceof XFormXMLObject) {
                    String fieldName = field.getName();
                    boolean fieldIsId = "id".equals(fieldName) || "id_d".equals(fieldName);
                    XFormXMLObject xFormObject = (XFormXMLObject)object;
                    if (fieldIsId && xFormObject.getName() != null) {
                        String value = (String)field.get(object);
                        String xformName = xFormObject.getName().toLowerCase();
                        if (value != null && value.indexOf(xformName) > -1) {
                            try {
                                int startIndex = value.indexOf(xformName) + xformName.length();
                                String temp = value.substring(startIndex, value.length());
                                this.view.ensureIdFor(xformName, Integer.valueOf(temp));
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                    }
                }
                if (!addIfLoaded && parentNode.isLoaded()) continue;
                if (!field.getType().isArray()) {
                    Object value = field.get(object);
                    if (!(value instanceof XFormPresentationXMLObject) || value instanceof XFormArraybutton) continue;
                    this.addObject(parentNode, (XFormPresentationXMLObject)value);
                    continue;
                }
                if (field.getType().getComponentType().isPrimitive() || (objects = (Object[])field.get(object)) == null) continue;
                for (Object value : objects) {
                    if (!(value instanceof XFormPresentationXMLObject)) continue;
                    this.addObject(parentNode, (XFormPresentationXMLObject)value);
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    private DataModelTreeNode internalAddObject(DataModelTreeNode parent, XFormPresentationXMLObject childObject, int indexWhere, boolean scrollAndSelect) {
        DataModelTreeNode childNode = new DataModelTreeNode(childObject, this.popupMenuManager, this);
        if (parent == null) {
            parent = this.rootNode;
        }
        XFormPresentationXMLObject parentObject = parent.getContent();
        String childId = childNode.getId();
        this.helper.add(childNode);
        boolean done = false;
        if (parentObject != null) {
            Class<?> parentClass = parentObject.getClass();
            Field[] parentFields = parentClass.getFields();
            Class<?> childClass = childObject.getClass();
            for (Field eachparentField : parentFields) {
                if (Modifier.isStatic(eachparentField.getModifiers())) continue;
                try {
                    Class<?> eachFieldType = eachparentField.getType();
                    if (eachFieldType.equals(childClass)) {
                        if (DataTree.uniqueViolated(parentClass, parentObject, eachparentField.getName())) {
                            return null;
                        }
                        this.tree.appendChildInto(childNode, parent, scrollAndSelect);
                        Object parentFieldValue = eachparentField.get(parentObject);
                        if (parentFieldValue == null) {
                            eachparentField.set(parentObject, childObject);
                            this.setData(childObject, childNode, false);
                            done = true;
                        } else {
                            if (!childObject.equals(parentFieldValue)) continue;
                            done = true;
                        }
                    } else {
                        if (!Utilities.isArray(eachparentField, childClass)) continue;
                        Object[] fieldValue = (Object[])eachparentField.get(parentObject);
                        if (fieldValue == null) {
                            fieldValue = (Object[])Array.newInstance(eachFieldType.getComponentType(), 0);
                        }
                        for (Object aFieldValue : fieldValue) {
                            if (!aFieldValue.equals(childObject)) continue;
                            this.tree.insertSortedNode(childNode, parent, DataTree.getDefaultComparator(), false);
                            return childNode;
                        }
                        DataTree.addToArray(eachparentField, indexWhere, parentObject, childObject, fieldValue);
                        int indexToInsert = indexWhere < 0 ? parent.getChildCount() : indexWhere;
                        this.tree.insertNodeInto(childNode, parent, indexToInsert, false);
                        childNode.setUserObject(childObject);
                        done = true;
                    }
                    break;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        } else {
            this.tree.insertNodeInto(childNode, parent, parent.getChildCount(), false);
            done = true;
        }
        if (!done) {
            this.helper.remove(childObject, childId);
        } else {
            this.tree.scrollPathToVisible(TreePath.create((Object[])childNode.getPath()));
        }
        return childNode;
    }

    private Tree getTree() {
        return this.tree;
    }

    private DataModelTreeNode addObject(DataModelTreeNode parent, XFormPresentationXMLObject child) {
        return this.internalAddObject(parent, child, -1, true);
    }

    private void initTree() {
        if (this.hasTree()) {
            this.tree.setRootVisible(false);
            this.tree.addTreeSelectionListener(new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent e) {
                    if (DataTree.this.ignoreNextSelectionEvents == 0) {
                        DataTree.this.tellListenersValueChanged();
                        DataTree.this.checkCollapseUnselectedPaths();
                    } else {
                        --DataTree.this.ignoreNextSelectionEvents;
                    }
                }
            });
            this.tree.setLabelProvider((LabelProvider)new DataNodeLabelProvider());
            this.tree.setSelectionMode(TreeSelectionMode.DISCONTIGUOUS_TREE_SELECTION);
            this.tree.setShowsRootHandles(true);
        }
    }

    private AbstractPresentationEditor getPresentationPanel() {
        return this.presentationPanel;
    }

    private List<ClearDataCommand> getClearCommands(DataModelTreeNode selectedNode) {
        return this.popupMenuManager.getClearCommands(selectedNode.getContent());
    }

    private ArrayList<TreePath> getSortedExpandedPaths() {
        ArrayList l = null;
        Iterator expandedPaths = this.tree.getExpandedDescendants(TreePath.createSinglePath((Object)this.tree.getRoot()));
        if (expandedPaths != null) {
            l = new ArrayList();
            while (expandedPaths.hasNext()) {
                l.add(expandedPaths.next());
            }
            Comparator<TreePath> myComparator = new Comparator<TreePath>(){

                @Override
                public int compare(TreePath t1, TreePath t2) {
                    if (t1.isDescendant(t2)) {
                        return 1;
                    }
                    if (t2.isDescendant(t1)) {
                        return -1;
                    }
                    return DataTree.this.tree.getRowForPath(t1) - DataTree.this.tree.getRowForPath(t2);
                }
            };
            Collections.sort(l, myComparator);
        }
        return l;
    }

    private void checkCollapseUnselectedPaths() {
        if (this.collapse) {
            this.collapseUnselectedPaths();
        }
    }

    private void collapseUnselectedPaths() {
        TreePath[] selectedPaths = this.tree.getSelectionPaths();
        ArrayList<TreePath> expandedPaths = this.getSortedExpandedPaths();
        if (expandedPaths != null) {
            for (TreePath path : expandedPaths) {
                boolean keepOpen = false;
                if (selectedPaths == null) continue;
                for (TreePath eachPath : selectedPaths) {
                    if (!path.isDescendant(eachPath)) continue;
                    keepOpen = true;
                    break;
                }
                if (keepOpen) continue;
                this.tree.collapsePath(path);
            }
        }
    }

    private void executeClear(ArrayList<? extends ClearDataCommand> commands) {
        CompoundCommand compoundCommand = new CompoundCommand(commands, UIMsg.MENU_DELETE);
        CommandManager.invokeCommand(compoundCommand);
        if (this.changeListenerList != null) {
            for (ChangeListener listener : this.changeListenerList) {
                for (ClearDataCommand clearDataCommand : commands) {
                    ChangeListener.ChangeEvent event = ChangeListener.EventFactory.createChange(clearDataCommand.getNodeParent());
                    listener.changeOccured(event);
                }
            }
        }
    }

    private void tellListenersValueChanged() {
        if (this.selectionChangedListeners != null) {
            SelectionChangedListener[] listeners;
            for (SelectionChangedListener listener : listeners = this.selectionChangedListeners.toArray(new SelectionChangedListener[this.selectionChangedListeners.size()])) {
                TreePath[] selectedPaths = this.tree.getSelectionPaths();
                if (selectedPaths == null || selectedPaths.length <= 0) continue;
                Object lastPathComponent = selectedPaths[0].getLastPathComponent();
                if (lastPathComponent instanceof DataModelTreeNode) {
                    XFormPresentationXMLObject selection = ((DataModelTreeNode)((Object)lastPathComponent)).getContent();
                    listener.selectionChanged(selection);
                }
                for (int j = 1; j < selectedPaths.length; ++j) {
                    lastPathComponent = selectedPaths[j].getLastPathComponent();
                    if (!(lastPathComponent instanceof DataModelTreeNode)) continue;
                    XFormPresentationXMLObject selection = ((DataModelTreeNode)((Object)lastPathComponent)).getContent();
                    listener.selectionAdded(selection);
                }
            }
        }
    }

    static {
        defaultFilter = new MethodFilter(){

            @Override
            public boolean accept(MethodTypeDescription mtd) {
                return mtd.getArgumentCount() == 0;
            }
        };
    }

    private static class DataNodeLabelProvider
    extends LabelProvider.Default {
        static final long serialVersionUID = 9007177823288657293L;
        static final long serialCheck = -8613431154563534671L;

        private DataNodeLabelProvider() {
        }

        public Image getIcon(Object element) {
            TreeNode node = (TreeNode)element;
            return node.getIcon();
        }

        public String getText(Object element) {
            DataModelTreeNode node;
            String text = element instanceof DataModelTreeNode ? ((node = (DataModelTreeNode)((Object)element)).getName() != null ? node.getName() : String.valueOf(element)) : String.valueOf(element);
            return text;
        }
    }
}

