/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.outline;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import oracle.bpm.designer.formdesigner.model.ComponentType;
import oracle.bpm.designer.formdesigner.outline.DataTree;
import oracle.bpm.designer.formdesigner.outline.PopupMenuManager;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.log.Log;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.action.ActionGroup;
import oracle.bpm.ui.tree.TreeNode;
import oracle.bpm.xobject.presentationmodel.XFormCell;
import oracle.bpm.xobject.presentationmodel.XFormLabel;
import oracle.bpm.xobject.presentationmodel.XFormLink;
import oracle.bpm.xobject.presentationmodel.XFormPresentation;
import oracle.bpm.xobject.presentationmodel.XFormPresentationModel;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.presentationmodel.XFormRow;
import oracle.bpm.xobject.presentationmodel.XFormValue;
import oracle.bpm.xobject.xml.XFormXMLObject;

public class DataModelTreeNode
extends TreeNode {
    public DataTree dataTree;
    private PopupMenuManager menuManager;
    private Msg msg = null;
    private boolean rootNode = false;
    private XFormPresentationXMLObject xformValue = null;
    private static final XFormPresentationXMLObject ROOT = new XFormPresentationXMLObject(){
        public String id;

        @Override
        public String getName() {
            return "ROOT_NODE";
        }

        @Override
        public int getComponentID() {
            return -1;
        }

        @Override
        public boolean contains(XFormXMLObject object) {
            return false;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public void setId(String id) {
            this.id = id;
        }
    };
    static final long serialVersionUID = -5412122579933084750L;
    static final long serialCheck = 8677717116051427432L;

    public DataModelTreeNode(PopupMenuManager menuManager) {
        this.rootNode = true;
        this.menuManager = menuManager;
        this.setUserObject(ROOT);
    }

    public DataModelTreeNode(XFormPresentationXMLObject xmlObject, PopupMenuManager menuManager, DataTree dataTree) {
        this.xformValue = xmlObject;
        this.menuManager = menuManager;
        this.dataTree = dataTree;
        this.setUserObject(xmlObject);
        this.forceLoad();
    }

    public ActionGroup createActions() {
        return this.menuManager.getActionGroup();
    }

    public XFormPresentationXMLObject getContent() {
        return this.xformValue;
    }

    public Image getIcon() {
        return this.rootNode ? null : (this.getMsg() != null ? Image.create((Msg)this.getMsg()) : null);
    }

    public String getId() {
        String result = this.getUserObject() instanceof XFormPresentationXMLObject ? ((XFormPresentationXMLObject)this.getUserObject()).getId() : null;
        return result;
    }

    public Msg getMsg() {
        if (this.msg == null) {
            Msg msg = null;
            XFormXMLObject userObject = (XFormXMLObject)this.getUserObject();
            if (this.isRoot() || userObject instanceof XFormPresentationModel || userObject instanceof XFormPresentation) {
                msg = DesignerMsg.PRESENTATION;
            } else if (this.getUserObject() instanceof XFormValue) {
                msg = DesignerMsg.VALUE;
            } else if (this.getUserObject() instanceof XFormPresentationXMLObject) {
                ComponentType componentType = ComponentType.get((XFormPresentationXMLObject)this.getUserObject());
                msg = componentType == null ? null : componentType.getMsg();
            }
            this.msg = msg;
        }
        return this.msg;
    }

    public String getName() {
        if (this.isRoot()) {
            return "ROOT_NODE";
        }
        String fullName = "";
        try {
            fullName = (String)this.xformValue.getClass().getField("id").get(this.xformValue);
        }
        catch (Exception e) {
            try {
                fullName = (String)this.xformValue.getClass().getField("id_d").get(this.xformValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (fullName == null || fullName.equals("null")) {
            fullName = "";
        }
        if (this.xformValue instanceof XFormCell || this.xformValue instanceof XFormRow) {
            fullName = fullName + this.getLocalizedName() + " [" + this.getDescription();
            if (this.xformValue instanceof XFormRow) {
                fullName = fullName + "... ";
            }
            fullName = fullName + "]";
        } else {
            fullName = fullName + " (" + this.getLocalizedName() + ")";
        }
        return fullName;
    }

    public String getTooltipText() {
        return null;
    }

    public boolean equals(Object o) {
        if (o instanceof DataModelTreeNode) {
            DataModelTreeNode node = (DataModelTreeNode)((Object)o);
            return node.xformValue == null && this.xformValue == null || node.xformValue != null && node.xformValue.equals(this.xformValue);
        }
        return false;
    }

    public int hashCode() {
        if (this.xformValue != null) {
            return this.xformValue.hashCode();
        }
        return super.hashCode();
    }

    public boolean move(DataModelTreeNode child, boolean up) {
        int actualIndex = this.getIndex(child);
        try {
            int n = actualIndex = up ? actualIndex - 1 : actualIndex + 1;
            if (actualIndex < 0 || actualIndex >= this.getChildCount()) {
                return false;
            }
            this.insert(child, actualIndex);
            this.reflectSwap(child, up, actualIndex);
        }
        catch (Exception e) {
            Log.logWarning(e);
            return false;
        }
        return true;
    }

    protected void onLoading() {
        this.dataTree.setData(this.getUserObject(), this);
    }

    private void forceLoad() {
        this.getChildCount();
    }

    private String getDescription() {
        XFormValue value;
        if (this.xformValue instanceof XFormCell || this.xformValue instanceof XFormRow) {
            if (this.getChildCount() > 0) {
                DataModelTreeNode firstChild = (DataModelTreeNode)this.getChildAt(0);
                return firstChild.getDescription();
            }
        } else if (this.xformValue instanceof XFormLink) {
            String value2 = ((XFormLink)this.xformValue).getTextValue();
            if (value2 != null) {
                return value2;
            }
        } else if (this.xformValue instanceof XFormLabel && (value = ((XFormLabel)this.xformValue).value) != null && value.getValue() != null) {
            return value.getValue();
        }
        try {
            return (String)this.xformValue.getClass().getField("id").get(this.xformValue);
        }
        catch (Exception e) {
            try {
                return (String)this.xformValue.getClass().getField("id_d").get(this.xformValue);
            }
            catch (Exception exception) {
                return "";
            }
        }
    }

    private String getLocalizedName() {
        return this.getMsg() != null ? this.getMsg().getString() : ((XFormXMLObject)this.getUserObject()).getName();
    }

    private void reflectSwap(DataModelTreeNode child, boolean up, int actualIndex) throws Exception {
        Field[] allF = this.xformValue.getClass().getFields();
        for (int i = 0; i < allF.length; ++i) {
            Class<?> eachType = allF[i].getType();
            if (!eachType.isArray() || !eachType.getComponentType().equals(child.getContent().getClass())) continue;
            Object array = allF[i].get(this.xformValue);
            if (Array.getLength(array) <= actualIndex) break;
            Object val = Array.get(array, actualIndex);
            Array.set(array, actualIndex, child.getContent());
            actualIndex = up ? actualIndex + 1 : actualIndex - 1;
            Array.set(array, actualIndex, val);
            break;
        }
    }
}

