/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.model;

import java.beans.PropertyChangeEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.StudioEditor;
import oracle.bpm.designer.catalog.bpmobjects.BPMObjectEditor;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.geom.Dimension;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.project.model.ProjectPreferences;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.event.ListSelectionEvent;
import oracle.bpm.ui.event.ListSelectionListener;
import oracle.bpm.ui.layout.AttributeConstraint;
import oracle.bpm.ui.layout.AttributeType;
import oracle.bpm.ui.layout.BoxLayout;
import oracle.bpm.ui.layout.CardLayout;
import oracle.bpm.ui.layout.Constraint;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.RelativeLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.prop.AbstractProperty;
import oracle.bpm.ui.prop.Property;
import oracle.bpm.ui.prop.PropertyEditor;
import oracle.bpm.ui.prop.PropertyRenderer;
import oracle.bpm.ui.prop.ResetableProperty;
import oracle.bpm.ui.prop.impl.AbstractEditor;
import oracle.bpm.ui.table.AbstractTableModel;
import oracle.bpm.ui.table.Table;
import oracle.bpm.ui.table.TableColumn;
import oracle.bpm.ui.table.TableModel;
import oracle.bpm.ui.table.editors.TableCellEditor;
import oracle.bpm.ui.table.editors.TextFieldCellEditor;
import oracle.bpm.ui.text.TextArea;
import oracle.bpm.ui.text.TextField;

public class TranslatableProperty
extends AbstractProperty
implements ResetableProperty {
    private Map<String, XObjectTypeDescription.ResourceValue> allResources;
    private boolean fire;
    private boolean multilineAllowed;
    private List<ResourcesListener> resourcesListeners;
    private static EditionPanel resourcesView;

    public TranslatableProperty(Msg key, Map<String, XObjectTypeDescription.ResourceValue> allValues, String currentKey) {
        this(key, allValues, currentKey, false);
        this.fire = true;
    }

    public TranslatableProperty(Msg key, Map<String, XObjectTypeDescription.ResourceValue> allValues, String currentKey, boolean multiline) {
        this.allResources = allValues;
        this.setKey(key);
        this.setValue(currentKey);
        this.multilineAllowed = multiline;
        this.setPropertyEditor((PropertyEditor)new TranslatablePropertyEditor());
        this.setPropertyRenderer(new TranslatablePropertyRenderer());
    }

    public static String renderProperty(Property property) {
        String result = "";
        if (property instanceof TranslatableProperty && property.getValue() != null && property.getValue() != NULL_VALUE) {
            TranslatableProperty translatableProperty = (TranslatableProperty)property;
            String key = (String)translatableProperty.getValue();
            LocaleStringMap valueMap = translatableProperty.getMapForKey(key, translatableProperty.multilineAllowed);
            result = TranslatableProperty.renderMap(valueMap, key);
        }
        return result;
    }

    public static String renderMap(LocaleStringMap map, String value) {
        Locale defaultLanguage = TranslatableProperty.getStudioDefaultLocale();
        String result = (String)map.get((Object)defaultLanguage);
        if (result == null || result.equals("")) {
            map.put(defaultLanguage, value);
            result = value;
        }
        return result;
    }

    public static boolean editResources(Msg title, Map<String, XObjectTypeDescription.ResourceValue> allResources) {
        Map<String, XObjectTypeDescription.ResourceValue> editingResources = TranslatableProperty.copyFrom(allResources);
        OkCancelDialog dialog = new OkCancelDialog(Ui.getRoot(), title, true){

            public void ok() {
                resourcesView.stopEditing();
                this.close();
            }
        };
        boolean userOk = OkCancelDialog.doShowDialog((OkCancelDialog)dialog, (UiComponent)(resourcesView = new EditionPanel(dialog.getContentPane(), editingResources)));
        if (userOk) {
            resourcesView.stopEditing();
            allResources.clear();
            TranslatableProperty.copyTo(editingResources, allResources);
        }
        return userOk;
    }

    public void setValue(Object o) {
        super.setValue(o);
        if (this.fire) {
            this.valueChanged();
        }
    }

    public void setFireValueChanged(boolean fire) {
        this.fire = fire;
    }

    public LocaleStringMap getMapForKey(String key, boolean multiline) {
        XObjectTypeDescription.ResourceValue result = this.allResources.get(key);
        if (result == null) {
            result = new XObjectTypeDescription.ResourceValue(multiline ? 1 : 0);
            this.allResources.put(key, result);
        }
        return result.getLocaleMap();
    }

    public boolean reset() {
        this.setValue(NULL_VALUE);
        return true;
    }

    public Object getDefaultValue() {
        return this.getKey();
    }

    public void valueChanged() {
        this.firePropertyChanged(new PropertyChangeEvent((Object)this, this.getKey(), this.getOldValue(), this.getValue()));
    }

    public void updateResources() {
        TranslatablePropertyEditor editor = (TranslatablePropertyEditor)this.getPropertyEditor();
        editor.resourcesUpdated();
    }

    public void addRelatedTranslatable(ResourcesListener property) {
        if (this.resourcesListeners == null) {
            this.resourcesListeners = new ArrayList<ResourcesListener>();
        }
        this.resourcesListeners.add(property);
    }

    protected void fireResourcesUpdated() {
        if (this.resourcesListeners != null) {
            for (ResourcesListener relatedTranslatable : this.resourcesListeners) {
                relatedTranslatable.updateResources();
            }
        }
    }

    private static Locale getStudioDefaultLocale() {
        ProjectPreferences preferences = TranslatableProperty.getProjectPreferences();
        return preferences == null ? Locale.getDefault() : preferences.getDefaultLanguage();
    }

    private static Map<String, XObjectTypeDescription.ResourceValue> copyFrom(Map<String, XObjectTypeDescription.ResourceValue> resources) {
        TreeMap<String, XObjectTypeDescription.ResourceValue> m = new TreeMap<String, XObjectTypeDescription.ResourceValue>();
        TranslatableProperty.copyTo(resources, m);
        return m;
    }

    private static void copyTo(Map<String, XObjectTypeDescription.ResourceValue> from, Map<String, XObjectTypeDescription.ResourceValue> to) {
        for (Map.Entry<String, XObjectTypeDescription.ResourceValue> entry : from.entrySet()) {
            to.put(entry.getKey(), entry.getValue().copy());
        }
    }

    private static ProjectPreferences getProjectPreferences() {
        StudioEditor studioEditor = AbstractStudioWorkbench.getInstance().getSelectedEditor();
        if (studioEditor instanceof BPMObjectEditor) {
            BPMObjectEditor bpmObjectEditor = (BPMObjectEditor)studioEditor;
            return bpmObjectEditor.getProject().getPreferences();
        }
        return null;
    }

    private static class EditionPanel
    extends Panel {
        private Map<String, XObjectTypeDescription.ResourceValue> editingResources;
        private ArrayList<String> list;
        private Table resourcesTable;

        public EditionPanel(UiContainer parent, Map<String, XObjectTypeDescription.ResourceValue> editingResources) {
            super(parent);
            this.editingResources = editingResources;
            this.list = new ArrayList<String>(editingResources.keySet());
            this.initUI();
        }

        public void stopEditing() {
            this.resourcesTable.getColumn(1).getCellEditor().stopCellEditing();
        }

        public Dimension getPreferredSize() {
            return Dimension.valueOf(400, 200);
        }

        private void initUI() {
            final AbstractTableModel model = new AbstractTableModel(){
                private List<Locale> languages = null;

                public String getColumnName(int column) {
                    String result;
                    switch (column) {
                        case 0: {
                            result = " ";
                            break;
                        }
                        case 1: {
                            result = "Default";
                            break;
                        }
                        default: {
                            Locale lang = this.getLanguage(column);
                            result = lang.getDisplayName();
                        }
                    }
                    return result;
                }

                public boolean isCellEditable(int rowIndex, int columnIndex) {
                    return columnIndex > 1;
                }

                public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                    if (columnIndex > 1 && rowIndex < EditionPanel.this.list.size()) {
                        LocaleStringMap languageMap = ((XObjectTypeDescription.ResourceValue)EditionPanel.this.editingResources.get(EditionPanel.this.list.get(rowIndex))).getLocaleMap();
                        languageMap.put(this.getLanguage(columnIndex), String.valueOf(aValue));
                    }
                }

                private List<Locale> getLanguages() {
                    if (this.languages == null) {
                        ProjectPreferences preferences = TranslatableProperty.getProjectPreferences();
                        this.languages = preferences == null ? new ArrayList() : preferences.getAvailableLanguages();
                    }
                    return this.languages;
                }

                private Locale getLanguage(int column) {
                    return this.getLanguages().get(column - 2);
                }

                public int getColumnCount() {
                    return this.getLanguages().size() + 2;
                }

                public int getRowCount() {
                    return EditionPanel.this.list.size();
                }

                public Class getColumnClass(int columnIndex) {
                    return columnIndex == 0 ? Integer.class : String.class;
                }

                public Object getValueAt(int rowIndex, int columnIndex) {
                    String key = (String)EditionPanel.this.list.get(rowIndex);
                    if (columnIndex == 1) {
                        return key;
                    }
                    XObjectTypeDescription.ResourceValue resourceValue = (XObjectTypeDescription.ResourceValue)EditionPanel.this.editingResources.get(key);
                    if (columnIndex == 0) {
                        return new Integer(resourceValue.getType());
                    }
                    LocaleStringMap languageMap = resourceValue.getLocaleMap();
                    String result = (String)languageMap.get((Object)this.getLanguage(columnIndex));
                    return result == null ? "" : result;
                }
            };
            this.resourcesTable = new Table((UiContainer)this, (TableModel)model);
            TextFieldCellEditor multilineEditor = new TextFieldCellEditor();
            TableColumn column = this.resourcesTable.getColumn(1);
            column.setWidth(25);
            column.setCellEditor((TableCellEditor)multilineEditor);
            this.resourcesTable.setDefaultEditor(String.class, (TableCellEditor)multilineEditor);
            this.resourcesTable.setDefaultLabelProvider(Integer.class, (LabelProvider)new LabelProvider<Integer>(){

                public Image getIcon(Integer element) {
                    if (element != null) {
                        URL iconUrl;
                        URL uRL = iconUrl = element == 1 ? DesignerMsg.MULTILINETEXT.getImageResource() : DesignerMsg.TEXT.getImageResource();
                        if (iconUrl != null) {
                            return Image.create((URL)iconUrl);
                        }
                    }
                    return null;
                }

                public String getText(Integer element) {
                    return "";
                }
            });
            ToolBar toolbar = new ToolBar((UiContainer)this, ToolBar.VERTICAL);
            DesignerAction addAction = new DesignerAction(DesignerMsg.ADD){
                private CheckBox multilineCheck;
                private TextArea multiline;
                private TextField textField;

                public void actionPerformed(ActionEvent event) {
                    Panel content;
                    OkCancelDialog dialog = new OkCancelDialog(Ui.getRoot(), DesignerMsg.ENTER_RESOURCE_NAME, true){

                        public void ok() {
                            String resourceName;
                            String string = resourceName = multilineCheck.isSelected() ? multiline.getText() : textField.getText();
                            if (resourceName.trim().equals("")) {
                                MessageDialog.showError((Msg)DesignerMsg.RESOURCE_EMPTY);
                            } else if (EditionPanel.this.editingResources.containsKey(resourceName)) {
                                MessageDialog.showError((Msg)DesignerMsg.RESOURCE_EXISTS);
                            } else {
                                this.close();
                            }
                        }
                    };
                    boolean result = OkCancelDialog.doShowDialog((OkCancelDialog)dialog, (UiComponent)(content = this.createEnterResourceContent(dialog.getContentPane())));
                    if (result) {
                        String resourceName = this.multilineCheck.isSelected() ? this.multiline.getText() : this.textField.getText();
                        XObjectTypeDescription.ResourceValue value = new XObjectTypeDescription.ResourceValue(this.multilineCheck.isSelected() ? 1 : 0);
                        LocaleStringMap map = value.getLocaleMap();
                        map.put(TranslatableProperty.getStudioDefaultLocale(), resourceName);
                        EditionPanel.this.editingResources.put(resourceName, value);
                        EditionPanel.this.list = new ArrayList(EditionPanel.this.editingResources.keySet());
                        model.fireTableRowsInserted(EditionPanel.this.list.size() - 1, EditionPanel.this.list.size() - 1);
                    }
                }

                private Panel createEnterResourceContent(UiContainer parent) {
                    Panel content = new Panel(parent);
                    content.setLayout((Layout)new FormLayout("5dlu, pref, 5dlu, pref:grow, 5dlu", "5dlu, pref, 5dlu, top:pref, 5dlu:grow"));
                    CellConstraints cc = new CellConstraints();
                    this.multilineCheck = new CheckBox((UiContainer)content);
                    content.add((UiComponent)Label.create((UiContainer)content, (Msg)DesignerMsg.MULTILINE_RESOURCE), (Object)cc.xy(2, 2));
                    content.add((UiComponent)this.multilineCheck, (Object)cc.xy(4, 2));
                    final CardLayout cardLayout = new CardLayout();
                    final Panel card = new Panel((UiContainer)content);
                    card.setLayout((Layout)cardLayout);
                    Panel textFieldPanel = new Panel((UiContainer)card);
                    textFieldPanel.setLayout((Layout)new BoxLayout((UiContainer)textFieldPanel, 0));
                    this.textField = new TextField((UiContainer)textFieldPanel, 20);
                    this.textField.setMaximumSize(Dimension.valueOf(this.textField.getMaximumSize().getWidth(), this.textField.getPreferredSize().getHeight()));
                    textFieldPanel.add((UiComponent)this.textField);
                    card.add((UiComponent)textFieldPanel, (Object)"textField");
                    this.multiline = new TextArea((UiContainer)card);
                    this.multiline.setRows(3);
                    this.multiline.setColumns(20);
                    card.add((UiComponent)this.multiline, (Object)"multiline");
                    cardLayout.show((UiContainer)card, "textField");
                    this.multilineCheck.addItemListener(new ItemListener(){

                        public void itemStateChanged(ItemEvent e) {
                            cardLayout.show((UiContainer)card, multilineCheck.isSelected() ? "multiline" : "textField");
                        }
                    });
                    content.add((UiComponent)Label.create((UiContainer)content, (Msg)DesignerMsg.RESOURCE_TEXT), (Object)cc.xy(2, 4));
                    content.add((UiComponent)card, (Object)cc.xy(4, 4));
                    return content;
                }
            };
            final BaseAction removeAction = new BaseAction(DesignerMsg.REMOVE){

                public void actionPerformed(ActionEvent event) {
                    int[] rowIndex = EditionPanel.this.resourcesTable.getSelectedRows();
                    for (int i = rowIndex.length - 1; i >= 0; --i) {
                        int eachRowIndex = rowIndex[i];
                        String key = (String)EditionPanel.this.list.get(eachRowIndex);
                        EditionPanel.this.editingResources.remove(key);
                        EditionPanel.this.list.remove(eachRowIndex);
                        model.fireTableRowsDeleted(eachRowIndex, eachRowIndex);
                    }
                    if (rowIndex.length > 0) {
                        int firstIndex = rowIndex[0];
                        if (EditionPanel.this.list.size() > firstIndex) {
                            EditionPanel.this.resourcesTable.addRowSelectionInterval(firstIndex, firstIndex);
                        } else if (EditionPanel.this.list.size() > firstIndex - 1) {
                            EditionPanel.this.resourcesTable.addRowSelectionInterval(firstIndex - 1, firstIndex - 1);
                        }
                    }
                }
            };
            removeAction.setEnabled(false);
            this.resourcesTable.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    removeAction.setEnabled(EditionPanel.this.resourcesTable.getSelectedRows().length > 0);
                }
            });
            toolbar.add((BaseAction)addAction);
            toolbar.add(removeAction);
            this.setLayout((Layout)new BorderLayout());
            this.add((UiComponent)this.resourcesTable, "Center");
            this.add((UiComponent)toolbar, "East");
        }
    }

    static class TranslatablePropertyRenderer
    implements PropertyRenderer {
        TranslatablePropertyRenderer() {
        }

        public String getRenderer(Property property) {
            return TranslatableProperty.renderProperty(property);
        }

        public String getToolTip(Property property) {
            return TranslatableProperty.renderProperty(property);
        }
    }

    public class TranslatablePropertyEditor
    extends AbstractEditor {
        private ComboBox<String> field;
        private Panel mainPanel;

        public Object getCellEditorValue() {
            return this.field.getSelectedItem();
        }

        protected UiComponent getEditor(UiContainer parent) {
            if (this.mainPanel == null) {
                this.buildUi(parent);
            }
            return this.mainPanel;
        }

        protected void resourcesUpdated() {
            Object selection = this.field.getSelectedItem();
            this.field.removeAllItems();
            for (String s : TranslatableProperty.this.allResources.keySet()) {
                this.field.addItem((Object)s);
            }
            this.field.setSelectedItem(selection);
        }

        private void buildUi(UiContainer parent) {
            this.mainPanel = new Panel(parent);
            RelativeLayout layout = new RelativeLayout();
            this.mainPanel.setLayout((Layout)layout);
            this.mainPanel.setOpaque(false);
            this.mainPanel.setBorder(null);
            Set values = TranslatableProperty.this.allResources.keySet();
            this.field = UiFactory.createComboBox((UiContainer)this.mainPanel, (boolean)true, (Object[])values.toArray(new String[values.size()]));
            this.field.setBorder(null);
            this.field.setLabelProvider((LabelProvider)new LabelProvider.Default<String>(){

                public String getText(String element) {
                    LocaleStringMap resources = TranslatableProperty.this.getMapForKey(element, ((TranslatableProperty)TranslatablePropertyEditor.this.getProperty()).multilineAllowed);
                    String str = TranslatableProperty.renderMap(resources, element);
                    return Str.strip(str, 80);
                }
            });
            this.field.setOpaque(false);
            this.field.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    String resourceName = (String)TranslatablePropertyEditor.this.field.getSelectedItem();
                    if (resourceName != null) {
                        boolean multiline = ((TranslatableProperty)TranslatablePropertyEditor.this.getProperty()).multilineAllowed;
                        XObjectTypeDescription.ResourceValue value = (XObjectTypeDescription.ResourceValue)TranslatableProperty.this.allResources.get(resourceName);
                        if (value == null) {
                            value = new XObjectTypeDescription.ResourceValue(multiline ? 1 : 0);
                            TranslatableProperty.this.allResources.put(resourceName, value);
                        }
                        if (value.getLocaleMap().get((Object)TranslatableProperty.getStudioDefaultLocale()) == null) {
                            value.getLocaleMap().put(TranslatableProperty.getStudioDefaultLocale(), resourceName);
                        }
                        TranslatablePropertyEditor.this.getProperty().setValue((Object)resourceName);
                        TranslatablePropertyEditor.this.getProperty().valueChanged();
                    }
                }
            });
            Button triggerButton = new Button((UiContainer)this.mainPanel, UIMsg.TO_MSG((String)"..."));
            triggerButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (TranslatablePropertyEditor.this.showDialog()) {
                        Object selection = TranslatablePropertyEditor.this.field.getSelectedItem();
                        TranslatablePropertyEditor.this.field.removeAllItems();
                        for (String s : TranslatableProperty.this.allResources.keySet()) {
                            TranslatablePropertyEditor.this.field.addItem((Object)s);
                        }
                        TranslatablePropertyEditor.this.field.setSelectedItem(selection);
                        TranslatableProperty.this.firePropertyChanged(new PropertyChangeEvent((Object)TranslatableProperty.this, TranslatableProperty.this.getKey(), selection, selection));
                    }
                }
            });
            triggerButton.setDefaultCapable(false);
            triggerButton.setFocusPainted(false);
            this.mainPanel.add(this.field, (Object)"field");
            this.mainPanel.add((UiComponent)triggerButton, (Object)"button");
            this.layoutComponents(layout);
            if (this.getProperty() != null) {
                this.field.setSelectedItem(this.getProperty().getValue());
            }
        }

        private boolean showDialog() {
            return TranslatableProperty.editResources(DesignerMsg.FUEGOOBJECT_RESOURCES, TranslatableProperty.this.allResources);
        }

        private void layoutComponents(RelativeLayout layout) {
            layout.addConstraint("button", AttributeType.RIGHT, (Constraint)new AttributeConstraint("_container", AttributeType.RIGHT, -1));
            layout.addConstraint("button", AttributeType.TOP, (Constraint)new AttributeConstraint("_container", AttributeType.TOP));
            layout.addConstraint("button", AttributeType.BOTTOM, (Constraint)new AttributeConstraint("_container", AttributeType.BOTTOM));
            layout.addConstraint("button", AttributeType.WIDTH, (Constraint)new AttributeConstraint("_container", AttributeType.HEIGHT));
            layout.addConstraint("field", AttributeType.TOP, (Constraint)new AttributeConstraint("_container", AttributeType.TOP));
            layout.addConstraint("field", AttributeType.BOTTOM, (Constraint)new AttributeConstraint("_container", AttributeType.BOTTOM));
            layout.addConstraint("field", AttributeType.RIGHT, (Constraint)new AttributeConstraint("button", AttributeType.LEFT, -1));
            layout.addConstraint("field", AttributeType.LEFT, (Constraint)new AttributeConstraint("_container", AttributeType.LEFT, 1));
        }
    }

    public static interface ResourcesListener {
        public void updateResources();
    }
}

