/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.model;

import oracle.bpm.resources.Msg;
import oracle.bpm.webformdesigner.msg.WebformdesignerMsg;
import oracle.bpm.xobject.presentationmodel.XFormButton;
import oracle.bpm.xobject.presentationmodel.XFormCell;
import oracle.bpm.xobject.presentationmodel.XFormComponentType;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.presentationmodel.XFormRow;
import oracle.bpm.xobject.presentationmodel.XFormTable;
import oracle.bpm.xobject.presentationmodel.XFormText;
import oracle.bpm.xobject.xml.XFormXMLObject;

public enum ComponentType {
    COMBO(XFormComponentType.COMBO, WebformdesignerMsg.COMBO),
    CHECK(XFormComponentType.CHECK, WebformdesignerMsg.CHECK),
    BUTTON(XFormComponentType.ACTION_BUTTON, WebformdesignerMsg.CUSTOM_BUTTON),
    CANCEL_BUTTON(XFormComponentType.CANCEL_BUTTON, WebformdesignerMsg.CANCEL_BUTTON),
    SAVE_BUTTON(XFormComponentType.SAVE_BUTTON, WebformdesignerMsg.SAVE_BUTTON),
    SUBMIT_BUTTON(XFormComponentType.SUBMIT_BUTTON, WebformdesignerMsg.SUBMIT_BUTTON),
    REFRESH_BUTTON(XFormComponentType.REFRESH_BUTTON, WebformdesignerMsg.REFRESH_BUTTON),
    RESET_BUTTON(XFormComponentType.RESET_BUTTON, WebformdesignerMsg.RESET_BUTTON),
    PRINT_BUTTON(XFormComponentType.PRINT_BUTTON, WebformdesignerMsg.PRINT_BUTTON),
    CELL(XFormComponentType.CELL, WebformdesignerMsg.CELL){

        @Override
        public Class requires() {
            return XFormRow.class;
        }
    }
    ,
    DATETIMEPIKER(XFormComponentType.DATETIMEPIKER, WebformdesignerMsg.DATETIMEPICKER),
    IMAGE(XFormComponentType.IMAGE, WebformdesignerMsg.IMAGE),
    INTERVAL(XFormComponentType.INTERVAL, WebformdesignerMsg.INTERVAL),
    LABEL(XFormComponentType.LABEL, WebformdesignerMsg.LABEL),
    MULTILINETEXT(XFormComponentType.MULTILINE, WebformdesignerMsg.MULTILINETEXT),
    RADIO(XFormComponentType.RADIO, WebformdesignerMsg.RADIO),
    ROW(XFormComponentType.ROW, WebformdesignerMsg.ROW){

        @Override
        public Class requires() {
            return XFormTable.class;
        }
    }
    ,
    TABLE(XFormComponentType.TABLE, WebformdesignerMsg.TABLE){

        @Override
        public boolean canAddIn(int componentID) {
            return 15 != componentID;
        }
    }
    ,
    TEXT(XFormComponentType.TEXT, WebformdesignerMsg.TEXT),
    PASSWORD(XFormComponentType.PASSWORD, WebformdesignerMsg.PASSWORD_FIELD),
    ARRAY(XFormComponentType.ARRAY, WebformdesignerMsg.ARRAY){

        @Override
        public boolean canAddIn(int componentID) {
            return 15 != componentID && 18 != componentID;
        }
    }
    ,
    REPEATABLESECTION(XFormComponentType.REPEATABLESECTION, WebformdesignerMsg.REPEATABLESECTION){

        @Override
        public boolean canAddIn(int componentID) {
            return 15 != componentID && 18 != componentID;
        }
    }
    ,
    GAUGE(XFormComponentType.GAUGE, WebformdesignerMsg.GAUGE){

        @Override
        public boolean canAddIn(int componentID) {
            return 15 != componentID && 18 != componentID;
        }
    }
    ,
    PIE(XFormComponentType.PIE, WebformdesignerMsg.PIE){

        @Override
        public boolean canAddIn(int componentID) {
            return 15 != componentID && 18 != componentID;
        }
    }
    ,
    CHART(XFormComponentType.CHART, WebformdesignerMsg.CHART){

        @Override
        public boolean canAddIn(int componentID) {
            return 15 != componentID && 18 != componentID;
        }
    }
    ,
    LINK(XFormComponentType.LINK, WebformdesignerMsg.LINK),
    IFRAME(XFormComponentType.IFRAME, WebformdesignerMsg.IFRAME),
    PRESENTATION(XFormComponentType.PRESENTATION, WebformdesignerMsg.PRESENTATION);

    private XFormComponentType type;
    private Msg msg;

    private ComponentType(XFormComponentType type, Msg msg) {
        this.type = type;
        this.msg = msg;
    }

    public Msg getMsg() {
        return this.msg;
    }

    public Class requires() {
        return XFormCell.class;
    }

    public XFormXMLObject createInstance() {
        return this.type.createInstance();
    }

    public boolean canAddIn(int componentID) {
        return true;
    }

    public XFormComponentType getType() {
        return this.type;
    }

    public static ComponentType get(int type) {
        for (ComponentType componentType : ComponentType.values()) {
            if (componentType.type.getType() != type) continue;
            return componentType;
        }
        return null;
    }

    public static ComponentType get(XFormPresentationXMLObject object) {
        ComponentType type = ComponentType.get(object.getComponentID());
        if (type == TEXT) {
            if (((XFormText)object).isPasswordField()) {
                type = PASSWORD;
            }
        } else if (type == BUTTON) {
            String action = ((XFormButton)object).getAction();
            if (action.equals(XFormButton.possibleAction_d[0])) {
                type = SUBMIT_BUTTON;
            } else if (action.equals(XFormButton.possibleAction_d[1])) {
                type = CANCEL_BUTTON;
            } else if (action.equals(XFormButton.possibleAction_d[2])) {
                type = RESET_BUTTON;
            } else if (action.equals(XFormButton.possibleAction_d[3])) {
                type = REFRESH_BUTTON;
            } else if (action.equals(XFormButton.possibleAction_d[5])) {
                type = SAVE_BUTTON;
            } else if (action.equals(XFormButton.possibleAction_d[6])) {
                type = PRINT_BUTTON;
            }
        }
        return type;
    }

    public static boolean isGroup(ComponentType type) {
        return type == REPEATABLESECTION || type == ARRAY;
    }

    public static boolean isGraphic(ComponentType type) {
        return type == CHART || type == PIE || type == GAUGE;
    }
}

