/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.editors;

import java.util.List;
import oracle.bpm.designer.formdesigner.ChangeListener;
import oracle.bpm.designer.formdesigner.components.PresentationComponent;
import oracle.bpm.designer.formdesigner.components.PresentationRow;
import oracle.bpm.designer.formdesigner.components.PresentationTable;
import oracle.bpm.designer.formdesigner.editors.AbstractComponentEditor;
import oracle.bpm.designer.formdesigner.editors.EditorData;
import oracle.bpm.designer.formdesigner.editors.EditorRegistry;
import oracle.bpm.designer.formdesigner.editors.RowComponentEditor;
import oracle.bpm.designer.formdesigner.properties.ComponentInteractionProvider;
import oracle.bpm.designer.formdesigner.properties.ComponentProperties;
import oracle.bpm.designer.formdesigner.properties.TableComponentProperties;
import oracle.bpm.geom.Insets;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.GridBagConstraints;
import oracle.bpm.ui.layout.GridBagLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.presentationmodel.XFormRow;
import oracle.bpm.xobject.presentationmodel.XFormTable;

class TableComponentEditor
extends AbstractComponentEditor {
    private EditorRegistry registry;
    static int defaultWidth = 100;

    public TableComponentEditor(EditorRegistry registry) {
        this.registry = registry;
    }

    @Override
    public UiComponent init(Panel containerPanel, XFormPresentationXMLObject presentationObject, PresentationComponent changedComponent, EditorData editorData) {
        int i;
        Panel container = changedComponent.getContainer();
        PresentationComponent uiChangedComponent = changedComponent;
        container.invalidate();
        List components = container.getComponents();
        boolean found = false;
        for (UiComponent component : components) {
            if (component != uiChangedComponent) {
                container.remove(component);
                continue;
            }
            found = true;
        }
        PresentationTable pres = (PresentationTable)changedComponent;
        XFormTable t = (XFormTable)presentationObject;
        boolean topLevel = this.isTopLevelTable(t, editorData);
        String width = t.width;
        int realWidth = defaultWidth;
        int cellpadding = t.cellpadding + 1;
        int cellspacing = t.cellspacing + 1;
        pres.restartOcupied();
        pres.setBackground(containerPanel.getBackground());
        pres.setForeground(containerPanel.getForeground());
        pres.setFont(containerPanel.getFont());
        topLevel = false;
        if (topLevel) {
            try {
                realWidth = Integer.parseInt(width);
            }
            catch (Exception e) {
                realWidth = defaultWidth;
            }
            if (realWidth > 0) {
                Panel fillPanel;
                String alignment = t.alignment;
                int align = -1;
                if (alignment != null) {
                    if (alignment.equals("left")) {
                        align = 17;
                    } else if (alignment.equals("center")) {
                        align = 10;
                    } else if (alignment.equals("right")) {
                        align = 13;
                    }
                }
                GridBagConstraints constraints = new GridBagConstraints();
                GridBagLayout grid = new GridBagLayout();
                constraints.insets = new Insets(cellspacing, cellspacing, cellspacing, cellspacing);
                constraints.ipadx = cellpadding;
                constraints.ipady = cellpadding;
                containerPanel.setLayout((Layout)grid);
                int left = 100 - realWidth;
                int used = 0;
                constraints.fill = 1;
                constraints.weightx = 1.0;
                if (realWidth > 0 && (used = align == 17 ? 0 : (align == 13 ? left : left / 2)) > 0) {
                    constraints.gridwidth = Math.min(used, 512);
                    constraints.weightx = (double)used / 100.0;
                    fillPanel = new Panel((UiContainer)containerPanel);
                    fillPanel.setBackground(containerPanel.getBackground());
                    containerPanel.add((UiComponent)fillPanel, (Object)constraints);
                }
                if (align > 0) {
                    constraints.anchor = align;
                }
                if (realWidth > 0) {
                    constraints.gridwidth = Math.min(realWidth, 512);
                    constraints.weightx = (double)realWidth / 100.0;
                }
                containerPanel.add((UiComponent)pres, (Object)constraints);
                if (realWidth > 0 && left - used > 0) {
                    fillPanel = new Panel((UiContainer)containerPanel);
                    constraints.gridwidth = Math.min(left - used, 512);
                    constraints.weightx = (double)(left - used) / 100.0;
                    fillPanel.setBackground(containerPanel.getBackground());
                    containerPanel.add((UiComponent)fillPanel, (Object)constraints);
                }
            } else {
                containerPanel.setLayout((Layout)new BorderLayout());
                if (!found) {
                    containerPanel.add((UiComponent)pres, (Object)"Center");
                } else {
                    pres.setLayoutData("Center");
                }
            }
        } else if (!found) {
            containerPanel.add((UiComponent)pres);
        }
        boolean border = t.border;
        pres.setShowBorder(border);
        pres.setShowLines(editorData.showLines());
        XFormRow[] rows = t.row;
        String colSpec = cellspacing + "dlu";
        String rowSpec = cellspacing + "dlu";
        int columnCount = t.getModelTotalColumns();
        int rowCount = rows.length;
        for (i = 0; i < columnCount; ++i) {
            colSpec = colSpec + ",fill:pref:grow," + cellspacing + "dlu";
        }
        for (i = 0; i < rowCount; ++i) {
            rowSpec = rowSpec + ",fill:pref:grow," + cellspacing + "dlu";
        }
        FormLayout form = new FormLayout(colSpec, rowSpec);
        pres.setLayout((Layout)form);
        CellConstraints cc = form.createCellConstraints();
        for (int i2 = 0; i2 < rows.length; ++i2) {
            RowComponentEditor.RowEditorData rowEditorData;
            RowComponentEditor rowEditor;
            PresentationRow presentationRow;
            if (rows[i2] == null || (presentationRow = (rowEditor = (RowComponentEditor)this.registry.getEditorFor(10)).init(pres, rows[i2], editorData, rowEditorData = new RowComponentEditor.RowEditorData(cc, border, t.getModelTotalColumnWidth(), i2, false))).getContainerTable() == pres) continue;
            presentationRow.setContainerTable(pres);
        }
        return pres;
    }

    @Override
    public UiComponent init(PresentationComponent changedComponent, XFormPresentationXMLObject existingComponent, EditorData editorData) {
        PresentationTable pres = new PresentationTable((UiContainer)changedComponent, existingComponent, editorData.showLines(), editorData.showImages(), editorData.getListener());
        return this.doInit(changedComponent, existingComponent, editorData, (PresentationComponent)pres);
    }

    @Override
    public ComponentProperties createProperties(XFormPresentationXMLObject referencedObject, ComponentInteractionProvider componentInteractionProvider, ChangeListener listener) {
        return new TableComponentProperties(referencedObject, componentInteractionProvider, listener);
    }

    private boolean isTopLevelTable(XFormTable table, EditorData editorData) {
        return editorData.getPresentation().table == table;
    }
}

