/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.editors;

import oracle.bpm.designer.formdesigner.ChangeListener;
import oracle.bpm.designer.formdesigner.components.PresentationComponent;
import oracle.bpm.designer.formdesigner.components.PresentationRow;
import oracle.bpm.designer.formdesigner.editors.AbstractComponentEditor;
import oracle.bpm.designer.formdesigner.editors.CellComponentEditor;
import oracle.bpm.designer.formdesigner.editors.EditorData;
import oracle.bpm.designer.formdesigner.editors.EditorRegistry;
import oracle.bpm.designer.formdesigner.properties.ComponentInteractionProvider;
import oracle.bpm.designer.formdesigner.properties.ComponentProperties;
import oracle.bpm.designer.formdesigner.properties.RowComponentProperties;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.xobject.presentationmodel.XFormCell;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.presentationmodel.XFormRow;

class RowComponentEditor
extends AbstractComponentEditor {
    private final EditorRegistry registry;
    private RowEditorData rowEditorData;

    public RowComponentEditor(EditorRegistry registry) {
        this.registry = registry;
    }

    @Override
    public UiComponent init(PresentationComponent changedComponent, XFormPresentationXMLObject existingComponent, EditorData editorData) {
        PresentationRow row = new PresentationRow((UiContainer)changedComponent, existingComponent, editorData.showLines(), editorData.showImages(), editorData.getListener());
        return this.doInit(changedComponent, existingComponent, editorData, (PresentationComponent)row);
    }

    @Override
    public UiComponent init(Panel container, XFormPresentationXMLObject presentationObject, PresentationComponent changedComponent, EditorData editorData) {
        RowEditorData rowEditorData = this.rowEditorData;
        CellConstraints constraints = rowEditorData.getConstraints();
        XFormCell[] cells = ((XFormRow)presentationObject).cell;
        PresentationRow presRow = (PresentationRow)changedComponent;
        PresentationComponent containerTable = presRow.getContainerTable();
        int y = (rowEditorData.getIndex() + 1) * 2;
        container.add((UiComponent)presRow, (Object)constraints.xy(1, y));
        if (cells != null) {
            CellComponentEditor cellEditor = (CellComponentEditor)this.registry.getEditorFor(3);
            for (int i = 0; i < cells.length; ++i) {
                int width = cells[i].hexpand == 0 ? 1 : cells[i].hexpand;
                width = width * 2 - 1;
                int x = 2 * (presRow.getNextIndex(i, rowEditorData.getIndex(), cells[i]) + 1);
                CellComponentEditor.CellEditorData cellEditorData = new CellComponentEditor.CellEditorData(rowEditorData.isInArray(), constraints);
                PresentationComponent cell = cellEditor.init(containerTable, cells[i], editorData, cellEditorData);
                cell.setShowBorder(rowEditorData.isBorder());
                cell.setShowLines(editorData.showLines());
                container.add((UiComponent)cell, (Object)constraints.xyw(x, y, width));
            }
        }
        return presRow;
    }

    public synchronized PresentationRow init(PresentationComponent pres, XFormRow row, EditorData editorData, RowEditorData rowEditorData) {
        this.setEditorData(rowEditorData);
        PresentationRow result = (PresentationRow)this.init(pres, row, editorData);
        this.setEditorData(null);
        return result;
    }

    @Override
    public ComponentProperties createProperties(XFormPresentationXMLObject referencedObject, ComponentInteractionProvider componentInteractionProvider, ChangeListener listener) {
        return new RowComponentProperties(referencedObject, componentInteractionProvider, listener);
    }

    private void setEditorData(RowEditorData rowEditorData) {
        this.rowEditorData = rowEditorData;
    }

    public static class RowEditorData {
        private boolean border = false;
        private int columnCount = 1;
        private CellConstraints constraints = null;
        private int index = 1;
        private boolean isInArray = false;

        public RowEditorData(CellConstraints constraints, boolean border, int columnCount, int index, boolean isInArray) {
            this.constraints = constraints;
            this.border = border;
            this.columnCount = columnCount;
            this.index = index;
            this.isInArray = isInArray;
        }

        public boolean isInArray() {
            return this.isInArray;
        }

        public void setInArray(boolean isInArray) {
            this.isInArray = isInArray;
        }

        public int getColumnCount() {
            return this.columnCount;
        }

        public void setColumnCount(int columnCount) {
            this.columnCount = columnCount;
        }

        public CellConstraints getConstraints() {
            return this.constraints;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public void setBorder(boolean border) {
            this.border = border;
        }

        public boolean isBorder() {
            return this.border;
        }
    }
}

