/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.editors;

import oracle.bpm.designer.formdesigner.ChangeListener;
import oracle.bpm.designer.formdesigner.EventListener;
import oracle.bpm.designer.formdesigner.components.PresentationComponent;
import oracle.bpm.designer.formdesigner.components.PresentationImage;
import oracle.bpm.designer.formdesigner.editors.DefaultComponentEditor;
import oracle.bpm.designer.formdesigner.editors.EditorData;
import oracle.bpm.designer.formdesigner.properties.ComponentInteractionProvider;
import oracle.bpm.designer.formdesigner.properties.ComponentProperties;
import oracle.bpm.designer.formdesigner.properties.ImageComponentProperties;
import oracle.bpm.geom.Dimension;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.xobject.presentationmodel.XFormImage;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;

class ImageComponentEditor
extends DefaultComponentEditor {
    ImageComponentEditor() {
    }

    public UiComponent init(PresentationComponent container, XFormPresentationXMLObject presentationObject, PresentationComponent changedComponent, EditorData editorData) {
        PresentationImage result = (PresentationImage)super.init(container, presentationObject, changedComponent, editorData);
        XFormImage image = (XFormImage)presentationObject;
        if (!(editorData.showImages() || image.height == null && image.width == null)) {
            int w;
            int h;
            Dimension dim = result.getComponent().getPreferredSize();
            try {
                h = image.height != null ? Double.valueOf(image.height).intValue() : dim.getHeight();
            }
            catch (NumberFormatException nfe) {
                h = dim.getHeight();
            }
            try {
                w = image.width != null ? Double.valueOf(image.width).intValue() : dim.getWidth();
            }
            catch (NumberFormatException nfe) {
                w = dim.getWidth();
            }
            result.rescale(Dimension.valueOf(w, h));
            result.repaint();
        }
        return result;
    }

    @Override
    public ComponentProperties createProperties(XFormPresentationXMLObject referencedObject, ComponentInteractionProvider componentInteractionProvider, ChangeListener listener) {
        return new ImageComponentProperties(referencedObject, componentInteractionProvider, listener);
    }

    @Override
    protected PresentationComponent createComponent(UiContainer parent, XFormPresentationXMLObject object, boolean showLines, boolean showImages, EventListener l) {
        return new PresentationImage(parent, object, showLines, showImages, l);
    }
}

