/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.editors;

import java.util.Hashtable;
import java.util.Map;
import oracle.bpm.designer.formdesigner.EventListener;
import oracle.bpm.designer.formdesigner.PresentationDataPanel;
import oracle.bpm.designer.formdesigner.PresentationPanel;
import oracle.bpm.designer.formdesigner.components.PresentationComponent;
import oracle.bpm.draw.Color;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.utils.ColorUtils;
import oracle.bpm.xobject.presentationmodel.XFormPresentation;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;

public class EditorData {
    private Hashtable<XFormPresentationXMLObject, PresentationComponent> hash;
    private PresentationPanel panel;

    public EditorData(PresentationPanel panel) {
        this.panel = panel;
        this.hash = new Hashtable();
    }

    public static boolean setColor(String colorName, UiComponent component) {
        boolean result;
        Color color = ColorUtils.getColor((String)colorName);
        boolean bl = result = color != null;
        if (result) {
            component.setBackground(color);
        }
        component.setOpaque(result);
        return result;
    }

    public boolean isEditable() {
        return this.panel.isEditable();
    }

    public void addToHash(XFormPresentationXMLObject object, PresentationComponent component) {
        this.hash.put(object, component);
    }

    public boolean showLines() {
        return this.panel.showLines();
    }

    public boolean showImages() {
        return this.panel.showImages();
    }

    public EventListener getListener() {
        return this.panel.getListener();
    }

    public Map<XFormPresentationXMLObject, PresentationComponent> getHash() {
        return this.hash;
    }

    public XFormPresentation getPresentation() {
        return this.panel.getPresentation();
    }

    public PresentationDataPanel getDataPanel() {
        return this.panel.getDataPanel();
    }
}

