/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.editors;

import oracle.bpm.designer.DesignerUtils;
import oracle.bpm.designer.formdesigner.ChangeListener;
import oracle.bpm.designer.formdesigner.components.PresentationCell;
import oracle.bpm.designer.formdesigner.components.PresentationComponent;
import oracle.bpm.designer.formdesigner.editors.AbstractComponentEditor;
import oracle.bpm.designer.formdesigner.editors.ComponentEditor;
import oracle.bpm.designer.formdesigner.editors.EditorData;
import oracle.bpm.designer.formdesigner.editors.EditorRegistry;
import oracle.bpm.designer.formdesigner.properties.CellComponentProperties;
import oracle.bpm.designer.formdesigner.properties.ComponentInteractionProvider;
import oracle.bpm.designer.formdesigner.properties.ComponentProperties;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.xobject.presentationmodel.XFormCell;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.presentationmodel.XFormRepeatable;

public class CellComponentEditor
extends AbstractComponentEditor {
    private CellEditorData cellEditorData;
    private final EditorRegistry editorRegistry;

    public CellComponentEditor(EditorRegistry editorRegistry) {
        this.editorRegistry = editorRegistry;
    }

    @Override
    public UiComponent init(Panel p, XFormPresentationXMLObject presentationObject, PresentationComponent changedComponent, EditorData editorData) {
        int componentId;
        ComponentEditor editor;
        XFormPresentationXMLObject existingComponent;
        XFormCell cell = (XFormCell)presentationObject;
        if (!this.setColor(cell.bgcolor, (UiComponent)changedComponent)) {
            PresentationComponent pComponent;
            changedComponent.setBackground(p.getBackground());
            if (p instanceof PresentationComponent && (pComponent = (PresentationComponent)p).getReferencedObject() instanceof XFormRepeatable) {
                XFormRepeatable repeatable = (XFormRepeatable)pComponent.getReferencedObject();
                this.setColor(repeatable.rowevencolor, (UiComponent)changedComponent);
            }
        }
        if (!DesignerUtils.setFColor(cell.fgcolor, (UiComponent)changedComponent)) {
            changedComponent.setForeground(p.getForeground());
        }
        if ((existingComponent = cell.getComponent()) != null && (editor = this.editorRegistry.getEditorFor(componentId = existingComponent.getComponentID())) != null) {
            changedComponent.add(editor.init(changedComponent, existingComponent, editorData));
        }
        return changedComponent;
    }

    @Override
    public UiComponent init(PresentationComponent p, XFormPresentationXMLObject cell, EditorData editorData) {
        PresentationCell result = new PresentationCell((UiContainer)p, cell, editorData.showLines(), editorData.showImages(), editorData.getListener());
        result.setCellEditorData(this.cellEditorData);
        result.setDataPanel(editorData.getDataPanel());
        return this.doInit(p, cell, editorData, (PresentationComponent)result);
    }

    public PresentationComponent init(PresentationComponent containerTable, XFormCell cell, EditorData editorData, CellEditorData cellEditorData) {
        this.setCellEditorData(cellEditorData);
        PresentationComponent result = (PresentationComponent)this.init(containerTable, cell, editorData);
        this.setCellEditorData(null);
        return result;
    }

    @Override
    public ComponentProperties createProperties(XFormPresentationXMLObject referencedObject, ComponentInteractionProvider componentInteractionProvider, ChangeListener listener) {
        return new CellComponentProperties(referencedObject, componentInteractionProvider, listener);
    }

    private void setCellEditorData(CellEditorData cellEditorData) {
        this.cellEditorData = cellEditorData;
    }

    public static class CellEditorData {
        private final CellConstraints constraints;
        private final boolean isInArray;

        public CellEditorData(boolean isInArray, CellConstraints constraints) {
            this.isInArray = isInArray;
            this.constraints = constraints;
        }

        public boolean isInArray() {
            return this.isInArray;
        }

        public CellConstraints getConstraints() {
            return this.constraints;
        }
    }
}

