/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.editors;

import oracle.bpm.designer.DesignerUtils;
import oracle.bpm.designer.formdesigner.ChangeListener;
import oracle.bpm.designer.formdesigner.CommandManager;
import oracle.bpm.designer.formdesigner.command.ModifyPropertyValueCommand;
import oracle.bpm.designer.formdesigner.components.PresentationArray;
import oracle.bpm.designer.formdesigner.components.PresentationComponent;
import oracle.bpm.designer.formdesigner.components.PresentationRow;
import oracle.bpm.designer.formdesigner.editors.AbstractComponentEditor;
import oracle.bpm.designer.formdesigner.editors.EditorData;
import oracle.bpm.designer.formdesigner.editors.EditorRegistry;
import oracle.bpm.designer.formdesigner.editors.RowComponentEditor;
import oracle.bpm.designer.formdesigner.properties.ArrayComponentProperties;
import oracle.bpm.designer.formdesigner.properties.ComponentInteractionProvider;
import oracle.bpm.designer.formdesigner.properties.ComponentProperties;
import oracle.bpm.draw.Font;
import oracle.bpm.ui.FontStyle;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.border.BorderFactory;
import oracle.bpm.ui.event.FocusEvent;
import oracle.bpm.ui.event.FocusListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.presentationmodel.XFormRepeatable;
import oracle.bpm.xobject.presentationmodel.XFormRow;

class ArrayComponentEditor
extends AbstractComponentEditor {
    private final EditorRegistry registry;

    public ArrayComponentEditor(EditorRegistry registry) {
        this.registry = registry;
    }

    public static int getHorizontalTextPosition(String halign) {
        int result = 4;
        if (halign != null) {
            if (halign.equals("left")) {
                result = 2;
            } else if (halign.equals("center")) {
                result = 0;
            } else if (halign.equals("leading")) {
                result = 10;
            } else if (halign.equals("trailing")) {
                result = 11;
            }
        }
        return result;
    }

    @Override
    public UiComponent init(Panel container, XFormPresentationXMLObject presentationObject, final PresentationComponent parent, EditorData editorData) {
        final XFormRepeatable array = (XFormRepeatable)presentationObject;
        XFormRow row = array.row;
        String rows = "5dlu,pref,5dlu,pref,5dlu";
        String cols = "5dlu";
        for (int i = 0; i < row.cell.length; ++i) {
            cols = cols + ",pref,5dlu";
        }
        FormLayout form = new FormLayout(cols, rows);
        CellConstraints cc = form.createCellConstraints();
        parent.setLayout((Layout)form);
        Font labelFont = parent.getFont();
        if (array.isHeaderenabled()) {
            FontStyle style;
            Font font;
            if (array.getHeaderfonttype() != null && !array.getHeaderfonttype().trim().equals("") && (font = fontDecoder.decodeFont(array.getId(), array.getHeaderfonttype())) != null) {
                labelFont = font;
            }
            if ((style = array.getHeaderFontStyle()) != null) {
                labelFont = labelFont.applyStyle(style);
            }
            if (array.getHeaderfontsize() > 0) {
                labelFont = labelFont.resize(array.getHeaderfontsize());
            }
            for (int i = 0; i < row.cell.length; ++i) {
                int width;
                final TextField label = new TextField((UiContainer)parent);
                final int currentRow = i;
                label.setBorder(BorderFactory.createEmptyBorder((int)2, (int)2, (int)2, (int)2));
                label.setFont(labelFont);
                label.setEditable(editorData.isEditable());
                this.setColor(array.getHeaderbgcolor(), (UiComponent)label);
                if (array.alignment != null) {
                    label.setHorizontalAlignment(ArrayComponentEditor.getHorizontalTextPosition(array.alignment));
                }
                DesignerUtils.setFColor(array.getHeaderfgcolor(), (UiComponent)label);
                int hexpand = array.getWidth(i);
                int n = width = hexpand == 0 ? 1 : hexpand;
                if (array.headers != null && array.headers.length > i && array.headers[i] != null) {
                    label.setText(array.headers[i]);
                }
                label.addFocusListener(new FocusListener(){

                    public void focusGained(FocusEvent e) {
                    }

                    public void focusLost(FocusEvent e) {
                        ArrayComponentEditor.this.check(label.getText(), currentRow, array, parent);
                    }
                });
                parent.add((UiComponent)label, cc.xyw((i + 1) * 2, 2, width));
            }
        }
        parent.setOpaque(false);
        this.setColor(array.getBgcolor(), (UiComponent)parent);
        DesignerUtils.setFColor(array.getFgcolor(), (UiComponent)parent);
        RowComponentEditor rowEditor = (RowComponentEditor)this.registry.getEditorFor(10);
        RowComponentEditor.RowEditorData rowEditorData = new RowComponentEditor.RowEditorData(cc, false, -1, 1, true);
        PresentationRow presR = rowEditor.init(parent, row, editorData, rowEditorData);
        parent.add((UiComponent)presR, cc.xy(1, 4));
        return parent;
    }

    @Override
    public UiComponent init(PresentationComponent changedComponent, XFormPresentationXMLObject existingComponent, EditorData editorData) {
        PresentationArray result = new PresentationArray((UiContainer)changedComponent, existingComponent, editorData.showLines(), editorData.showImages(), editorData.getListener());
        return this.doInit(changedComponent, existingComponent, editorData, (PresentationComponent)result);
    }

    @Override
    public ComponentProperties createProperties(XFormPresentationXMLObject referencedObject, ComponentInteractionProvider componentInteractionProvider, ChangeListener listener) {
        return new ArrayComponentProperties(referencedObject, componentInteractionProvider, listener);
    }

    private void check(String newText, int currentCol, XFormRepeatable array, PresentationComponent presentationArray) {
        String xx;
        String string = array.headers == null || array.headers.length <= currentCol ? "" : (xx = array.headers[currentCol] == null ? "" : array.headers[currentCol]);
        if (!newText.equals(xx)) {
            int length = array.headers == null ? array.row.cell.length : array.headers.length;
            String[] newArray = new String[length];
            for (int i = 0; i < length; ++i) {
                newArray[i] = array.headers != null ? array.headers[i] : "";
                if (i != currentCol) continue;
                newArray[i] = newText;
            }
            ModifyPropertyValueCommand comm = new ModifyPropertyValueCommand(array, newArray, "headers");
            CommandManager.invokeCommand(comm);
            presentationArray.revalidate();
        }
    }
}

