/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.editors;

import oracle.bpm.designer.DesignerUtils;
import oracle.bpm.designer.formdesigner.components.PresentationComponent;
import oracle.bpm.designer.formdesigner.editors.ComponentEditor;
import oracle.bpm.designer.formdesigner.editors.EditorData;
import oracle.bpm.draw.Font;
import oracle.bpm.ui.FontStyle;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.xobject.presentationmodel.ColorProperties;
import oracle.bpm.xobject.presentationmodel.FontProperties;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.xml.XFormXMLObject;

abstract class AbstractComponentEditor
implements ComponentEditor {
    AbstractComponentEditor() {
    }

    public boolean setColor(String color, UiComponent component) {
        return EditorData.setColor(color, component);
    }

    protected void setFont(UiComponent component, Font font) {
        component.setFont(font);
        if (component instanceof UiContainer) {
            UiContainer container = (UiContainer)component;
            for (UiComponent child : container.getChildren()) {
                this.setFont(child, font);
            }
        }
    }

    protected void initComponentColors(PresentationComponent component, XFormXMLObject object) {
        if (object != null && object instanceof ColorProperties) {
            String fgColor;
            ColorProperties colorProperies = (ColorProperties)((Object)object);
            UiComponent coloredComponent = component.getComponent();
            String bgColor = colorProperies.getBgcolor();
            if (bgColor != null && !bgColor.trim().equals("")) {
                this.setColor(bgColor, coloredComponent);
                for (int i = 0; i < coloredComponent.getComponentCount(); ++i) {
                    this.setColor(bgColor, coloredComponent.getComponent(i));
                }
            }
            if ((fgColor = colorProperies.getFgcolor()) != null && !fgColor.trim().equals("")) {
                this.setFgColor(coloredComponent, fgColor);
            }
        }
    }

    protected void initComponentFont(PresentationComponent component, XFormPresentationXMLObject object) {
        if (object != null && object instanceof FontProperties) {
            FontStyle style;
            Font font;
            FontProperties fontComp = (FontProperties)((Object)object);
            Font defaultFont = component.getFont();
            if (fontComp.getFonttype() != null && !fontComp.getFonttype().trim().equals("") && (font = fontDecoder.decodeFont(object.getId(), fontComp.getFonttype())) != null) {
                defaultFont = font;
            }
            if ((style = fontComp.getFontStyle()) != null) {
                defaultFont = defaultFont.applyStyle(style);
            }
            if (fontComp.getFontsize() > 0) {
                defaultFont = defaultFont.resize(fontComp.getFontsize());
            }
            if (component.getComponent() != null) {
                this.setFont(component.getComponent(), defaultFont);
            }
        }
    }

    protected UiComponent doInit(PresentationComponent changedComponent, XFormPresentationXMLObject existingComponent, EditorData editorData, PresentationComponent addedComponent) {
        addedComponent.setContainer(changedComponent);
        return this.doInit((Panel)changedComponent, existingComponent, editorData, addedComponent);
    }

    protected UiComponent doInit(Panel changedComponent, XFormPresentationXMLObject existingComponent, EditorData editorData, PresentationComponent addedComponent) {
        editorData.addToHash(existingComponent, addedComponent);
        addedComponent.setComponentEditor(this);
        return this.init(changedComponent, existingComponent, addedComponent, editorData);
    }

    private void setFgColor(UiComponent component, String fgColor) {
        DesignerUtils.setFColor(fgColor, component);
        for (int i = 0; i < component.getComponentCount(); ++i) {
            this.setFgColor(component.getComponent(i), fgColor);
        }
    }
}

