/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.components.dnd;

import java.util.ArrayList;
import oracle.bpm.designer.formdesigner.PresentationDataPanel;
import oracle.bpm.designer.formdesigner.components.PresentationCell;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.Kind;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.xobject.lib.XObjectTypeDescriptionHelper;
import oracle.bpm.xobject.presentationmodel.XFormPresentationModelHelper;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.presentationmodel.XFormTable;

public class MemberComponentBuilder {
    private AttributeTypeDescription attr;
    private boolean canDrag = false;
    private String mustAddInGroup = null;
    private ObjectTypeDescription topLevelObject;

    private MemberComponentBuilder(AttributeTypeDescription attr) {
        this.attr = attr;
        this.canDrag = MemberComponentBuilder.hasKindSupport(attr.getResultType().getKind());
        ObjectTypeDescription parent = attr.getParent().asObject();
        if (parent.isInnerType()) {
            ObjectTypeDescription otd;
            this.topLevelObject = otd = parent.getParent().asObject();
            String groupName = attr.getParent().getName();
            this.mustAddInGroup = groupName = Character.toLowerCase(groupName.charAt(0)) + groupName.substring(1);
        } else {
            this.topLevelObject = parent;
            this.canDrag = this.canDrag || attr.getResultType().isBpmObject() || XObjectTypeDescriptionHelper.isGroup((AttributeTypeDescription)attr);
        }
    }

    public static boolean canCreateXFormComponent(MethodTypeDescription attr, PresentationCell where, PresentationDataPanel dataPanel) {
        if (attr.isAttribute()) {
            MemberComponentBuilder temp = new MemberComponentBuilder(attr.asAttribute());
            return temp.canDrop(where, dataPanel);
        }
        return false;
    }

    public static XFormPresentationXMLObject createXFormComponent(MethodTypeDescription mtd, PresentationCell presentationCell, PresentationDataPanel dataPanel) {
        if (mtd.isAttribute()) {
            MemberComponentBuilder temp = new MemberComponentBuilder(mtd.asAttribute());
            return temp.getPresentationObject(presentationCell, dataPanel);
        }
        return null;
    }

    private static String[] getPrimitiveSupportedAttributeNames(ObjectTypeDescription otd) {
        ArrayList<String> list = new ArrayList<String>();
        for (MethodTypeDescription member : otd.getAttributes()) {
            if (!MemberComponentBuilder.hasKindSupport(member.getResultType().getKind())) continue;
            list.add(member.getName());
        }
        return list.toArray(new String[list.size()]);
    }

    private static boolean hasKindSupport(int kind) {
        return Kind.isPredefined(kind) && kind != 8 && kind != 10 && kind != 0;
    }

    private XFormPresentationXMLObject getComponent() {
        XFormPresentationXMLObject compo = null;
        if (this.mustAddInGroup == null) {
            if (this.attr.getResultType().isBpmObject()) {
                compo = this.createTable();
            } else if (XObjectTypeDescriptionHelper.isGroup((AttributeTypeDescription)this.attr)) {
                ObjectTypeDescription groupType = this.attr.getResultType().getElementType().asObject();
                String[] groupAttrs = MemberComponentBuilder.getPrimitiveSupportedAttributeNames(groupType);
                compo = XFormPresentationModelHelper.createTopLevelArray(this.attr.getName(), groupAttrs, groupType);
            } else {
                compo = XFormPresentationModelHelper.createTopLevelInputForAttribute(this.attr);
            }
        } else if (!this.attr.getResultType().isBpmObject()) {
            compo = XFormPresentationModelHelper.createGroupInputForAttribute(this.attr, this.mustAddInGroup);
        }
        return compo;
    }

    private XFormPresentationXMLObject getPresentationObject(PresentationCell presentationCell, PresentationDataPanel dataPanel) {
        boolean canDrop = this.canDrop(presentationCell, dataPanel);
        return canDrop ? this.getComponent() : null;
    }

    private boolean canDrop(PresentationCell presentationCell, PresentationDataPanel dataPanel) {
        assert (presentationCell != null);
        boolean isOk = this.canDrag;
        PresentationDataPanel dataProvider = dataPanel;
        if (isOk) {
            boolean isSameXo;
            isOk = isSameXo = dataProvider.getCurrentObject().equals(this.topLevelObject);
        }
        if (isOk) {
            boolean rightLevel;
            String ref = dataProvider.getGroupReferenceFor(presentationCell.getReferencedObject());
            isOk = rightLevel = ref != null && ref.equals(this.mustAddInGroup) || ref == null && this.mustAddInGroup == null;
        }
        return isOk;
    }

    private XFormTable createTable() {
        ObjectTypeDescription otd = this.attr.getResultType().asObject();
        String[] array = MemberComponentBuilder.getPrimitiveSupportedAttributeNames(otd);
        return XFormPresentationModelHelper.createTopLevelTableForAttribute(this.attr, array);
    }
}

