/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.components;

import oracle.bpm.designer.formdesigner.EventListener;
import oracle.bpm.designer.formdesigner.components.PresentationComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.xobject.presentationmodel.XFormCell;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.presentationmodel.XFormRow;
import oracle.bpm.xobject.presentationmodel.XFormTable;

public class PresentationTable
extends PresentationComponent {
    boolean[][] occupied;
    private Occupants occupants;

    public PresentationTable(UiContainer parent, XFormPresentationXMLObject object, boolean showLines, boolean showImages, EventListener listener) {
        super(parent, object, showLines, showImages, listener);
    }

    public int getNext(int i, int row, XFormCell cell) {
        int hexpand = cell.hexpand;
        int vexpand = cell.vexpand;
        return this.getNext(i, row, cell, hexpand, vexpand);
    }

    public int getNext(int i, int row, XFormCell cell, int hexpand, int vexpand) {
        if (this.occupied == null) {
            this.occupied = new boolean[this.getTotalRows()][this.getModelTotalColumns()];
        }
        int currentI = i;
        while (this.occupied[row][currentI]) {
            if (++currentI != this.occupied[row].length) continue;
            System.out.println("shouldn happen");
            return i;
        }
        if (hexpand == 0) {
            hexpand = 1;
        }
        if (vexpand == 0) {
            vexpand = 1;
        }
        int verticalCounter = 0;
        while (verticalCounter < vexpand) {
            int currentRow = row + verticalCounter;
            ++verticalCounter;
            if (currentRow >= this.occupied.length) continue;
            for (int counter = 0; counter < hexpand; ++counter) {
                if (counter + currentI >= this.occupied[currentRow].length || this.occupied[currentRow][counter + currentI]) continue;
                this.occupied[currentRow][counter + currentI] = true;
            }
        }
        return currentI;
    }

    public Occupants getOccupants() {
        if (this.occupants == null) {
            this.recreateOccupants();
        }
        return this.occupants;
    }

    public Occupants recreateOccupants() {
        XFormTable t = (XFormTable)this.getReferencedObject();
        this.occupants = new Occupants(this.getTotalRows(), this.getModelTotalColumns());
        for (int row = 0; row < t.row.length; ++row) {
            int currentColumn = 0;
            for (int column = 0; column < t.row[row].cell.length; ++column) {
                while (this.occupants.occupied(row, currentColumn)) {
                    ++currentColumn;
                }
                this.occupants.doOccupie(row, currentColumn, t.row[row].cell[column], t.row[row]);
            }
        }
        return this.occupants;
    }

    public void restartOcupied() {
        this.occupied = null;
        this.occupants = null;
    }

    private int getModelTotalColumns() {
        return ((XFormTable)this.getReferencedObject()).getModelTotalColumnWidth();
    }

    private int getTotalRows() {
        XFormRow[] array = ((XFormTable)this.getReferencedObject()).row;
        return array != null ? array.length : 0;
    }

    private static class Occupant {
        private XFormCell cell;
        private XFormRow containingRow;

        public Occupant(XFormCell cell, XFormRow containingRow) {
            this.cell = cell;
            this.containingRow = containingRow;
        }
    }

    public static class Occupants {
        Occupant[][] occupants;

        public Occupants(int rows, int columns) {
            this.occupants = new Occupant[rows][columns];
        }

        public int getBackMoves(XFormCell xFormCell, int destinyPos) {
            for (int row = 0; row < this.occupants.length; ++row) {
                for (int column = 0; column < this.occupants[row].length; ++column) {
                    if (this.occupants[row][column].cell != xFormCell) continue;
                    XFormRow containingRow = this.occupants[row][column].containingRow;
                    int destiny = 0;
                    for (int i = 0; i < column; ++i) {
                        if ((destinyPos -= ((Occupant)this.occupants[row][i]).cell.hexpand) < 0 || this.occupants[row][i].containingRow != containingRow) continue;
                        ++destiny;
                    }
                    return containingRow.cell.length - 1 - destiny;
                }
            }
            return 0;
        }

        public int getHorizontalPositionFor(XFormCell xFormCell) {
            for (int row = 0; row < this.occupants.length; ++row) {
                for (int column = 0; column < this.occupants[row].length; ++column) {
                    if (this.occupants[row][column].cell != xFormCell) continue;
                    int hPos = 0;
                    for (int j = column - 1; j >= 0; --j) {
                        hPos += ((Occupant)this.occupants[row][j]).cell.hexpand;
                    }
                    return hPos;
                }
            }
            return 0;
        }

        public void add(int row, int column, XFormCell cell, XFormRow xFormRow) {
            this.occupants[row][column] = new Occupant(cell, xFormRow);
        }

        public void doOccupie(int row, int currentColumn, XFormCell xFormCell, XFormRow containerRow) {
            for (int i = 0; i < xFormCell.vexpand; ++i) {
                for (int j = 0; j < xFormCell.hexpand; ++j) {
                    this.add(row + i, currentColumn + j, xFormCell, containerRow);
                }
            }
        }

        public boolean occupied(int row, int column) {
            return this.occupants[row][column] != null;
        }
    }
}

